/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;

public class CertId {
    private static final boolean debug = false;
    private static final AlgorithmId SHA1_ALGID = new AlgorithmId(AlgorithmId.SHA_oid);
    private final AlgorithmId hashAlgId;
    private final byte[] issuerNameHash;
    private final byte[] issuerKeyHash;
    private final SerialNumber certSerialNumber;
    private int myhash = -1;

    public CertId(X509Certificate issuerCert, SerialNumber serialNumber) throws IOException {
        this(issuerCert.getSubjectX500Principal(), issuerCert.getPublicKey(), serialNumber);
    }

    public CertId(X500Principal issuerName, PublicKey issuerKey, SerialNumber serialNumber) throws IOException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException("Unable to create CertId", nsae);
        }
        this.hashAlgId = SHA1_ALGID;
        md.update(issuerName.getEncoded());
        this.issuerNameHash = md.digest();
        byte[] pubKey = issuerKey.getEncoded();
        DerValue val = new DerValue(pubKey);
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue()};
        byte[] keyBytes = seq[1].getBitString();
        md.update(keyBytes);
        this.issuerKeyHash = md.digest();
        this.certSerialNumber = serialNumber;
    }

    public CertId(DerInputStream derIn) throws IOException {
        this.hashAlgId = AlgorithmId.parse((DerValue)derIn.getDerValue());
        this.issuerNameHash = derIn.getOctetString();
        this.issuerKeyHash = derIn.getOctetString();
        this.certSerialNumber = new SerialNumber(derIn);
    }

    public AlgorithmId getHashAlgorithm() {
        return this.hashAlgId;
    }

    public byte[] getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public byte[] getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public BigInteger getSerialNumber() {
        return this.certSerialNumber.getNumber();
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.hashAlgId.encode(tmp);
        tmp.putOctetString(this.issuerNameHash);
        tmp.putOctetString(this.issuerKeyHash);
        this.certSerialNumber.encode(tmp);
        out.write((byte)48, tmp);
    }

    public int hashCode() {
        if (this.myhash == -1) {
            int i;
            this.myhash = this.hashAlgId.hashCode();
            for (i = 0; i < this.issuerNameHash.length; ++i) {
                this.myhash += this.issuerNameHash[i] * i;
            }
            for (i = 0; i < this.issuerKeyHash.length; ++i) {
                this.myhash += this.issuerKeyHash[i] * i;
            }
            this.myhash += this.certSerialNumber.getNumber().hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof CertId)) {
            return false;
        }
        CertId that = (CertId)other;
        return this.hashAlgId.equals(that.getHashAlgorithm()) && Arrays.equals(this.issuerNameHash, that.getIssuerNameHash()) && Arrays.equals(this.issuerKeyHash, that.getIssuerKeyHash()) && this.certSerialNumber.getNumber().equals(that.getSerialNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CertId \n");
        sb.append("Algorithm: " + this.hashAlgId.toString() + "\n");
        sb.append("issuerNameHash \n");
        HexDumpEncoder encoder = new HexDumpEncoder();
        sb.append(encoder.encode(this.issuerNameHash));
        sb.append("\nissuerKeyHash: \n");
        sb.append(encoder.encode(this.issuerKeyHash));
        sb.append("\n" + this.certSerialNumber.toString());
        return sb.toString();
    }
}

