/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collective.singleton.internal.ElectorPort;
import com.ibm.ws.collective.singleton.internal.HostSingletonElector;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HostLeader {
    private static final TraceComponent tc = Tr.register(HostLeader.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
    private int port;
    private ServerSocketChannel channel;
    private HostSingletonElector elector;
    private ServiceEndpointIdentity id;
    ElectorPort portMonitor;
    static final long serialVersionUID = -2250927252569048525L;

    protected HostLeader(int port, ServerSocketChannel channel, HostSingletonElector elector, ElectorPort portMonitor) throws IOException {
        this.channel = channel;
        this.portMonitor = portMonitor;
        this.init(port, elector);
    }

    protected HostLeader(int port, HostSingletonElector elector) throws IOException {
        this.init(port, elector);
    }

    private void init(int port, HostSingletonElector elector) throws IOException {
        if (elector == null) {
            throw new IllegalArgumentException("The specified elector must not be null.");
        }
        this.id = elector.getLocalCandidate() != null ? elector.getLocalCandidate() : elector.getLocalParticipant();
        this.port = port;
        this.elector = elector;
        this.portMonitor = this.getPortMonitor(this.port, elector);
        this.portMonitor.openForMonitoring();
    }

    protected void monitorMembers() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("In HostLeader.monitorMembers.  PortMonitor is " + this.portMonitor), (Object[])new Object[0]);
        }
        this.portMonitor.monitorMembers();
    }

    protected void stop() {
        if (this.portMonitor != null) {
            this.portMonitor.stop();
            this.portMonitor = null;
        }
    }

    private ElectorPort getPortMonitor(int port, HostSingletonElector elector) throws IOException {
        if (this.portMonitor == null) {
            this.portMonitor = new ElectorPort(port, this.id, elector);
        }
        return this.portMonitor;
    }
}

