/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.security.capi.CKey;
import com.ibm.security.capi.JarVerifierImpl;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.security.action.PutAllAction;

public final class IBMCAC
extends Provider {
    private static final long serialVersionUID = 8622598936488630849L;
    private static final String INFO = "IBM Crypto API for CAC JCE provider";
    static boolean debug = false;
    static String DEBUGHEADER = "IBMCAC-";
    private static volatile boolean integrityVerified;

    public IBMCAC() {
        super("IBMCAC", 1.8, INFO);
        Map<Object, Object> map = System.getSecurityManager() == null ? this : new HashMap();
        map.put("SecureRandom.Windows-PRNG", "com.ibm.security.capi.PRNG");
        map.put("KeyStore.Windows-MY", "com.ibm.security.capi.CKeyStore$MY");
        map.put("KeyStore.Windows-ROOT", "com.ibm.security.capi.CKeyStore$ROOT");
        map.put("KeyStore.WIExplorerMy", "com.ibm.security.capi.CKeyStore$MY");
        map.put("Signature.NONEwithRSA", "com.ibm.security.capi.CSignature$NONEwithRSA");
        map.put("Signature.RSAforSSL", "com.ibm.security.capi.CSignature$NONEwithRSA");
        map.put("Signature.SHA1withRSA", "com.ibm.security.capi.CSignature$SHA1withRSA");
        map.put("Signature.SHA256withRSA", "com.ibm.security.capi.CSignature$SHA256withRSA");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", "SHA256withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.11", "SHA256withRSA");
        map.put("Signature.SHA384withRSA", "com.ibm.security.capi.CSignature$SHA384withRSA");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", "SHA384withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.12", "SHA384withRSA");
        map.put("Signature.SHA512withRSA", "com.ibm.security.capi.CSignature$SHA512withRSA");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", "SHA512withRSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.13", "SHA512withRSA");
        map.put("Signature.MD5withRSA", "com.ibm.security.capi.CSignature$MD5withRSA");
        map.put("Signature.MD2withRSA", "com.ibm.security.capi.CSignature$MD2withRSA");
        map.put("Signature.RSAPSS", "com.ibm.security.capi.CSignature$PSS");
        map.put("Alg.Alias.Signature.1.2.840.113549.1.1.10", "RSAPSS");
        map.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.10", "RSAPSS");
        map.put("Signature.NONEwithRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.RSAforSSL SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.SHA1withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.SHA256withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.SHA384withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.SHA512withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.MD5withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.MD2withRSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.RSAPSS SupportedKeyClasses", "com.ibm.security.capi.CKey");
        map.put("Signature.NONEwithRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.RSAforSSL SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA1withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA256withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA384withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.SHA512withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.MD5withRSA SupportedKeyFormats", "MSCAPI");
        map.put("Signature.MD2withRSA SupportedKeyFormats", "MSCAPI");
        map.put("KeyPairGenerator.RSA", "com.ibm.security.capi.CKeyPairGenerator$RSA");
        map.put("KeyPairGenerator.RSA KeySize", "2048");
        map.put("Cipher.RSA", "com.ibm.security.capi.CRSACipher");
        map.put("Cipher.RSA/ECB/PKCS1Padding", "com.ibm.security.capi.CRSACipher");
        map.put("Cipher.RSA SupportedModes", "ECB");
        map.put("Cipher.RSA SupportedPaddings", "PKCS1PADDING");
        map.put("Cipher.RSA SupportedKeyClasses", "com.ibm.security.capi.CKey");
        if (map != this) {
            AccessController.doPrivileged(new PutAllAction(this, map));
        }
    }

    static void verifySelfIntegrity(Class clazz) {
        if (integrityVerified) {
            return;
        }
        IBMCAC.doVerifySelfIntegrity(clazz);
    }

    private static synchronized void doVerifySelfIntegrity(Class clazz) {
        integrityVerified = JarVerifierImpl.doVerification(clazz, "-----BEGIN CERTIFICATE-----\nMIIDszCCApugAwIBAgIEYImVuTANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRowGAYDVQQLExFJQk0gSmF2YSBTZWN1cml0eTEdMBsGA1UEAxMUSUJNIEphdmEgU2VjdXJpdHkgQ0EwHhcNMjEwNDI4MTcwNDU3WhcNMjcwNDI3MTcwNDU3WjBoMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRkwFwYDVQQLExBJQk0gQ29kZSBTaWduaW5nMSQwIgYDVQQDExtKQ0UgQ29kZSBTaWduaW5nIC0gUHJvdmlkZXIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCl0FmNEezhBnZpXAdCtA8IceqymiXiRfwgLdS6tOqCnZI1ceUg5OcO+DZYIuASvGoWZfSocwInBdDqYE5tSDP0a5KT5RNFE1NsmUs2tTw+HW6A/abt1zeRm9RPZrBXAIQNcIzd9HSqx29wyVACnjP6zn/HjnlK7kjK9wO75JShUaR8jI68gV4bmOipo0IP4vrr8U+RTCd5sx3uOAxIjvB1awcGzNOUWvoHZ15HGDeSS1MgbGBhkgcTsHz7eZZH3WBgn9gDfS6vvTf/sMKhBy/ETK9S5XuNK0JHlEpj4y7dmCmZRixGOFCvnDyYacYEx+DdLE+269aNpFHzBWcglGFXAgMBAAGjazBpMCsGA1UdIwQkMCKAIK6JRGFBAKBlTf5a/G8eW1GvoqC1KpJrNEp/qHwjeoIQMA8GA1UdEwEB/wQFMAMBAf8wKQYDVR0OBCIEIK6JRGFBAKBlTf5a/G8eW1GvoqC1KpJrNEp/qHwjeoIQMA0GCSqGSIb3DQEBCwUAA4IBAQCXehga9+p7p3vZToi9Sqo3CAVImBAQC8nHBVHb62d1EJlHRFuogZWG/eGLoEStqWiYKCl1jpYwky/JqmBP4DJ3T5JgIK9WQYllrTXD7aZhd8lhQNUa7G4X51ORy0aBkF2Nr2H3MviJl6g5rUonNVGSZy1fDmf0S0MhNTjwNF47ReKo0RV7DCWzPhoeqoT4M1cz7LTYdKXjGtWz66CY0FoyRafo8tC/jFygEAVK8Kj2G78Fy+DFR7HffNErNKjRY8bZH3GgH27u/Eip1rTQCk6i1bkM53rI1eRiHJeGTAyLSvbGAvFu1SjevsL+RhKm9HURt9OWWvXo46x2yn0bpwEd\n-----END CERTIFICATE-----");
        if (!integrityVerified) {
            throw new ProviderException("The IBMCAC provider may have been tampered with.");
        }
    }

    private static String getDebugDate(String string) {
        String string2 = "Unknown";
        try {
            Class<?> clazz = Class.forName(string);
            Package package_ = clazz.getPackage();
            String string3 = package_.getImplementationVersion();
            int n = string3.indexOf("_");
            string2 = string3.substring(n + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("ibmcac");
                debug = Boolean.getBoolean("com.ibm.security.cac.debug");
                if (debug) {
                    System.out.println("IBMCAC Build-Level: -" + IBMCAC.getDebugDate("com.ibm.security.capi.IBMCAC"));
                    System.out.println("loading IBMCAC provider");
                }
                return null;
            }
        });
    }

    private static class IBMCACService
    extends Provider.Service {
        private final Provider provider;
        private final String algorithm;

        IBMCACService(Provider provider, String string, String string2, String string3, String[] stringArray) {
            super(provider, string, string2, string3, IBMCACService.toList(stringArray), null);
            this.provider = provider;
            this.algorithm = string2;
        }

        private static List<String> toList(String[] stringArray) {
            return stringArray == null ? null : Arrays.asList(stringArray);
        }

        @Override
        public boolean supportsParameter(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof CKey)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String string = this.getAlgorithm();
            String string2 = this.getType();
            CKey cKey = (CKey)object;
            String string3 = cKey.getAlgorithm();
            return cKey instanceof CKey;
        }

        @Override
        public String toString() {
            return super.toString() + "\nprovider = " + this.provider + "\nalgorithm = " + this.algorithm;
        }
    }
}

