/*
 * Decompiled with CFR 0.152.
 */
package openj9.management.internal;

import com.ibm.oti.util.Util;
import java.util.Arrays;
import java.util.Objects;
import openj9.management.internal.LockInfoBase;
import openj9.management.internal.MonitorInfoBase;

public class ThreadInfoBase {
    private final long threadId;
    private final long nativeTId;
    private final String threadName;
    private final Thread.State threadState;
    private final boolean suspended;
    private final boolean inNative;
    private final long blockedCount;
    private final long blockedTime;
    private final long waitedCount;
    private final long waitedTime;
    private final String lockName;
    private final long lockOwnerId;
    private final String lockOwnerName;
    private StackTraceElement[] stackTrace = new StackTraceElement[0];
    private final LockInfoBase blockingLockInfo;
    private LockInfoBase[] lockedSynchronizers = new LockInfoBase[0];
    private MonitorInfoBase[] lockedMonitors = new MonitorInfoBase[0];
    private String cachedToStringResult;

    public ThreadInfoBase(long threadIdVal, String threadNameVal, Thread.State threadStateVal, boolean suspendedVal, boolean inNativeVal, long blockedCountVal, long blockedTimeVal, long waitedCountVal, long waitedTimeVal, String lockNameVal, long lockOwnerIdVal, String lockOwnerNameVal, StackTraceElement[] stackTraceVal, LockInfoBase lockInfoVal, MonitorInfoBase[] lockedMonitorsVal, LockInfoBase[] lockedSynchronizersVal) {
        this.threadId = threadIdVal;
        this.nativeTId = -1L;
        this.threadName = threadNameVal;
        this.threadState = threadStateVal;
        this.suspended = suspendedVal;
        this.inNative = inNativeVal;
        this.blockedCount = blockedCountVal;
        this.blockedTime = blockedTimeVal;
        this.waitedCount = waitedCountVal;
        this.waitedTime = waitedTimeVal;
        this.lockName = lockNameVal;
        this.lockOwnerId = lockOwnerIdVal;
        this.lockOwnerName = lockOwnerNameVal;
        this.stackTrace = stackTraceVal;
        this.blockingLockInfo = lockInfoVal;
        this.lockedMonitors = lockedMonitorsVal;
        this.lockedSynchronizers = lockedSynchronizersVal;
    }

    private ThreadInfoBase(Thread thread, long nativeId, int state, boolean isSuspended, boolean isInNative, long blockedCountVal, long blockedTimeVal, long waitedCountVal, long waitedTimeVal, StackTraceElement[] stackTraceVal, Object blockingObject, Thread blockingObjectOwner, MonitorInfoBase[] lockedMonitorsVal, LockInfoBase[] lockedSynchronizersVal) {
        this.threadId = thread.getId();
        this.nativeTId = nativeId;
        this.threadName = thread.getName();
        this.threadState = Thread.State.values()[state];
        this.suspended = isSuspended;
        this.inNative = isInNative;
        this.blockedCount = blockedCountVal;
        this.blockedTime = blockedTimeVal;
        this.waitedCount = waitedCountVal;
        this.waitedTime = waitedTimeVal;
        if (blockingObjectOwner != null) {
            this.lockOwnerId = blockingObjectOwner.getId();
            this.lockOwnerName = blockingObjectOwner.getName();
        } else {
            this.lockOwnerId = -1L;
            this.lockOwnerName = null;
        }
        this.stackTrace = stackTraceVal;
        this.lockedMonitors = lockedMonitorsVal;
        this.lockedSynchronizers = lockedSynchronizersVal;
        if (blockingObject != null) {
            this.blockingLockInfo = new LockInfoBase(blockingObject.getClass().getName(), System.identityHashCode(blockingObject));
            this.lockName = this.blockingLockInfo.toString();
        } else {
            this.blockingLockInfo = null;
            this.lockName = null;
        }
    }

    public String toString() {
        String ls = System.lineSeparator();
        if (this.cachedToStringResult == null) {
            StringBuilder result = new StringBuilder();
            result.append(String.format("\"%s\" Id=%d %s", new Object[]{this.threadName, this.threadId, this.threadState}));
            if (Thread.State.BLOCKED == this.threadState) {
                result.append(String.format(" on %s owned by \"%s\" Id=%d", this.lockName, this.lockOwnerName, this.lockOwnerId));
            }
            result.append(ls);
            if (this.stackTrace != null && this.stackTrace.length > 0) {
                MonitorInfoBase[] lockArray = new MonitorInfoBase[this.stackTrace.length];
                MonitorInfoBase[] monitorInfoBaseArray = this.lockedMonitors;
                int n = monitorInfoBaseArray.length;
                for (int i = 0; i < n; ++i) {
                    MonitorInfoBase mi;
                    lockArray[mi.getStackDepth()] = mi = monitorInfoBaseArray[i];
                }
                int stackDepth = 0;
                for (StackTraceElement element : this.stackTrace) {
                    result.append("\tat ");
                    Util.printStackTraceElement(element, null, result, true);
                    result.append(ls);
                    MonitorInfoBase mi = lockArray[stackDepth];
                    if (null != mi) {
                        result.append(String.format("\t- locked %s%n", mi.toString()));
                    }
                    ++stackDepth;
                }
            }
            this.cachedToStringResult = result.toString();
        }
        return this.cachedToStringResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof ThreadInfoBase) {
            ThreadInfoBase ti = (ThreadInfoBase)obj;
            result = ti.threadId == this.threadId && ti.blockedCount == this.blockedCount && ti.blockedTime == this.blockedTime && ti.lockOwnerId == this.lockOwnerId && ti.waitedCount == this.waitedCount && ti.waitedTime == this.waitedTime && ti.inNative == this.inNative && ti.suspended == this.suspended && ti.threadName.equals(this.threadName) && ti.threadState.equals((Object)this.threadState) && Objects.equals(ti.lockName, this.lockName) && Objects.equals(ti.lockOwnerName, this.lockOwnerName) && Objects.equals(ti.blockingLockInfo, this.blockingLockInfo) && Arrays.equals(ti.stackTrace, this.stackTrace);
        }
        return result;
    }

    public int hashCode() {
        return (Long.toString(this.blockedCount) + this.blockedTime + this.lockName + this.lockOwnerId + this.lockOwnerName + this.stackTrace.length + this.threadId + this.threadName + (Object)((Object)this.threadState) + this.waitedCount + this.waitedTime + this.inNative + this.suspended).hashCode();
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getNativeTId() {
        return this.nativeTId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public LockInfoBase getBlockingLockInfo() {
        return this.blockingLockInfo;
    }

    public LockInfoBase[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }

    public MonitorInfoBase[] getLockedMonitors() {
        return this.lockedMonitors;
    }
}

