/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class MethodTypeHelper {
    static final Set<Class<?>> WRAPPER_SET;
    static final Class<?>[] primitivesArray;

    MethodTypeHelper() {
    }

    static Class<?> wrapPrimitive(Class<?> primitveClass) {
        if (primitveClass.isPrimitive()) {
            if (Integer.TYPE == primitveClass) {
                return Integer.class;
            }
            if (Long.TYPE == primitveClass) {
                return Long.class;
            }
            if (Byte.TYPE == primitveClass) {
                return Byte.class;
            }
            if (Character.TYPE == primitveClass) {
                return Character.class;
            }
            if (Double.TYPE == primitveClass) {
                return Double.class;
            }
            if (Float.TYPE == primitveClass) {
                return Float.class;
            }
            if (Boolean.TYPE == primitveClass) {
                return Boolean.class;
            }
            if (Void.TYPE == primitveClass) {
                return Void.class;
            }
            if (Short.TYPE == primitveClass) {
                return Short.class;
            }
        }
        return primitveClass;
    }

    static Class<?> unwrapPrimitive(Class<?> wrapperClass) {
        if (Integer.class == wrapperClass) {
            return Integer.TYPE;
        }
        if (Long.class == wrapperClass) {
            return Long.TYPE;
        }
        if (Byte.class == wrapperClass) {
            return Byte.TYPE;
        }
        if (Character.class == wrapperClass) {
            return Character.TYPE;
        }
        if (Double.class == wrapperClass) {
            return Double.TYPE;
        }
        if (Float.class == wrapperClass) {
            return Float.TYPE;
        }
        if (Short.class == wrapperClass) {
            return Short.TYPE;
        }
        if (Boolean.class == wrapperClass) {
            return Boolean.TYPE;
        }
        return wrapperClass;
    }

    static String getBytecodeStringName(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Short.TYPE) {
                return "S";
            }
        }
        Class<?> clazz = c;
        if (c.isArray()) {
            clazz = c.getComponentType();
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
        }
        String name = c.getName().replace('.', '/');
        if (!c.isArray()) {
            name = new StringBuilder(name.length() + 2).append('L').append(name).append(';').toString();
        }
        return name;
    }

    private static final Class<?> nonPrimitiveClassFromString(String name, ClassLoader classLoader) {
        try {
            name = name.replace('/', '.');
            if (name.charAt(0) == 'L') {
                name = name.substring(1, name.length() - 1);
            }
            return Class.forName(name, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    static final int parseIntoClass(char[] signature, int index, ArrayList<Class<?>> args, ClassLoader classLoader, String descriptor) {
        Class<Object> c;
        char current = signature[index];
        if (current == 'L' || current == '[') {
            String name;
            int start = index;
            while (signature[index] == '[') {
                ++index;
            }
            if (signature[index] != 'L') {
                name = descriptor.substring(start, index + 1);
            } else {
                int end = descriptor.indexOf(59, index);
                if (end == -1) {
                    throw new IllegalArgumentException(Msg.getString("K05d6", descriptor));
                }
                name = descriptor.substring(start, end + 1);
                index = end;
            }
            c = MethodTypeHelper.nonPrimitiveClassFromString(name, classLoader);
        } else {
            try {
                c = primitivesArray[current - 65];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                c = null;
            }
            if (c == null) {
                if (current == 'V') {
                    MethodTypeHelper.primitivesArray[21] = Void.TYPE;
                    c = Void.TYPE;
                } else {
                    throw new IllegalArgumentException(Msg.getString("K05d7", current));
                }
            }
        }
        args.add(c);
        return index;
    }

    static final ArrayList<Class<?>> parseIntoClasses(String methodDescriptor, ClassLoader classLoader) {
        int length = methodDescriptor.length();
        if (length == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", methodDescriptor));
        }
        char[] signature = new char[length];
        methodDescriptor.getChars(0, length, signature, 0);
        int index = 0;
        boolean closeBracket = false;
        if (signature[index] != '(') {
            throw new IllegalArgumentException(Msg.getString("K05d4", methodDescriptor));
        }
        ++index;
        ArrayList args = new ArrayList();
        while (index < length) {
            if (signature[index] == ')') {
                if (closeBracket) {
                    throw new IllegalArgumentException(Msg.getString("K05d5", methodDescriptor));
                }
                closeBracket = true;
                ++index;
                continue;
            }
            index = MethodTypeHelper.parseIntoClass(signature, index, args, classLoader, methodDescriptor);
            ++index;
        }
        return args;
    }

    static MethodType fromMethodDescriptorStringInternal(String methodDescriptor, ClassLoader loader) {
        Map<String, MethodType> classLoaderMethodTypeCache;
        MethodType mt;
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        MethodType methodType = mt = (classLoaderMethodTypeCache = VM.getVMLangAccess().getMethodTypeCache(classLoader)) != null ? classLoaderMethodTypeCache.get(methodDescriptor) : null;
        if (null == mt) {
            if (methodDescriptor.indexOf(46) != -1) {
                throw new IllegalArgumentException(methodDescriptor);
            }
            ArrayList<Class<?>> classes = MethodTypeHelper.parseIntoClasses(methodDescriptor, classLoader);
            if (classes.size() == 0) {
                throw new IllegalArgumentException(methodDescriptor);
            }
            Class<?> returnType = classes.remove(classes.size() - 1);
            mt = MethodType.methodType(returnType, classes);
            if (classLoaderMethodTypeCache != null) {
                classLoaderMethodTypeCache.put(mt.toMethodDescriptorString(), mt);
            }
        }
        return mt;
    }

    static final MethodType vmResolveFromMethodDescriptorString(String methodDescriptor, ClassLoader loader, Class<?> appendArgumentType) throws Throwable {
        try {
            MethodType result = MethodTypeHelper.fromMethodDescriptorStringInternal(methodDescriptor, loader);
            if (null != appendArgumentType) {
                result = result.appendParameterTypes(appendArgumentType);
            }
            return result;
        }
        catch (TypeNotPresentException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(cause.getMessage());
                noClassDefFoundError.initCause(cause);
                throw noClassDefFoundError;
            }
            throw e;
        }
    }

    static {
        Class[] wrappers = new Class[]{Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Boolean.class};
        WRAPPER_SET = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(wrappers)));
        primitivesArray = new Class[26];
        MethodTypeHelper.primitivesArray[1] = Byte.TYPE;
        MethodTypeHelper.primitivesArray[2] = Character.TYPE;
        MethodTypeHelper.primitivesArray[3] = Double.TYPE;
        MethodTypeHelper.primitivesArray[5] = Float.TYPE;
        MethodTypeHelper.primitivesArray[8] = Integer.TYPE;
        MethodTypeHelper.primitivesArray[9] = Long.TYPE;
        MethodTypeHelper.primitivesArray[18] = Short.TYPE;
        MethodTypeHelper.primitivesArray[25] = Boolean.TYPE;
    }
}

