/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermission;
import com.ibm.oti.shared.SharedHelper;
import com.ibm.oti.util.Msg;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;

public abstract class SharedAbstractHelper
implements SharedHelper {
    private Boolean verbose;
    private WeakReference<ClassLoader> loaderRef;
    private SharedClassPermission readPerm;
    private SharedClassPermission writePerm;
    boolean canFind;
    boolean canStore;
    int id;

    void initialize(ClassLoader loader, int loaderId, boolean canLoaderFind, boolean canLoaderStore) {
        this.id = loaderId;
        this.canFind = canLoaderFind;
        this.canStore = canLoaderStore;
        this.loaderRef = new WeakReference<ClassLoader>(loader);
        this.printVerboseInfo(Msg.getString("K0591", (Object)this.getHelperType(), this.id));
    }

    @Override
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.loaderRef.get();
    }

    private native boolean getIsVerboseImpl();

    private static boolean checkPermission(SecurityManager sm, ClassLoader loader, String type) {
        boolean result = false;
        try {
            sm.checkPermission(new SharedClassPermission(loader, type));
            result = true;
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return result;
    }

    static boolean checkReadPermission(ClassLoader loader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return SharedAbstractHelper.checkPermission(sm, loader, "read");
        }
        return true;
    }

    static boolean checkWritePermission(ClassLoader loader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return SharedAbstractHelper.checkPermission(sm, loader, "write");
        }
        return true;
    }

    private boolean isVerbose() {
        if (this.verbose == null) {
            boolean verboseSet = this.getIsVerboseImpl();
            this.verbose = verboseSet;
            if (verboseSet) {
                this.printVerboseInfo(Msg.getString("K0592", (Object)this.getHelperType(), this.id));
            }
        }
        return this.verbose;
    }

    void printVerboseError(String message) {
        if (this.isVerbose()) {
            System.err.println(Msg.getString("K0593", this.getHelperType(), Integer.toString(this.id), message));
        }
    }

    void printVerboseInfo(String message) {
        if (this.isVerbose()) {
            System.err.println(Msg.getString("K0594", this.getHelperType(), Integer.toString(this.id), message));
        }
    }

    abstract String getHelperType();
}

