/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaStream;
import com.ibm.cuda.Dim3;

public final class CudaGrid {
    public final int blockDimX;
    public final int blockDimY;
    public final int blockDimZ;
    public final int gridDimX;
    public final int gridDimY;
    public final int gridDimZ;
    public final int sharedMemBytes;
    public final CudaStream stream;

    public CudaGrid(Dim3 gridDim, Dim3 blockDim) {
        this(gridDim, blockDim, 0, null);
    }

    public CudaGrid(Dim3 gridDim, Dim3 blockDim, CudaStream stream) {
        this(gridDim, blockDim, 0, stream);
    }

    public CudaGrid(Dim3 gridDim, Dim3 blockDim, int sharedMemBytes) {
        this(gridDim, blockDim, sharedMemBytes, null);
    }

    public CudaGrid(Dim3 gridDim, Dim3 blockDim, int sharedMemBytes, CudaStream stream) {
        this.blockDimX = blockDim.x;
        this.blockDimY = blockDim.y;
        this.blockDimZ = blockDim.z;
        this.gridDimX = gridDim.x;
        this.gridDimY = gridDim.y;
        this.gridDimZ = gridDim.z;
        this.sharedMemBytes = sharedMemBytes;
        this.stream = stream;
    }

    public CudaGrid(int gridDim, int blockDim) {
        this(gridDim, blockDim, 0, null);
    }

    public CudaGrid(int gridDim, int blockDim, CudaStream stream) {
        this(gridDim, blockDim, 0, stream);
    }

    public CudaGrid(int gridDim, int blockDim, int sharedMemBytes) {
        this(gridDim, blockDim, sharedMemBytes, null);
    }

    public CudaGrid(int gridDim, int blockDim, int sharedMemBytes, CudaStream stream) {
        this.blockDimX = blockDim;
        this.blockDimY = 1;
        this.blockDimZ = 1;
        this.gridDimX = gridDim;
        this.gridDimY = 1;
        this.gridDimZ = 1;
        this.sharedMemBytes = sharedMemBytes;
        this.stream = stream;
    }
}

