/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.ITool;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import java.io.PrintStream;

public class HelpTool
extends Tool {
    public static final String COMMAND = "help";
    public static final String HELP_DESCRIPTION = "to display command help messages";
    public static final String USAGE = "help:\tto display command help messages";
    public static final String JDMPVIEW_HELP_COMMAND = "help";
    public static final String COMMAND_FORMAT = "%-25s %-20s %s";

    @Override
    public boolean accept(String command, String[] args) {
        return command.equalsIgnoreCase("help");
    }

    @Override
    public void process(String command, String[] args, PrintStream redirector) throws CommandException {
        if (args.length == 0) {
            this.printAllHelpMessages(redirector);
        } else {
            String commandToBeHelped = args[0];
            String[] newArgs = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                newArgs[i - 1] = args[i];
            }
            this.printHelpMessages(commandToBeHelped, newArgs, redirector);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return "help";
    }

    @Override
    public String getArgumentDescription() {
        return "";
    }

    @Override
    public String getHelpDescription() {
        return null;
    }

    private void printAllHelpMessages(PrintStream out) {
        ToolsRegistry.executeJdmpviewCommand("help", out);
        for (ITool aTool : ToolsRegistry.getAllTools()) {
            if (aTool instanceof HelpTool) continue;
            out.println(String.format(COMMAND_FORMAT, aTool.getCommandName(), aTool.getArgumentDescription(), aTool.getHelpDescription()));
        }
    }

    private void printHelpMessages(String commandToBeHelped, String[] arguments, PrintStream out) {
        for (ITool aTool : ToolsRegistry.getAllTools()) {
            if (aTool instanceof HelpTool || !aTool.accept(commandToBeHelped, arguments)) continue;
            aTool.printDetailedHelp(out);
            return;
        }
        StringBuffer sb = new StringBuffer("help");
        sb.append(" ").append(commandToBeHelped);
        for (String arg : arguments) {
            sb.append(" ").append(arg);
        }
        ToolsRegistry.executeJdmpviewCommand(sb.toString(), out);
    }
}

