/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.jvm.dtfjview.Session;
import com.ibm.jvm.dtfjview.spi.ISession;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

public class DTFJView {
    private ISession session;

    public static void main(String[] args) {
        DTFJView dtfjView = new DTFJView();
        dtfjView.launch(args);
    }

    public void launch(String[] args) {
        this.setPluginsPath();
        this.session = Session.getInstance(args);
        ((Session)this.session).run();
    }

    private void setPluginsPath() {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader instanceof URLClassLoader) {
            URL[] urls;
            URLClassLoader urlloader = (URLClassLoader)loader;
            for (URL url : urls = urlloader.getURLs()) {
                try {
                    File file = new File(url.toURI());
                    if (file.exists() && file.getName().equalsIgnoreCase("dtfjview.jar")) {
                        this.addSelfToPath(file);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void addSelfToPath(File jar) throws IOException {
        String[] paths;
        String prop = System.getProperty("com.ibm.java.diagnostics.plugins");
        if (prop == null) {
            System.setProperty("com.ibm.java.diagnostics.plugins", jar.getCanonicalPath());
            return;
        }
        for (String path : paths = prop.split(File.pathSeparator)) {
            File file = new File(path);
            if (!file.exists() || !file.equals(jar)) continue;
            return;
        }
        prop = jar.getCanonicalPath() + File.pathSeparator + prop;
        System.setProperty("com.ibm.java.diagnostics.plugins", prop);
    }
}

