/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

public final class ByteArrayUnmarshaller {
    private ByteArrayUnmarshaller() {
    }

    public static short readShort(byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 2 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readShort is trying to access byteArray[" + offset + "] and byteArray[" + (offset + 1) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            return ByteArrayUnmarshaller.readShort_(byteArray, offset, true);
        }
        return ByteArrayUnmarshaller.readShort_(byteArray, offset, false);
    }

    private static short readShort_(byte[] byteArray, int offset, boolean bigEndian) {
        if (bigEndian) {
            return (short)((byteArray[offset] & 0xFF) << 8 | byteArray[offset + 1] & 0xFF);
        }
        return (short)((byteArray[offset + 1] & 0xFF) << 8 | byteArray[offset] & 0xFF);
    }

    public static short readShort(byte[] byteArray, int offset, boolean bigEndian, int numBytes, boolean signExtend) {
        if (offset + numBytes > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Access offset must be positive or zero and last byte must be in range.");
        }
        if (numBytes < 0 || numBytes > 2) {
            throw new IllegalArgumentException("numBytes == " + numBytes);
        }
        if (bigEndian) {
            if (signExtend) {
                return ByteArrayUnmarshaller.readShort_(byteArray, offset, true, numBytes, true);
            }
            return ByteArrayUnmarshaller.readShort_(byteArray, offset, true, numBytes, false);
        }
        if (signExtend) {
            return ByteArrayUnmarshaller.readShort_(byteArray, offset, false, numBytes, true);
        }
        return ByteArrayUnmarshaller.readShort_(byteArray, offset, false, numBytes, false);
    }

    private static short readShort_(byte[] byteArray, int offset, boolean bigEndian, int numBytes, boolean signExtend) {
        int i = offset;
        switch (numBytes) {
            case 0: {
                return 0;
            }
            case 1: {
                if (signExtend) {
                    return byteArray[i];
                }
                return (short)(byteArray[i] & 0xFF);
            }
            case 2: {
                if (bigEndian) {
                    return (short)((byteArray[i] & 0xFF) << 8 | byteArray[i + 1] & 0xFF);
                }
                return (short)((byteArray[i + 1] & 0xFF) << 8 | byteArray[i] & 0xFF);
            }
        }
        return 0;
    }

    public static int readInt(byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 4 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readInt is trying to access byteArray[" + offset + "] to byteArray[" + (offset + 3) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            return ByteArrayUnmarshaller.readInt_(byteArray, offset, true);
        }
        return ByteArrayUnmarshaller.readInt_(byteArray, offset, false);
    }

    private static int readInt_(byte[] byteArray, int offset, boolean bigEndian) {
        if (bigEndian) {
            return (byteArray[offset] & 0xFF) << 24 | (byteArray[offset + 1] & 0xFF) << 16 | (byteArray[offset + 2] & 0xFF) << 8 | byteArray[offset + 3] & 0xFF;
        }
        return (byteArray[offset + 3] & 0xFF) << 24 | (byteArray[offset + 2] & 0xFF) << 16 | (byteArray[offset + 1] & 0xFF) << 8 | byteArray[offset] & 0xFF;
    }

    public static int readInt(byte[] byteArray, int offset, boolean bigEndian, int numBytes, boolean signExtend) {
        if (offset + numBytes > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Access offset must be positive or zero and last byte must be in range.");
        }
        if (numBytes < 0 || numBytes > 4) {
            throw new IllegalArgumentException("numBytes == " + numBytes);
        }
        if (bigEndian) {
            if (signExtend) {
                return ByteArrayUnmarshaller.readInt_(byteArray, offset, true, numBytes, true);
            }
            return ByteArrayUnmarshaller.readInt_(byteArray, offset, true, numBytes, false);
        }
        if (signExtend) {
            return ByteArrayUnmarshaller.readInt_(byteArray, offset, false, numBytes, true);
        }
        return ByteArrayUnmarshaller.readInt_(byteArray, offset, false, numBytes, false);
    }

    private static int readInt_(byte[] byteArray, int offset, boolean bigEndian, int numBytes, boolean signExtend) {
        int i = offset;
        switch (numBytes) {
            case 0: {
                return 0;
            }
            case 1: {
                if (signExtend) {
                    return byteArray[i];
                }
                return byteArray[i] & 0xFF;
            }
            case 2: {
                int answer = bigEndian ? (byteArray[i] & 0xFF) << 8 | byteArray[i + 1] & 0xFF : (byteArray[i + 1] & 0xFF) << 8 | byteArray[i] & 0xFF;
                if (signExtend) {
                    return (short)answer;
                }
                return answer & 0xFFFF;
            }
            case 3: {
                int answer = bigEndian ? (byteArray[i] & 0xFF) << 16 | (byteArray[i + 1] & 0xFF) << 8 | byteArray[i + 2] & 0xFF : (byteArray[i + 2] & 0xFF) << 16 | (byteArray[i + 1] & 0xFF) << 8 | byteArray[i] & 0xFF;
                if (signExtend && (answer & 0x800000) != 0) {
                    answer |= 0xFF000000;
                }
                return answer;
            }
            case 4: {
                if (bigEndian) {
                    return (byteArray[i] & 0xFF) << 24 | (byteArray[i + 1] & 0xFF) << 16 | (byteArray[i + 2] & 0xFF) << 8 | byteArray[i + 3] & 0xFF;
                }
                return (byteArray[i + 3] & 0xFF) << 24 | (byteArray[i + 2] & 0xFF) << 16 | (byteArray[i + 1] & 0xFF) << 8 | byteArray[i] & 0xFF;
            }
        }
        return 0;
    }

    public static long readLong(byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 8 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readLong is trying to access byteArray[" + offset + "] to byteArray[" + (offset + 7) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            return ByteArrayUnmarshaller.readLong_(byteArray, offset, true);
        }
        return ByteArrayUnmarshaller.readLong_(byteArray, offset, false);
    }

    private static long readLong_(byte[] byteArray, int offset, boolean bigEndian) {
        if (bigEndian) {
            return (long)(byteArray[offset] & 0xFF) << 56 | (long)(byteArray[offset + 1] & 0xFF) << 48 | (long)(byteArray[offset + 2] & 0xFF) << 40 | (long)(byteArray[offset + 3] & 0xFF) << 32 | (long)(byteArray[offset + 4] & 0xFF) << 24 | (long)((byteArray[offset + 5] & 0xFF) << 16) | (long)((byteArray[offset + 6] & 0xFF) << 8) | (long)(byteArray[offset + 7] & 0xFF);
        }
        return (long)(byteArray[offset + 7] & 0xFF) << 56 | (long)(byteArray[offset + 6] & 0xFF) << 48 | (long)(byteArray[offset + 5] & 0xFF) << 40 | (long)(byteArray[offset + 4] & 0xFF) << 32 | (long)(byteArray[offset + 3] & 0xFF) << 24 | (long)((byteArray[offset + 2] & 0xFF) << 16) | (long)((byteArray[offset + 1] & 0xFF) << 8) | (long)(byteArray[offset] & 0xFF);
    }

    public static long readLong(byte[] byteArray, int offset, boolean bigEndian, int numBytes, boolean signExtend) {
        if (offset + numBytes > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Access offset must be positive or zero and last byte must be in range.");
        }
        if (numBytes < 0 || numBytes > 8) {
            throw new IllegalArgumentException("numBytes == " + numBytes);
        }
        if (bigEndian) {
            if (signExtend) {
                return ByteArrayUnmarshaller.readLong_(byteArray, offset, true, numBytes, true);
            }
            return ByteArrayUnmarshaller.readLong_(byteArray, offset, true, numBytes, false);
        }
        if (signExtend) {
            return ByteArrayUnmarshaller.readLong_(byteArray, offset, false, numBytes, true);
        }
        return ByteArrayUnmarshaller.readLong_(byteArray, offset, false, numBytes, false);
    }

    private static long readLong_(byte[] byteArray, int offset, boolean bigEndian, int numBytes, boolean signExtend) {
        int i = offset;
        switch (numBytes) {
            case 0: {
                return 0L;
            }
            case 1: {
                if (signExtend) {
                    return byteArray[i];
                }
                return (long)byteArray[i] & 0xFFL;
            }
            case 2: {
                long answer = bigEndian ? (long)((byteArray[i] & 0xFF) << 8 | byteArray[i + 1] & 0xFF) : (long)((byteArray[i + 1] & 0xFF) << 8 | byteArray[i] & 0xFF);
                if (signExtend) {
                    return (short)answer;
                }
                return answer & 0xFFFFL;
            }
            case 3: {
                long answer = bigEndian ? (long)((byteArray[i] & 0xFF) << 16 | (byteArray[i + 1] & 0xFF) << 8 | byteArray[i + 2] & 0xFF) : (long)((byteArray[i + 2] & 0xFF) << 16 | (byteArray[i + 1] & 0xFF) << 8 | byteArray[i] & 0xFF);
                if (signExtend) {
                    answer = answer << 40 >> 40;
                }
                return answer;
            }
            case 4: {
                long answer = bigEndian ? ((long)byteArray[i] & 0xFFL) << 24 | (long)((byteArray[i + 1] & 0xFF) << 16) | (long)((byteArray[i + 2] & 0xFF) << 8) | (long)(byteArray[i + 3] & 0xFF) : ((long)byteArray[i + 3] & 0xFFL) << 24 | (long)((byteArray[i + 2] & 0xFF) << 16) | (long)((byteArray[i + 1] & 0xFF) << 8) | (long)(byteArray[i] & 0xFF);
                if (signExtend) {
                    answer = answer << 32 >> 32;
                }
                return answer;
            }
            case 5: {
                long answer = bigEndian ? ((long)byteArray[i] & 0xFFL) << 32 | ((long)byteArray[i + 1] & 0xFFL) << 24 | (long)((byteArray[i + 2] & 0xFF) << 16) | (long)((byteArray[i + 3] & 0xFF) << 8) | (long)(byteArray[i + 4] & 0xFF) : ((long)byteArray[i + 4] & 0xFFL) << 32 | ((long)byteArray[i + 3] & 0xFFL) << 24 | (long)((byteArray[i + 2] & 0xFF) << 16) | (long)((byteArray[i + 1] & 0xFF) << 8) | (long)(byteArray[i] & 0xFF);
                if (signExtend) {
                    answer = answer << 24 >> 24;
                }
                return answer;
            }
            case 6: {
                long answer = bigEndian ? ((long)byteArray[i] & 0xFFL) << 40 | ((long)byteArray[i + 1] & 0xFFL) << 32 | ((long)byteArray[i + 2] & 0xFFL) << 24 | (long)((byteArray[i + 3] & 0xFF) << 16) | (long)((byteArray[i + 4] & 0xFF) << 8) | (long)(byteArray[i + 5] & 0xFF) : ((long)byteArray[i + 5] & 0xFFL) << 40 | ((long)byteArray[i + 4] & 0xFFL) << 32 | ((long)byteArray[i + 3] & 0xFFL) << 24 | (long)((byteArray[i + 2] & 0xFF) << 16) | (long)((byteArray[i + 1] & 0xFF) << 8) | (long)(byteArray[i] & 0xFF);
                if (signExtend) {
                    answer = answer << 16 >> 16;
                }
                return answer;
            }
            case 7: {
                long answer = bigEndian ? ((long)byteArray[i] & 0xFFL) << 48 | ((long)byteArray[i + 1] & 0xFFL) << 40 | ((long)byteArray[i + 2] & 0xFFL) << 32 | ((long)byteArray[i + 3] & 0xFFL) << 24 | (long)((byteArray[i + 4] & 0xFF) << 16) | (long)((byteArray[i + 5] & 0xFF) << 8) | (long)(byteArray[i + 6] & 0xFF) : ((long)byteArray[i + 6] & 0xFFL) << 48 | ((long)byteArray[i + 5] & 0xFFL) << 40 | ((long)byteArray[i + 4] & 0xFFL) << 32 | ((long)byteArray[i + 3] & 0xFFL) << 24 | (long)((byteArray[i + 2] & 0xFF) << 16) | (long)((byteArray[i + 1] & 0xFF) << 8) | (long)(byteArray[i] & 0xFF);
                if (signExtend) {
                    answer = answer << 8 >> 8;
                }
                return answer;
            }
            case 8: {
                if (bigEndian) {
                    return ((long)byteArray[i] & 0xFFL) << 56 | ((long)byteArray[i + 1] & 0xFFL) << 48 | ((long)byteArray[i + 2] & 0xFFL) << 40 | ((long)byteArray[i + 3] & 0xFFL) << 32 | ((long)byteArray[i + 4] & 0xFFL) << 24 | (long)((byteArray[i + 5] & 0xFF) << 16) | (long)((byteArray[i + 6] & 0xFF) << 8) | (long)(byteArray[i + 7] & 0xFF);
                }
                return ((long)byteArray[i + 7] & 0xFFL) << 56 | ((long)byteArray[i + 6] & 0xFFL) << 48 | ((long)byteArray[i + 5] & 0xFFL) << 40 | ((long)byteArray[i + 4] & 0xFFL) << 32 | ((long)byteArray[i + 3] & 0xFFL) << 24 | (long)((byteArray[i + 2] & 0xFF) << 16) | (long)((byteArray[i + 1] & 0xFF) << 8) | (long)(byteArray[i] & 0xFF);
            }
        }
        return 0L;
    }

    public static float readFloat(byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 4 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readFloat is trying to access byteArray[" + offset + "] to byteArray[" + (offset + 3) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            return ByteArrayUnmarshaller.readFloat_(byteArray, offset, true);
        }
        return ByteArrayUnmarshaller.readFloat_(byteArray, offset, false);
    }

    private static float readFloat_(byte[] byteArray, int offset, boolean bigEndian) {
        return Float.intBitsToFloat(ByteArrayUnmarshaller.readInt(byteArray, offset, bigEndian));
    }

    public static double readDouble(byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 8 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readDouble is trying to access byteArray[" + offset + "] to byteArray[" + (offset + 7) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            return ByteArrayUnmarshaller.readDouble_(byteArray, offset, true);
        }
        return ByteArrayUnmarshaller.readDouble_(byteArray, offset, false);
    }

    private static double readDouble_(byte[] byteArray, int offset, boolean bigEndian) {
        return Double.longBitsToDouble(ByteArrayUnmarshaller.readLong(byteArray, offset, bigEndian));
    }
}

