/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.util.LoaderRetriever;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public final class LoaderRetrieverFactory {
    private static final String CLASS = LoaderRetrieverFactory.class.getName();
    private static final LoaderRetrieverFactory INSTANCE = AccessController.doPrivileged(new CreateAction());
    private static final Class[] PARAMS = null;
    public static final PrivilegedAction<LoaderRetrieverFactory> ACCESS_ACTION = new AccessAction();
    private final LoaderRetriever latestLoaderRetriever = this.createLatest();

    private LoaderRetrieverFactory() {
    }

    private final Method getAccessibleLoaderMethod(String string, String string2) {
        Method method;
        block5: {
            method = null;
            try {
                Class<?> clazz = Class.forName(string);
                method = clazz.getDeclaredMethod(string2, PARAMS);
                int n = method.getModifiers();
                if (!Modifier.isStatic(n)) {
                    method = null;
                } else if (!Modifier.isPublic(n)) {
                    method.setAccessible(true);
                }
            }
            catch (Exception exception) {
                method = null;
                if (!Trc.enabled()) break block5;
                Trc.warn(exception, CLASS, "getAccessibleLoaderMethod:74");
            }
        }
        return method;
    }

    private final LoaderRetriever createLatest() {
        Method method = this.getAccessibleLoaderMethod("com.ibm.oti.vm.ORBVMHelpers", "LatestUserDefinedLoader");
        if (null == method) {
            method = this.getAccessibleLoaderMethod("java.io.ObjectInputStream", "latestUserDefinedLoader");
        }
        if (null == method) {
            return new SlowLatestUserDefinedLoaderRetriever();
        }
        return new UserDefinedLoaderByMethodRetriever(method);
    }

    final LoaderRetriever create(Class clazz) {
        if (null == clazz) {
            return this.latestLoaderRetriever;
        }
        return new UserDefinedLoaderFromClassRetriever(clazz);
    }

    public final LoaderRetriever getLatest() {
        return this.latestLoaderRetriever;
    }

    private static abstract class AbstractSlowLoaderByContextRetriever
    implements LoaderRetriever {
        private AbstractSlowLoaderByContextRetriever() {
        }

        protected abstract int getStartingDepth(Class[] var1);

        @Override
        public final ClassLoader getUserDefinedLoader() {
            Class[] classArray = ContextRetriever.INSTANCE.getContext();
            ClassLoader classLoader = null;
            for (int i = this.getStartingDepth(classArray); i < classArray.length && null == (classLoader = classArray[i].getClassLoader()); ++i) {
            }
            return classLoader;
        }

        private static final class ContextRetriever
        extends SecurityManager {
            static final ContextRetriever INSTANCE = AccessController.doPrivileged(new CreateAction());

            private ContextRetriever() {
            }

            Class[] getContext() {
                return super.getClassContext();
            }

            private static final class CreateAction
            implements PrivilegedAction<ContextRetriever> {
                CreateAction() {
                }

                @Override
                public ContextRetriever run() {
                    return new ContextRetriever();
                }
            }
        }
    }

    private static final class AccessAction
    implements PrivilegedAction<LoaderRetrieverFactory> {
        private static final Permission accessPermission = new ReflectPermission("suppressAccessChecks");

        AccessAction() {
        }

        @Override
        public LoaderRetrieverFactory run() {
            SecurityManager securityManager = System.getSecurityManager();
            if (null != securityManager) {
                securityManager.checkPermission(accessPermission);
            }
            return INSTANCE;
        }
    }

    private static final class CreateAction
    implements PrivilegedAction<LoaderRetrieverFactory> {
        CreateAction() {
        }

        @Override
        public LoaderRetrieverFactory run() {
            return new LoaderRetrieverFactory();
        }
    }

    private static final class SlowLatestUserDefinedLoaderRetriever
    extends AbstractSlowLoaderByContextRetriever {
        SlowLatestUserDefinedLoaderRetriever() {
        }

        @Override
        protected final int getStartingDepth(Class[] classArray) {
            return 1;
        }
    }

    private static final class UserDefinedLoaderByMethodRetriever
    implements LoaderRetriever {
        private static final String CLASS = UserDefinedLoaderByMethodRetriever.class.getName();
        private static final Object[] ARGS = null;
        private final Method method;

        public UserDefinedLoaderByMethodRetriever(Method method) {
            this.method = method;
        }

        @Override
        public ClassLoader getUserDefinedLoader() {
            ClassLoader classLoader = null;
            try {
                classLoader = (ClassLoader)this.method.invoke(null, ARGS);
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "getUserDefinedLoader:224");
            }
            return classLoader;
        }
    }

    private static final class UserDefinedLoaderFromClassRetriever
    extends AbstractSlowLoaderByContextRetriever {
        private final Class startingClass;

        UserDefinedLoaderFromClassRetriever(Class clazz) {
            this.startingClass = clazz;
        }

        @Override
        protected int getStartingDepth(Class[] classArray) {
            for (int i = 1; i < classArray.length; ++i) {
                if (this.startingClass != classArray[i]) continue;
                return i;
            }
            return classArray.length;
        }
    }
}

