/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.ras;

import com.ibm.CORBA.iiop.OrbMsgLogger;
import com.ibm.CORBA.iiop.OrbTrcLogger;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.util.Utility;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Trc {
    private static final long BEGIN = 4100L;
    private static final long COMPLETE = 4100L;
    private static final long FAIL = 8196L;
    private static final long INFO = 4112L;
    private static final long WARN = 8208L;
    private static final long FFDC = 40976L;
    private static final long INFO_EXC = 4104L;
    private static final long WARN_EXC = 8200L;
    private static final long FFDC_EXC = 40968L;
    private static final String UNAVAILABLE = "<not available>";
    private static long svEvent = 1128L;
    private static long svEE = 903L;
    private static long svDebug = 16L;
    public static final long FINE = 0x800L | svEvent;
    public static final long FINER = 0x1000L | svEE;
    public static final long FINEST = 0x2000L | svDebug;
    public static final long DEFAULT = 2048L;
    public static final int ALL = 0;
    public static final int DISPATCH = 1;
    public static final int MARSHAL = 2;
    public static final int TRANSPORT = 3;
    public static final int CLASSLOADER = 4;
    public static final int MISC = 5;
    private static boolean DISPATCH_FLAG = false;
    private static boolean MARSHAL_FLAG = false;
    private static boolean TRANSPORT_FLAG = false;
    private static boolean CLASSLOADER_FLAG = false;
    private static boolean MISC_FLAG = false;
    public static String trace_comp_list;
    private static final char[] HEX;
    private static final String[] ZEROES;

    private Trc() {
        throw new Error("Illegal construction of Trc object.");
    }

    public static void parseComponentList(boolean bl) {
        block7: {
            if (bl) {
                try {
                    String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return System.getProperty("com.ibm.CORBA.Debug.Component");
                        }
                    });
                    if (string == null || string.length() == 0) {
                        if (trace_comp_list == null || trace_comp_list.trim().length() == 0) {
                            Trc.setAllComponents(true);
                        } else {
                            Trc.parseComponentDebugProperty(trace_comp_list.trim().toUpperCase());
                        }
                        break block7;
                    }
                    Trc.parseComponentDebugProperty(string.trim().toUpperCase());
                }
                catch (Exception exception) {
                    Trc.setAllComponents(true);
                }
            } else {
                Trc.setAllComponents(false);
            }
        }
    }

    private static void parseComponentDebugProperty(String string) {
        if (string == null || string.length() == 0) {
            Trc.setAllComponents(true);
            return;
        }
        Trc.setAllComponents(false);
        String[] stringArray = string.split(",");
        if (stringArray == null || stringArray.length == 0) {
            Trc.setAllComponents(true);
            return;
        }
        block16: for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0) {
                Trc.setAllComponents(true);
                return;
            }
            switch (stringArray[i]) {
                case "ALL": {
                    Trc.setAllComponents(true);
                    return;
                }
                case "DISPATCH": {
                    DISPATCH_FLAG = true;
                    continue block16;
                }
                case "MARSHAL": {
                    MARSHAL_FLAG = true;
                    continue block16;
                }
                case "TRANSPORT": {
                    TRANSPORT_FLAG = true;
                    continue block16;
                }
                case "CLASSLOADER": {
                    CLASSLOADER_FLAG = true;
                    continue block16;
                }
                case "MISC": {
                    MISC_FLAG = true;
                    continue block16;
                }
                default: {
                    Trc.setAllComponents(true);
                    return;
                }
            }
        }
    }

    public static final void setAllComponents(boolean bl) {
        CLASSLOADER_FLAG = MISC_FLAG = bl;
        MARSHAL_FLAG = MISC_FLAG;
        TRANSPORT_FLAG = MISC_FLAG;
        DISPATCH_FLAG = MISC_FLAG;
    }

    public static final boolean enabled() {
        return ORBRas.isTrcLogging;
    }

    public static final boolean enabled(int n) {
        if (!ORBRas.isTrcLogging) {
            return ORBRas.isTrcLogging;
        }
        switch (n) {
            case 1: {
                return DISPATCH_FLAG;
            }
            case 2: {
                return MARSHAL_FLAG;
            }
            case 3: {
                return TRANSPORT_FLAG;
            }
            case 4: {
                return CLASSLOADER_FLAG;
            }
            case 5: {
                return MISC_FLAG;
            }
        }
        return ORBRas.isTrcLogging;
    }

    public static final OrbTrcLogger logger() {
        return ORBRas.orbTrcLogger;
    }

    public static final OrbMsgLogger msgLogger() {
        return ORBRas.orbMsgLogger;
    }

    public static final void logger(OrbTrcLogger orbTrcLogger) {
        ORBRas.orbTrcLogger = orbTrcLogger;
    }

    public static final void msgLogger(OrbMsgLogger orbMsgLogger) {
        ORBRas.orbMsgLogger = orbMsgLogger;
    }

    public static final void inApplet(boolean bl) {
        ORBRas.isRunningInApplet = bl;
    }

    public static String concat(String string, String string2) {
        return string + string2;
    }

    public static String concat(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        return string + string2 + string3 + string4 + string5 + string6 + string7 + string8 + string9 + string10;
    }

    public static String hex(long l) {
        return Trc.paddedHex(l, 16);
    }

    public static String hex(int n) {
        return Trc.paddedHex(n, 8);
    }

    public static String hex(short s) {
        return Trc.paddedHex(s, 4);
    }

    public static String hex(byte by) {
        return Trc.paddedHex(by, 2);
    }

    public static String hex(byte[] byArray) {
        return Utility.bytesToHexString(byArray);
    }

    public static String hex(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray == null) {
            return "null";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            WsByteBuffer wsByteBuffer = wsByteBufferArray[i];
            int n2 = wsByteBuffer.limit();
            for (int j = 0; j < n2; ++j) {
                if (n % 16 == 0) {
                    printWriter.println();
                    printWriter.print("\t");
                    String string = Integer.toHexString(n);
                    printWriter.print(ZEROES[string.length()]);
                    printWriter.print(string);
                    printWriter.print(": ");
                } else if (n % 4 == 0) {
                    printWriter.print(" ");
                }
                byte by = wsByteBuffer.get(j);
                printWriter.print(Trc.hi(by));
                printWriter.print(Trc.lo(by));
                ++n;
            }
        }
        return stringWriter.toString();
    }

    public static String hex(ByteBuffer byteBuffer) {
        byte[] byArray;
        if (byteBuffer == null) {
            return "null";
        }
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[byteBuffer.limit()];
            byteBuffer.rewind();
            byteBuffer.get(byArray);
        }
        return Utility.bytesToHexString(byArray);
    }

    private static String paddedHex(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer("0x");
        String string = Long.toHexString(l);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String str(long l) {
        return Long.toString(l);
    }

    public static String str(double d) {
        return Double.toString(d);
    }

    public static String str(boolean bl) {
        return Boolean.toString(bl);
    }

    public static String str(Object object) {
        return null == object ? "null" : object.toString();
    }

    public static String str(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        if (lArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = lArray.length - 1;
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(lArray[i]);
            stringBuffer.append("L");
            if (i == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String str(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        if (nArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String str(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        if (byArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = byArray.length - 1;
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(byArray[i]));
            if (i == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String str(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = objectArray.length - 1;
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i]);
            if (i == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String stackTrace(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer(throwable.toString()).append("\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append("\tat ").append(stackTraceElementArray[i].toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    public static String stack() {
        return Trc.stack(1);
    }

    public static String stack(int n) {
        return Trc.stackImpl(new Throwable(), n + 1, null);
    }

    public static String stack(String string) {
        return Trc.stackImpl(new Throwable(), 0, string);
    }

    private static String stackImpl(Throwable throwable, int n, String string) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return UNAVAILABLE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            String string2 = stackTraceElementArray[i].toString();
            stringBuffer.append(string2);
            if (i == n || string != null && string2.startsWith(string)) break;
            stringBuffer.append(" -> ");
        }
        return stringBuffer.toString();
    }

    public static String clz(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName();
    }

    public static String array(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray == null) {
            return "null";
        }
        if (wsByteBufferArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            WsByteBuffer wsByteBuffer = wsByteBufferArray[i];
            if (wsByteBuffer == null) {
                stringBuffer.append("null, ");
                continue;
            }
            stringBuffer.append(System.identityHashCode(wsByteBuffer)).append("p=").append(wsByteBuffer.position()).append("l=").append(wsByteBuffer.limit()).append(", ");
        }
        stringBuffer.setCharAt(stringBuffer.length() - 2, '}');
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private static final char hi(byte by) {
        return HEX[by >> 4 & 0xF];
    }

    private static final char lo(byte by) {
        return HEX[by & 0xF];
    }

    public static void begin(long l, String string, String string2) {
        Trc.logger().entry(l, string, string2);
    }

    public static void begin1(long l, Object object, String string, String string2) {
        Trc.logger().entry(l, string, string2, object);
    }

    public static void begin1(long l, String string, Object object, String string2, String string3) {
        Trc.logger().entry(l, string2, string3, (Object)(string + object));
    }

    public static void begin2(long l, Object object, Object object2, String string, String string2) {
        Trc.logger().entry(l, string, string2, object, object2);
    }

    public static void begin2(long l, String string, Object object, String string2, Object object2, String string3, String string4) {
        Trc.logger().entry(l, string3, string4, (Object)(string + object), (Object)(string2 + object2));
    }

    public static void beginN(long l, Object[] objectArray, String string, String string2) {
        Trc.logger().entry(l, string, string2, objectArray);
    }

    public static void beginN(long l, String string, Object[] objectArray, String string2, String string3) {
        Trc.logger().entry(l, string2, string3);
        Trc.logger().trace(l, string2, string3, string, objectArray);
    }

    public static void beginN(long l, Object object, String string, Object[] objectArray, String string2, String string3) {
        Trc.logger().entry(l, string2, string3, object);
        Trc.logger().trace(l, string2, string3, string, objectArray);
    }

    public static void complete(long l, String string, String string2) {
        Trc.logger().exit(l, string, string2);
    }

    public static void complete(long l, Object object, String string, String string2) {
        Trc.logger().exit(l, string, string2, object);
    }

    public static void complete(long l, Object object, Object object2, String string, String string2) {
        Trc.logger().exit(l, string, string2, (Object)("" + object + object2));
    }

    public static void complete(long l, Object object, Object object2, Object object3, String string, String string2) {
        Trc.logger().exit(l, string, string2, (Object)("" + object + object2 + object3));
    }

    public static void complete(long l, Object object, Object object2, Object object3, Object object4, String string, String string2) {
        Trc.logger().exit(l, string, string2, (Object)("" + object + object2 + object3 + object4));
    }

    public static void complete(long l, Object object, Object object2, Object object3, Object object4, Object object5, String string, String string2) {
        Trc.logger().exit(l, string, string2, (Object)("" + object + object2 + object3 + object4 + object5));
    }

    public static void complete(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, String string, String string2) {
        Trc.logger().exit(l, string, string2, (Object)("" + object + object2 + object3 + object4 + object5 + object6));
    }

    public static void complete(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, String string, String string2) {
        Trc.logger().exit(l, string, string2, (Object)("" + object + object2 + object3 + object4 + object5 + object6 + object7));
    }

    public static void fail(String string, String string2) {
        Trc.logger().exit(8196L, string, string2);
    }

    public static void fail(Object object, String string, String string2) {
        Trc.logger().exit(8196L, string, string2, (Object)("" + object));
    }

    public static void fail(Object object, Object object2, String string, String string2) {
        Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2));
    }

    public static void fail(Object object, Object object2, Object object3, String string, String string2) {
        Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3));
    }

    public static void fail(Object object, Object object2, Object object3, Object object4, String string, String string2) {
        Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3 + object4));
    }

    public static void fail(Object object, Object object2, Object object3, Object object4, Object object5, String string, String string2) {
        Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5));
    }

    public static void fail(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, String string, String string2) {
        Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5 + object6));
    }

    public static void fail(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, String string, String string2) {
        Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5 + object6 + object7));
    }

    public static void info(long l, String string, String string2) {
        Trc.logger().trace(l, string, string2, "");
    }

    public static void info(long l, Object object, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object);
    }

    public static void info(long l, Object object, Object object2, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2);
    }

    public static void info(long l, Object object, Object object2, Object object3, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10 + object11);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10 + object11 + object12);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10 + object11 + object12 + object13);
    }

    public static void info(long l, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, String string, String string2) {
        Trc.logger().trace(l, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10 + object11 + object12 + object13 + object14);
    }

    public static void info(long l, Throwable throwable, String string, String string2) {
        Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        Trc.logger().exception(l, string, string2, exception);
    }

    public static void vals(long l, String string, Object object, String string2, String string3) {
        Trc.logger().trace(l, string2, string3, string + "=" + object);
    }

    public static void vals(long l, String string, Object object, String string2, Object object2, String string3, String string4) {
        Trc.logger().trace(l, string3, string4, string + "=" + object + ", " + string2 + "=" + object2);
    }

    public static void vals(long l, String string, Object object, String string2, Object object2, String string3, Object object3, String string4, String string5) {
        Trc.logger().trace(l, string4, string5, string + "=" + object + ", " + string2 + "=" + object2 + ", " + string3 + "=" + object3);
    }

    public static void vals(long l, String string, Object object, String string2, Object object2, String string3, Object object3, String string4, Object object4, String string5, String string6) {
        Trc.logger().trace(l, string5, string6, string + "=" + object + ", " + string2 + "=" + object2 + ", " + string3 + "=" + object3 + ", " + string4 + "=" + object4);
    }

    public static void warn(Object object, String string, String string2) {
        Trc.logger().trace(8208L, string, string2, "" + object);
    }

    public static void warn(Object object, Object object2, String string, String string2) {
        Trc.logger().trace(8208L, string, string2, "" + object + object2);
    }

    public static void warn(Object object, Object object2, Object object3, String string, String string2) {
        Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3);
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, String string, String string2) {
        Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4);
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, Object object5, String string, String string2) {
        Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4 + object5);
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, String string, String string2) {
        Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6);
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, String string, String string2) {
        Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7);
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, String string, String string2) {
        Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8);
    }

    public static void warn(Exception exception, String string, String string2) {
        Trc.logger().exception(8200L, string, string2, exception);
    }

    public static void ffdc(String string, String string2, String string3) {
        Trc.logger().trace(40976L, string2, string3, string);
    }

    public static void ffdc(Throwable throwable, String string, String string2) {
        Trc.logger().exception(40968L, string, string2, throwable);
    }

    static {
        HEX = "0123456789ABCDEF".toCharArray();
        ZEROES = new String[]{null, "0000000", "000000", "00000", "0000", "000", "00", "0", ""};
    }
}

