/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.image.j9.Image;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.jvm.j9.dump.indexsupport.IParserNode;
import com.ibm.jvm.j9.dump.indexsupport.NodeAbstract;
import com.ibm.jvm.j9.dump.indexsupport.NodeGPF;
import com.ibm.jvm.j9.dump.indexsupport.NodeJavaVM;
import com.ibm.jvm.j9.dump.indexsupport.NodeNet;
import com.ibm.jvm.j9.dump.indexsupport.XMLIndexReader;
import org.xml.sax.Attributes;

public class NodeJ9Dump
extends NodeAbstract {
    private XMLIndexReader _parent;
    private ImageAddressSpace _addressSpace;
    private String _vmVersion;
    private ImageProcess _process;
    private Image _image;

    public NodeJ9Dump(XMLIndexReader reader, Attributes attributes) {
        String osType = attributes.getValue("osname");
        String osSubType = attributes.getValue("osversion");
        String cpuType = attributes.getValue("arch");
        this._vmVersion = attributes.getValue("version");
        long environ = NodeJ9Dump._longFromString(attributes.getValue("environ"));
        String cpus = attributes.getValue("cpus");
        int cpuCount = cpus != null ? Integer.parseInt(cpus) : 0;
        String memory = attributes.getValue("memory");
        long bytesMem = memory != null ? Long.parseLong(memory) : 0L;
        int pointerSize = Integer.parseInt(attributes.getValue("size"));
        Image[] iRef = new Image[1];
        ImageAddressSpace[] asRef = new ImageAddressSpace[1];
        ImageProcess[] pRef = new ImageProcess[1];
        this._parent = reader;
        this._parent.setJ9DumpData(environ, osType, osSubType, cpuType, cpuCount, bytesMem, pointerSize, iRef, asRef, pRef);
        this._image = iRef[0];
        this._addressSpace = asRef[0];
        this._process = pRef[0];
    }

    @Override
    public IParserNode nodeToPushAfterStarting(String uri, String localName, String qName, Attributes attributes) {
        IParserNode child = null;
        child = qName.equals("gpf") ? new NodeGPF(this._process, attributes) : (qName.equals("net") ? new NodeNet(this._image, attributes) : (qName.equals("javavm") ? new NodeJavaVM(this._parent, this._process, this._addressSpace, this._vmVersion, attributes) : super.nodeToPushAfterStarting(uri, localName, qName, attributes)));
        return child;
    }
}

