/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins.impl;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;

public final class ClassScanner
extends ClassVisitor {
    private ClassInfo info;
    private Annotation currentAnnotation;
    private final URL url;
    private final Set<ClassListener> listeners;

    public static ClassInfo getClassInfo(InputStream file, URL url, Set<ClassListener> listeners) throws IOException {
        ClassScanner scanner = new ClassScanner(url, listeners);
        ClassReader reader = new ClassReader(file);
        reader.accept(scanner, 7);
        return scanner.info;
    }

    private ClassScanner(URL url, Set<ClassListener> listeners) {
        super(327680, null);
        this.url = url;
        this.listeners = listeners;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String className, boolean visible) {
        this.currentAnnotation = this.info.addAnnotation(className);
        for (ClassListener listener : this.listeners) {
            listener.visitAnnotation(className, visible);
        }
        final class ClassScannerAnnotation
        extends AnnotationVisitor {
            ClassScannerAnnotation(int api) {
                super(api);
            }

            @Override
            public void visit(String name, Object value) {
                ClassScanner.this.visitAnnotationValue(name, value);
            }
        }
        return new ClassScannerAnnotation(this.api);
    }

    final void visitAnnotationValue(String name, Object value) {
        this.currentAnnotation.addEntry(name, value);
        for (ClassListener listener : this.listeners) {
            listener.visitAnnotationValue(name, value);
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String dotName = name.replace('/', '.');
        String dotSuperName = superName.replace('/', '.');
        this.info = new ClassInfo(dotName, this.url);
        for (String iface : interfaces) {
            this.info.addInterface(iface);
        }
        for (ClassListener listener : this.listeners) {
            listener.visit(version, access, dotName, signature, dotSuperName, interfaces);
        }
    }
}

