/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageRegister;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptImageStackFrame;
import com.ibm.dtfj.phd.PHDImageStackFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class PHDImageThread
implements ImageThread {
    String id;
    PHDCorruptData id_cd;
    Properties props;
    private final List<ImageStackFrame> frames = new ArrayList<ImageStackFrame>();
    private List<ImageRegister> registers = new ArrayList<ImageRegister>();

    public PHDImageThread(ImageAddressSpace space, ImageThread meta) {
        Object next;
        Iterator it2;
        try {
            this.id = meta.getID();
        }
        catch (CorruptDataException e) {
            this.id_cd = new PHDCorruptData(space, e);
        }
        this.props = new Properties(meta.getProperties());
        try {
            it2 = meta.getStackFrames();
            while (it2.hasNext()) {
                next = it2.next();
                if (next instanceof CorruptData) {
                    this.frames.add(new PHDCorruptImageStackFrame(space, (CorruptData)next));
                    continue;
                }
                this.frames.add(new PHDImageStackFrame(space, (ImageStackFrame)next));
            }
        }
        catch (DataUnavailable it2) {
            // empty catch block
        }
        it2 = meta.getRegisters();
        while (it2.hasNext()) {
            next = it2.next();
            if (next instanceof CorruptData) continue;
            this.registers.add((ImageRegister)next);
        }
    }

    @Override
    public String getID() throws CorruptDataException {
        if (this.id_cd != null) {
            throw new CorruptDataException(this.id_cd);
        }
        return this.id;
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public Iterator<ImageRegister> getRegisters() {
        return this.registers.iterator();
    }

    @Override
    public Iterator<ImageStackFrame> getStackFrames() throws DataUnavailable {
        if (this.frames == null) {
            throw new DataUnavailable();
        }
        return this.frames.iterator();
    }

    @Override
    public Iterator<ImageSection> getStackSections() {
        return Collections.emptyList().iterator();
    }
}

