/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import java.util.Properties;

class PHDImageSection
implements ImageSection {
    private final ImagePointer base;
    private final long size;
    private final String name;

    PHDImageSection(String name, ImagePointer base, long size) {
        this.base = base;
        this.size = size;
        this.name = name;
    }

    @Override
    public ImagePointer getBaseAddress() {
        return this.base;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isExecutable() throws DataUnavailable {
        return this.base.isExecutable();
    }

    @Override
    public boolean isReadOnly() throws DataUnavailable {
        return this.base.isReadOnly();
    }

    @Override
    public boolean isShared() throws DataUnavailable {
        return this.base.isShared();
    }

    @Override
    public Properties getProperties() {
        return this.base.getProperties();
    }

    public int hashCode() {
        return this.base.hashCode() ^ (int)this.size ^ (int)(this.size >>> 32);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PHDImageSection)) {
            return false;
        }
        PHDImageSection to = (PHDImageSection)o;
        return this.base.equals(to.base) && this.size == to.size;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.getName() + " 0x" + Long.toHexString(this.getBaseAddress().getAddress()) + ":0x" + Long.toHexString(this.getBaseAddress().getAddress() + this.getSize());
    }
}

