/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.nativememory;

import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.nativememory.INativeMemoryTypes;
import java.util.Stack;

public class NativeMemorySectionParser
extends SectionParser
implements INativeMemoryTypes {
    public NativeMemorySectionParser() {
        super("NATIVEMEMINFO");
    }

    @Override
    protected void sovOnlyRules(String startingTag) throws ParserException {
    }

    @Override
    protected void topLevelRule() throws ParserException {
        IImageProcessBuilder fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        IJavaRuntimeBuilder fRuntimeBuilder = fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        IAttributeValueMap results = null;
        Stack<JavaRuntimeMemoryCategory> categoryStack = new Stack<JavaRuntimeMemoryCategory>();
        this.processTagLineOptional("0MEMUSER");
        while ((results = this.processMemUserLine()) != null) {
            String name = results.getTokenValue("nativemem_name");
            if (name == null) continue;
            int depth = results.getIntValue("nativemem_depth");
            while (categoryStack.size() >= depth) {
                categoryStack.pop();
            }
            long deepBytes = this.parseCommaDelimitedLong(results.getTokenValue("nativemem_deepbytes"));
            long deepAllocations = this.parseCommaDelimitedLong(results.getTokenValue("nativemem_allocations"));
            JavaRuntimeMemoryCategory parent = null;
            if (categoryStack.size() > 0) {
                parent = (JavaRuntimeMemoryCategory)categoryStack.peek();
            }
            if (name.equals("Other")) {
                if (parent == null) {
                    throw new ParserException("Parse error: Unexpected NULL parent category for \"Other\" memory category");
                }
                fRuntimeBuilder.setShallowCountersForCategory(parent, deepBytes, deepAllocations);
                continue;
            }
            JavaRuntimeMemoryCategory category = fRuntimeBuilder.addMemoryCategory(name, deepBytes, deepAllocations, parent);
            categoryStack.push(category);
        }
    }

    private long parseCommaDelimitedLong(String tokenValue) {
        return Long.parseLong(tokenValue.replaceAll(",", ""));
    }

    private IAttributeValueMap processMemUserLine() throws ParserException {
        for (int i = 0; i < T_MEMUSERS.length; ++i) {
            String tag = T_MEMUSERS[i];
            IAttributeValueMap results = this.processTagLineOptional(tag);
            if (results == null) continue;
            return results;
        }
        return null;
    }
}

