/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.environment;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.environment.IEnvironmentTypes;
import java.util.regex.Matcher;

public class EnvironmentTagParser
extends TagParser
implements IEnvironmentTypes {
    private static final Matcher NOT_EQUALS = CommonPatternMatchers.generateMatcher("[^\\n\\r][^=\\n\\r]*", 2);

    public EnvironmentTagParser() {
        super("ENVINFO");
    }

    @Override
    protected void initTagAttributeRules() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_arg_string", CommonPatternMatchers.allButControlChars);
            }
        };
        LineRule lineRule2 = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_arg_string", CommonPatternMatchers.allButControlChars);
            }
        };
        LineRule lineRule3 = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                String bits = "32";
                CommonPatternMatchers.build_string.reset(source);
                if (CommonPatternMatchers.build_string.find()) {
                    int build = CommonPatternMatchers.build_string.start();
                    String version = source.substring(0, build);
                    CommonPatternMatchers.bits64.reset(version);
                    if (CommonPatternMatchers.bits64.find()) {
                        bits = "64";
                    } else {
                        CommonPatternMatchers.s390.reset(version);
                        if (CommonPatternMatchers.s390.matches()) {
                            bits = "31";
                        }
                    }
                }
                this.addToken("pointer_size", bits);
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_arg_string", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1CIJAVAVERSION", lineRule3);
        this.addTag("1CIVMVERSION", lineRule);
        this.addTag("1CIJITVERSION", lineRule);
        this.addTag("1CIGCVERSION", lineRule);
        this.addJITModesRule();
        this.addTag("1CIRUNNINGAS", null);
        this.addProcessIDRule();
        this.addCmdLineRule();
        this.addTag("1CIJAVAHOMEDIR", lineRule2);
        this.addTag("1CIJAVADLLDIR", lineRule2);
        this.addTag("1CISYSCP", lineRule2);
        this.addTag("1CIUSERARGS", lineRule);
        this.addUserArgs();
        this.addTag("1CIJVMMI", null);
        this.addTag("2CIJVMMIOFF", null);
        this.addTag("1CIENVVARS", lineRule);
        this.addEnvironmentVars();
        this.addStartTimeRule();
        this.addStartTimeNanoRule();
    }

    private void addCmdLineRule() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_cmd_line", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1CICMDLINE", lineRule);
    }

    private void addProcessIDRule() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_pid_string", CommonPatternMatchers.dec);
            }
        };
        this.addTag("1CIPROCESSID", lineRule);
    }

    private void addJITModesRule() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addToken("environment_jit_mode", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1CIJITMODES", lineRule);
    }

    private void addUserArgs() {
        final Matcher hexEnd = CommonPatternMatchers.generateMatcher(" 0x\\p{XDigit}+[\\r\\n]*$");
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                if (this.addAllCharactersAsTokenUntilFirstMatch("environment_arg_string", hexEnd) != null) {
                    this.addPrefixedHexToken("environment_arg_extra");
                } else {
                    this.addToken("environment_arg_string", CommonPatternMatchers.allButLineFeed);
                }
            }
        };
        this.addTag("2CIUSERARG", lineRule);
    }

    private void addEnvironmentVars() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_variable_name", NOT_EQUALS);
                if (this.consumeUntilFirstMatch(CommonPatternMatchers.equals)) {
                    this.addToken("environment_variable_value", CommonPatternMatchers.allButLineFeed);
                }
            }
        };
        this.addTag("2CIENVVAR", lineRule);
    }

    private void addStartTimeRule() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_start_time", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1CISTARTTIME", lineRule);
    }

    private void addStartTimeNanoRule() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_start_nano", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1CISTARTNANO", lineRule);
    }
}

