/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageSection;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaInstanceField;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JavaObject
implements com.ibm.dtfj.java.JavaObject {
    private JavaRuntime _javaVM;
    private ImagePointer _basePointer;
    private com.ibm.dtfj.java.j9.JavaHeap _containingHeap;
    private long _arrayletSpineSize;
    private long _arrayletLeafSize;
    private boolean _isArraylet = false;
    private int _objectAlignment;
    private byte _associatedObjectFlags = 0;
    private com.ibm.dtfj.java.JavaClass _associatedClass = null;
    private JavaMonitor _associatedMonitor = null;
    private JavaThread _associatedThread = null;
    private JavaClassLoader _associatedClassLoader = null;
    private static final byte CLASS_FLAG = 1;
    private static final byte THREAD_FLAG = 2;
    private static final byte MONITOR_FLAG = 4;
    private static final byte CLASSLOADER_FLAG = 8;
    protected static final String BOOLEAN_SIGNATURE = "Z";
    protected static final String BYTE_SIGNATURE = "B";
    protected static final String CHAR_SIGNATURE = "C";
    protected static final String SHORT_SIGNATURE = "S";
    protected static final String INTEGER_SIGNATURE = "I";
    protected static final String LONG_SIGNATURE = "J";
    protected static final String FLOAT_SIGNATURE = "F";
    protected static final String DOUBLE_SIGNATURE = "D";
    protected static final String ARRAY_PREFIX_SIGNATURE = "[";
    protected static final String OBJECT_PREFIX_SIGNATURE = "L";
    private Vector _references = null;

    JavaObject(JavaRuntime vm, ImagePointer address, com.ibm.dtfj.java.j9.JavaHeap containingHeap, long arrayletSpineSize, long arrayletLeafSize, boolean isArraylet, int objectAlignment) throws CorruptDataException {
        if (null == vm) {
            throw new IllegalArgumentException("A Java Object cannot exist in a null VM");
        }
        this._basePointer = address;
        this._javaVM = vm;
        this._containingHeap = containingHeap;
        this._arrayletSpineSize = arrayletSpineSize;
        this._arrayletLeafSize = arrayletLeafSize;
        this._isArraylet = isArraylet;
        this._objectAlignment = objectAlignment;
    }

    @Deprecated
    public static JavaObject createJavaObject(JavaRuntime vm, ImagePointer address) throws CorruptDataException {
        try {
            return (JavaObject)vm.getObjectAtAddress(address);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Deprecated
    public static JavaObject createJavaObject(JavaRuntime vm, ImagePointer address, com.ibm.dtfj.java.j9.JavaHeap containingHeap, JavaHeapRegion containingRegion) throws CorruptDataException {
        try {
            return (JavaObject)containingRegion.getObjectAtAddress(address);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public com.ibm.dtfj.java.JavaClass getJavaClass() throws CorruptDataException {
        if (0L != this._basePointer.getAddress()) {
            com.ibm.dtfj.java.JavaClass ret;
            ImagePointer classPointer;
            if (this._containingHeap == null) {
                throw new CorruptDataException(new CorruptData("unable to access class pointer as containing heap is null", this._basePointer));
            }
            try {
                classPointer = this._containingHeap.readClassPointerRelativeTo(this._basePointer);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptData("unable to access class pointer", this._basePointer));
            }
            long classID = classPointer.getAddress();
            long classAlignment = this._containingHeap.getClassAlignment();
            long alignedClassID = classID;
            if (classAlignment > 0L) {
                alignedClassID &= classAlignment - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((ret = this._javaVM.getClassForID(alignedClassID)) == null) {
                throw new CorruptDataException(new CorruptData("Unknown class ID " + Long.toHexString(alignedClassID) + " for object " + Long.toHexString(this._basePointer.getAddress()) + " (read class ID from " + Long.toHexString(classPointer.getAddress()) + ", in memory value was " + Long.toHexString(classID) + ")", this._basePointer));
            }
            return ret;
        }
        throw new NullPointerException();
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        return this.getJavaClass().isArray();
    }

    @Override
    public int getArraySize() throws CorruptDataException {
        com.ibm.dtfj.java.JavaClass isa = this.getJavaClass();
        if (isa instanceof JavaArrayClass) {
            JavaArrayClass blueprint = (JavaArrayClass)isa;
            int offset = blueprint.getSizeOffset();
            int numberOfSizeBytes = blueprint.getNumberOfSizeBytes();
            try {
                int numberOfElements = 0;
                if (4 == numberOfSizeBytes) {
                    numberOfElements = this._basePointer.getIntAt(offset);
                } else if (8 == numberOfSizeBytes) {
                    long longCount = this._basePointer.getLongAt(offset);
                    numberOfElements = (int)longCount;
                    if ((long)numberOfElements != longCount) {
                        System.err.println("Error:  Array element count overflow or underflow.");
                    }
                } else {
                    System.err.println("Error:  unable to read array size as we weren't expecting to read " + numberOfSizeBytes + " bytes.");
                }
                return numberOfElements;
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptData("unable to read the number of elements", this._basePointer.add(offset)));
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void arraycopy(int srcStart, Object dst, int dstStart, int length) throws CorruptDataException, MemoryAccessException {
        com.ibm.dtfj.java.JavaClass javaClass = this.getJavaClass();
        if (!(javaClass instanceof JavaArrayClass)) throw new IllegalArgumentException("this JavaObject instance is not an array");
        JavaArrayClass isa = (JavaArrayClass)javaClass;
        String type = javaClass.getName();
        int elementCount = this.getArraySize();
        if (null == dst) {
            throw new NullPointerException("dst is null");
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("length out of range: " + length);
        }
        if (dstStart < 0) {
            throw new ArrayIndexOutOfBoundsException("dstStart out of range: " + dstStart);
        }
        if (srcStart < 0) {
            throw new ArrayIndexOutOfBoundsException("srcStart out of range: " + srcStart);
        }
        if (srcStart + length > elementCount) {
            throw new ArrayIndexOutOfBoundsException("source array index out of range: " + (srcStart + length));
        }
        if (type.equals("[B")) {
            if (!(dst instanceof byte[])) throw new IllegalArgumentException("destination array type must be byte");
            byte[] target = (byte[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * 1);
                long leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * 1);
                target[x + dstStart] = leafBase.getByteAt(leafIndex);
            }
            return;
        }
        if (type.equals("[Z")) {
            if (!(dst instanceof boolean[])) throw new IllegalArgumentException("destination array type must be boolean");
            boolean[] target = (boolean[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                long leafIndex;
                ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * 1);
                target[x + dstStart] = 0 != leafBase.getByteAt(leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * 1));
            }
            return;
        }
        if (type.equals("[C")) {
            if (!(dst instanceof char[])) throw new IllegalArgumentException("destination array type must be char");
            char[] target = (char[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * 2);
                long leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * 2);
                target[x + dstStart] = (char)leafBase.getShortAt(leafIndex);
            }
            return;
        }
        if (type.equals("[S")) {
            if (!(dst instanceof short[])) throw new IllegalArgumentException("destination array type must be short");
            short[] target = (short[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * 2);
                long leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * 2);
                target[x + dstStart] = leafBase.getShortAt(leafIndex);
            }
            return;
        }
        if (type.equals("[I")) {
            if (!(dst instanceof int[])) throw new IllegalArgumentException("destination array type must be int");
            int[] target = (int[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * 4);
                long leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * 4);
                target[x + dstStart] = leafBase.getIntAt(leafIndex);
            }
            return;
        }
        if (type.equals("[J")) {
            if (!(dst instanceof long[])) throw new IllegalArgumentException("destination array type must be long");
            long[] target = (long[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * 8);
                long leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * 8);
                target[x + dstStart] = leafBase.getLongAt(leafIndex);
            }
            return;
        }
        if (type.equals("[F")) {
            if (!(dst instanceof float[])) throw new IllegalArgumentException("destination array type must be float");
            float[] target = (float[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * 4);
                long leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * 4);
                target[x + dstStart] = leafBase.getFloatAt(leafIndex);
            }
            return;
        }
        if (type.equals("[D")) {
            if (!(dst instanceof double[])) throw new IllegalArgumentException("destination array type must be double");
            double[] target = (double[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * 8);
                long leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * 8);
                target[x + dstStart] = leafBase.getDoubleAt(leafIndex);
            }
            return;
        }
        if (!(dst instanceof Object[])) {
            throw new IllegalArgumentException("destination array type must be Object");
        }
        Object[] target = (Object[])dst;
        if (dstStart + length > target.length) {
            throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
        }
        Object[] intermediateArray = new Object[length];
        for (int x = 0; x < length; ++x) {
            int fobjectSize = this._containingHeap.getFObjectSize();
            ImagePointer leafBase = this.leafBaseForIndex(isa.getFirstElementOffset(), (srcStart + x) * fobjectSize);
            long leafIndex = this.leafIndexForIndex(isa.getFirstElementOffset(), (srcStart + x) * fobjectSize);
            ImagePointer pointer = this._containingHeap.readFObjectAt(leafBase, leafIndex);
            try {
                if (pointer.getAddress() == 0L) {
                    intermediateArray[x] = null;
                    continue;
                }
                try {
                    intermediateArray[x] = this._javaVM.getObjectAtAddress(pointer);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new CorruptDataException(new CorruptData(e.getMessage(), pointer));
                }
            }
            catch (ArrayStoreException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        for (int i = 0; i < length; ++i) {
            try {
                target[dstStart + i] = intermediateArray[i];
                continue;
            }
            catch (ArrayStoreException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    private long leafIndexForIndex(int firstElementOffset, long index) {
        long ret = 0L;
        ret = this.isArraylet() ? index % this._arrayletLeafSize : (long)firstElementOffset + index;
        return ret;
    }

    private ImagePointer leafBaseForIndex(int firstElementOffset, long index) throws CorruptDataException, MemoryAccessException {
        ImagePointer ret = null;
        if (this.isArraylet()) {
            int fobjectSize = this._containingHeap.getFObjectSize();
            long pointerIndex = index / this._arrayletLeafSize;
            long pointerAddress = (long)firstElementOffset + (long)fobjectSize * pointerIndex;
            ret = this._containingHeap.readFObjectAt(this._basePointer, pointerAddress);
        } else {
            ret = this._basePointer;
        }
        return ret;
    }

    @Override
    public long getSize() throws CorruptDataException {
        Iterator sections = this.getSections();
        long size = 0L;
        while (sections.hasNext()) {
            Object qsect = sections.next();
            if (qsect instanceof ImageSection) {
                ImageSection section = (ImageSection)qsect;
                size += section.getSize();
                continue;
            }
            if (qsect instanceof CorruptData) {
                throw new CorruptDataException((CorruptData)qsect);
            }
            throw new RuntimeException("Found unexpected object " + qsect.getClass().getName());
        }
        return size;
    }

    @Override
    public long getHashcode() throws DataUnavailable, CorruptDataException {
        return this.getPersistentHashcode();
    }

    @Override
    public long getPersistentHashcode() throws DataUnavailable, CorruptDataException {
        if (this._javaVM.objectShouldInferHash()) {
            try {
                int flags = ((JavaAbstractClass)this.getJavaClass()).readFlagsFromInstance(this);
                int twoBytes = flags & 0x7FFF0000;
                long hash = twoBytes >> 16 | twoBytes;
                return hash;
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptData("Address in object header but unreadable", this._basePointer));
            }
        }
        throw new DataUnavailable("Unknown hash strategy for this VM version");
    }

    @Override
    public ImagePointer getID() {
        return this._basePointer;
    }

    @Override
    public Iterator getSections() {
        List<Object> sections;
        if (this.isArraylet()) {
            try {
                JavaArrayClass arrayForm = (JavaArrayClass)this.getJavaClass();
                int objectHeaderSize = arrayForm.getFirstElementOffset();
                int bytesPerPointer = this._javaVM.bytesPerPointer();
                try {
                    long headerAndLeafPointers;
                    int instanceSize = arrayForm.getInstanceSize(this);
                    long contentDataSize = instanceSize - objectHeaderSize;
                    int fullSizeLeaves = (int)(contentDataSize / this._arrayletLeafSize);
                    long tailLeafSize = contentDataSize % this._arrayletLeafSize;
                    int totalLeafCount = 0L == tailLeafSize ? fullSizeLeaves : fullSizeLeaves + 1;
                    String nestedType = arrayForm.getLeafClass().getName();
                    boolean alignmentCandidate = 4 == this._objectAlignment && ("double".equals(nestedType) || "long".equals(nestedType));
                    long spineSectionSize = headerAndLeafPointers = (long)(objectHeaderSize + totalLeafCount * bytesPerPointer);
                    long nextExpectedInteriorLeafAddress = this._basePointer.getAddress() + headerAndLeafPointers;
                    boolean doesHaveTailPadding = false;
                    if (alignmentCandidate && totalLeafCount > 0) {
                        if (0L == nextExpectedInteriorLeafAddress % 8L) {
                            doesHaveTailPadding = true;
                        } else {
                            spineSectionSize += 4L;
                            if (0L != (nextExpectedInteriorLeafAddress += 4L) % 8L) {
                                throw new CorruptDataException(new CorruptData("Arraylet leaf pointer misaligned for object", this._basePointer));
                            }
                        }
                    }
                    Vector<JavaObjectImageSection> externalSections = null;
                    for (int i = 0; i < totalLeafCount; ++i) {
                        ImagePointer leafPointer = this._basePointer.getPointerAt(objectHeaderSize + i * bytesPerPointer);
                        if (leafPointer.getAddress() == nextExpectedInteriorLeafAddress) {
                            long internalLeafSize = this._arrayletLeafSize;
                            if (fullSizeLeaves == i) {
                                internalLeafSize = tailLeafSize;
                            }
                            spineSectionSize += internalLeafSize;
                            nextExpectedInteriorLeafAddress += internalLeafSize;
                            continue;
                        }
                        if (null == externalSections) {
                            externalSections = new Vector<JavaObjectImageSection>();
                        }
                        externalSections.add(new JavaObjectImageSection(leafPointer, this._arrayletLeafSize));
                    }
                    if (doesHaveTailPadding) {
                        spineSectionSize += 4L;
                    }
                    spineSectionSize = Math.max(spineSectionSize, this._arrayletSpineSize);
                    JavaObjectImageSection spineSection = new JavaObjectImageSection(this._basePointer, spineSectionSize);
                    if (null == externalSections) {
                        sections = Collections.singletonList(spineSection);
                    } else {
                        sections = new Vector<com.ibm.dtfj.image.CorruptData>();
                        sections.add((com.ibm.dtfj.image.CorruptData)((Object)spineSection));
                        sections.addAll(externalSections);
                    }
                }
                catch (MemoryAccessException e) {
                    sections = Collections.singletonList(new CorruptData("failed to walk arraylet spine", e.getPointer()));
                }
            }
            catch (CorruptDataException e) {
                sections = Collections.singletonList(e.getCorruptData());
            }
        } else {
            long size = 0L;
            try {
                size = ((JavaAbstractClass)this.getJavaClass()).getInstanceSize(this);
                JavaObjectImageSection section = new JavaObjectImageSection(this._basePointer, size);
                sections = Collections.singletonList(section);
            }
            catch (CorruptDataException e) {
                sections = Collections.singletonList(e.getCorruptData());
            }
        }
        return sections.iterator();
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaObject) {
            JavaObject local = (JavaObject)obj;
            isEqual = this._javaVM.equals(local._javaVM) && this._basePointer.equals(local._basePointer);
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        return this._javaVM.hashCode() ^ this._basePointer.hashCode();
    }

    public boolean isArraylet() {
        return this._isArraylet;
    }

    public ImagePointer getFObjectAtOffset(int offset) throws MemoryAccessException, CorruptDataException {
        return this._containingHeap.readFObjectAt(this._basePointer, offset);
    }

    public int getFObjectSize() {
        return this._containingHeap.getFObjectSize();
    }

    @Override
    public Iterator getReferences() {
        if (null == this._references) {
            JavaReference ref;
            this._references = new Vector();
            try {
                com.ibm.dtfj.java.JavaClass jClass = this.getJavaClass();
                if (null != jClass) {
                    ref = new JavaReference(this._javaVM, (Object)this, jClass, "Class", 1, 0, 1);
                    this._references.add(ref);
                }
                while (null != jClass) {
                    List refs = null;
                    if (jClass instanceof JavaArrayClass) {
                        JavaArrayClass arrayClass = (JavaArrayClass)jClass;
                        refs = this.getArrayReferences(arrayClass);
                    } else if (jClass instanceof JavaClass) {
                        refs = this.getFieldReferences((JavaClass)jClass);
                    }
                    if (null != refs) {
                        this._references.addAll(refs);
                    }
                    jClass = jClass.getSuperclass();
                }
            }
            catch (CorruptDataException e) {
                this._references.add(e.getCorruptData());
            }
            if (this.isClassLoader()) {
                JavaClassLoader associatedClassLoader = this.getAssociatedClassLoader();
                Iterator classes = associatedClassLoader.getDefinedClasses();
                while (classes.hasNext()) {
                    Object potentialClass = classes.next();
                    if (!(potentialClass instanceof com.ibm.dtfj.java.JavaClass)) continue;
                    com.ibm.dtfj.java.JavaClass currentClass = (com.ibm.dtfj.java.JavaClass)potentialClass;
                    JavaReference ref2 = new JavaReference(this._javaVM, (Object)this, currentClass, "Loaded class", 11, 0, 1);
                    this._references.add(ref2);
                }
            }
            if (this.isMonitor()) {
                // empty if block
            }
            if (this.isThread()) {
                // empty if block
            }
            if (this.isClass()) {
                com.ibm.dtfj.java.JavaClass associatedClass = this.getAssociatedClass();
                ref = new JavaReference(this._javaVM, (Object)this, associatedClass, "Associated class", 13, 0, 1);
                this._references.add(ref);
            }
        }
        return this._references.iterator();
    }

    public boolean isClass() {
        return (this._associatedObjectFlags & 1) > 0;
    }

    public boolean isMonitor() {
        return (this._associatedObjectFlags & 4) > 0;
    }

    public boolean isThread() {
        return (this._associatedObjectFlags & 2) > 0;
    }

    public boolean isClassLoader() {
        return (this._associatedObjectFlags & 8) > 0;
    }

    private List getFieldReferences(JavaClass jClass) {
        ArrayList<JavaReference> fieldRefs = new ArrayList<JavaReference>();
        Iterator fieldIt = jClass.getDeclaredFields();
        while (fieldIt.hasNext()) {
            JavaField jField;
            JavaReference jRef;
            Object fObject = fieldIt.next();
            if (!(fObject instanceof JavaInstanceField) || null == (jRef = this.getFieldReference(jField = (JavaField)fObject))) continue;
            fieldRefs.add(jRef);
        }
        return fieldRefs;
    }

    private JavaReference getFieldReference(JavaField jField) {
        JavaReference jRef;
        block13: {
            jRef = null;
            try {
                String sigPrefix = jField.getSignature();
                com.ibm.dtfj.java.JavaClass jClass = this.getJavaClass();
                if (!sigPrefix.startsWith(OBJECT_PREFIX_SIGNATURE) && !sigPrefix.startsWith(ARRAY_PREFIX_SIGNATURE)) break block13;
                try {
                    JavaObject jObject = (JavaObject)jField.getReferenceType(this);
                    if (null != jObject) {
                        String fieldName = jField.getName();
                        String description = "Object Reference";
                        if (null != fieldName) {
                            description = description + " [field name:" + fieldName + "]";
                        }
                        int reachability = 1;
                        if ("referent".equals(fieldName) && "java/lang/ref/Reference".equals(jField.getDeclaringClass().getName())) {
                            if (this._javaVM._weakReferenceClass != null && this._javaVM._weakReferenceClass.isAncestorOf(jClass)) {
                                reachability = 3;
                            } else if (this._javaVM._softReferenceClass != null && this._javaVM._softReferenceClass.isAncestorOf(jClass)) {
                                reachability = 2;
                            } else if (this._javaVM._phantomReferenceClass != null && this._javaVM._phantomReferenceClass.isAncestorOf(jClass)) {
                                reachability = 4;
                            }
                        }
                        jRef = new JavaReference(this._javaVM, (Object)this, jObject, description, 2, 0, reachability);
                    }
                }
                catch (CorruptDataException corruptDataException) {}
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }
        return jRef;
    }

    private List getArrayReferences(JavaArrayClass arrayClass) {
        ArrayList<Object> references;
        block5: {
            references = new ArrayList<Object>();
            try {
                String type = arrayClass.getComponentType().getName();
                if (type.equals("byte") || type.equals("boolean") || type.equals("char") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double")) break block5;
                Object[] dst = null;
                int arraySize = this.getArraySize();
                if (arraySize <= 0) break block5;
                dst = new Object[arraySize];
                try {
                    this.arraycopy(0, dst, 0, arraySize);
                    for (int i = 0; i < dst.length; ++i) {
                        if (null == dst[i]) continue;
                        String description = "Array Reference";
                        description = description + " [index:" + i + "]";
                        JavaReference jRef = new JavaReference(this._javaVM, (Object)this, dst[i], description, 3, 0, 1);
                        references.add(jRef);
                    }
                }
                catch (MemoryAccessException e) {
                    ImagePointer ptrInError = e.getPointer();
                    String message = e.getMessage();
                    references.add(new CorruptData(message, ptrInError));
                }
            }
            catch (CorruptDataException e) {
                references.add(e.getCorruptData());
            }
        }
        return references;
    }

    @Override
    public JavaHeap getHeap() throws DataUnavailable {
        if (null == this._containingHeap) {
            throw new DataUnavailable("Containing heap not available for this object.");
        }
        return this._containingHeap;
    }

    public com.ibm.dtfj.java.JavaClass getAssociatedClass() {
        return this._associatedClass;
    }

    public void setAssociatedClass(com.ibm.dtfj.java.JavaClass associatedClass) {
        this._associatedObjectFlags = (byte)(this._associatedObjectFlags | 1);
        this._associatedClass = associatedClass;
    }

    public JavaMonitor getAssociatedMonitor() {
        return this._associatedMonitor;
    }

    public void setAssociatedMonitor(JavaMonitor associatedMonitor) {
        this._associatedObjectFlags = (byte)(this._associatedObjectFlags | 4);
        this._associatedMonitor = associatedMonitor;
    }

    public JavaThread getAssociatedThread() {
        return this._associatedThread;
    }

    public void setAssociatedThread(JavaThread associatedThread) {
        this._associatedObjectFlags = (byte)(this._associatedObjectFlags | 2);
        this._associatedThread = associatedThread;
    }

    public JavaClassLoader getAssociatedClassLoader() {
        return this._associatedClassLoader;
    }

    public void setAssociatedClassLoader(JavaClassLoader associatedClassLoader) {
        this._associatedObjectFlags = (byte)(this._associatedObjectFlags | 8);
        this._associatedClassLoader = associatedClassLoader;
    }

    public String toString() {
        try {
            String className = this.getJavaClass().getName();
            return "Instance of " + className + " @ " + this._basePointer;
        }
        catch (CorruptDataException e) {
            return super.toString();
        }
    }

    class JavaObjectImageSection
    extends ImageSection {
        public JavaObjectImageSection(ImagePointer base, long size) {
            super(base, size);
        }

        @Override
        public String getName() {
            return "In-memory Object section at 0x" + Long.toHexString(this.getBaseAddress().getAddress()) + " (0x" + Long.toHexString(this.getSize()) + " bytes)";
        }
    }
}

