/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;

public abstract class JavaField
implements com.ibm.dtfj.java.JavaField {
    protected static final String BOOLEAN_SIGNATURE = "Z";
    protected static final String BYTE_SIGNATURE = "B";
    protected static final String CHAR_SIGNATURE = "C";
    protected static final String SHORT_SIGNATURE = "S";
    protected static final String INTEGER_SIGNATURE = "I";
    protected static final String LONG_SIGNATURE = "J";
    protected static final String FLOAT_SIGNATURE = "F";
    protected static final String DOUBLE_SIGNATURE = "D";
    protected static final String OBJECT_PREFIX_SIGNATURE = "L";
    protected static final String ARRAY_PREFIX_SIGNATURE = "[";
    protected JavaRuntime _javaVM;
    private String _name;
    private String _signature;
    private int _modifiers;
    private long _declaringClassID;

    protected JavaField(JavaRuntime vm, String name, String signature, int modifiers, long declaringClassID) {
        if (null == vm) {
            throw new IllegalArgumentException("Java VM for a field must not be null");
        }
        if (null == name) {
            throw new IllegalArgumentException("A Java Field requires a non-null name");
        }
        if (null == signature) {
            throw new IllegalArgumentException("A Java Field requires a non-null signature");
        }
        this._javaVM = vm;
        this._name = name;
        this._signature = signature;
        this._modifiers = modifiers;
        this._declaringClassID = declaringClassID;
    }

    @Override
    public Object get(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(BOOLEAN_SIGNATURE)) {
            return this.getBoolean(object);
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return Character.valueOf(this.getChar(object));
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(object);
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return this.getLong(object);
        }
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            return Float.valueOf(this.getFloat(object));
        }
        if (this.getSignature().equals(DOUBLE_SIGNATURE)) {
            return this.getDouble(object);
        }
        if (this.getSignature().startsWith(OBJECT_PREFIX_SIGNATURE) || this.getSignature().startsWith(ARRAY_PREFIX_SIGNATURE)) {
            return this.getReferenceType(object);
        }
        throw new IllegalArgumentException("unidentified object signature [" + this.getSignature() + "]");
    }

    @Override
    public long getLong(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(object);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve long");
    }

    @Override
    public double getDouble(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(DOUBLE_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            return this.getFloat(object);
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(object);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(object);
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return this.getLong(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve double");
    }

    @Override
    public float getFloat(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(object);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(object);
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return this.getLong(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve float");
    }

    @Override
    public int getInt(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(object);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve int");
    }

    @Override
    public short getShort(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(object);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve short");
    }

    protected abstract Object getReferenceType(JavaObject var1) throws CorruptDataException, MemoryAccessException;

    @Override
    public int getModifiers() throws CorruptDataException {
        return this._modifiers;
    }

    @Override
    public JavaClass getDeclaringClass() throws CorruptDataException {
        JavaClass ret = this._javaVM.getClassForID(this._declaringClassID);
        if (ret == null) {
            throw new CorruptDataException(new CorruptData("Unknown declaring class ID " + this._declaringClassID, null));
        }
        return ret;
    }

    @Override
    public String getName() throws CorruptDataException {
        return this._name;
    }

    @Override
    public String getSignature() throws CorruptDataException {
        return this._signature;
    }

    @Override
    public String getString(JavaObject hostObject) throws CorruptDataException, MemoryAccessException {
        throw new CorruptDataException(new CorruptData("Cannot read String field in an endian aware manner", null));
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaField) {
            boolean hasSameName;
            JavaField field = (JavaField)obj;
            try {
                hasSameName = this._name.equals(field.getName());
            }
            catch (CorruptDataException cde) {
                hasSameName = false;
            }
            isEqual = hasSameName && this.getClass().equals(field.getClass()) && this._javaVM.equals(field._javaVM) && this._declaringClassID == field._declaringClassID;
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        return this._name.hashCode() ^ this._signature.hashCode() ^ this._javaVM.hashCode() ^ ((int)this._declaringClassID ^ (int)(this._declaringClassID >> 32));
    }

    public String toString() {
        try {
            return this.getDeclaringClass().getName() + "." + this.getName() + " : " + this.getSignature();
        }
        catch (CorruptDataException corruptDataException) {
            return super.toString();
        }
    }
}

