/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.util;

import com.ibm.dtfj.corereaders.zos.util.IntEnumeration;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractHashMap
implements Serializable {
    static final int INITIAL_SIZE = 17;
    long[] keys = new long[17];
    int tableSize = 17;
    int slotsInUse;
    int deletedSlots;
    byte[] state = new byte[17];
    static final byte EMPTY = 0;
    static final byte OCCUPIED = 1;
    static final byte DELETED = 2;
    private boolean inRehash;
    private static Logger log = Logger.getLogger(AbstractHashMap.class.getName());
    private static final boolean debug = log.isLoggable(Level.FINER);
    private static int callsToGetIndex;
    private static int callsToGetIndexSuccess;
    private static int loopsInGetIndex;
    private static int loopsBecauseNotEqual;
    private static int loopsBecauseDeleted;
    private static int callsToRehash;
    private static final int[] smallPrimes;

    abstract Object getValuesArray();

    abstract void allocNewValuesArray(int var1);

    abstract void put(long var1, Object var3, int var4);

    void rehash() {
        this.inRehash = true;
        if (debug) {
            ++callsToRehash;
            log.finer("rehashing, current size " + this.tableSize + " slots in use " + this.slotsInUse + " deleted " + this.deletedSlots);
            AbstractHashMap.printStats();
        }
        long[] oldkeys = this.keys;
        Object oldvalues = this.getValuesArray();
        byte[] oldstate = this.state;
        if (this.tableNeedsResize()) {
            this.tableSize <<= 1;
            while (!AbstractHashMap.isprime(++this.tableSize)) {
            }
            if (debug) {
                log.finer("new table size is " + this.tableSize);
            }
        }
        this.keys = new long[this.tableSize];
        this.allocNewValuesArray(this.tableSize);
        this.state = new byte[this.tableSize];
        this.slotsInUse = 0;
        this.deletedSlots = 0;
        for (int i = 0; i < oldkeys.length; ++i) {
            if (oldstate[i] != 1) continue;
            this.put(oldkeys[i], oldvalues, i);
        }
        this.inRehash = false;
    }

    int getIndex(long key) {
        if (debug) {
            ++callsToGetIndex;
        }
        for (int i = 0; i < this.tableSize; ++i) {
            int index = this.h(key & Long.MAX_VALUE, i);
            if (this.state[index] == 0) {
                return -1;
            }
            if (this.state[index] == 1 && this.keys[index] == key) {
                if (debug) {
                    ++callsToGetIndexSuccess;
                }
                return index;
            }
            if (!debug) continue;
            ++loopsInGetIndex;
            if (this.state[index] == 1) {
                ++loopsBecauseNotEqual;
                continue;
            }
            ++loopsBecauseDeleted;
        }
        return -1;
    }

    private static void printStats() {
        log.finer("callsToGetIndex = " + callsToGetIndex);
        log.finer("callsToGetIndexSuccess = " + callsToGetIndexSuccess);
        log.finer("loopsInGetIndex = " + loopsInGetIndex);
        log.finer("loopsBecauseNotEqual = " + loopsBecauseNotEqual);
        log.finer("loopsBecauseDeleted = " + loopsBecauseDeleted);
        log.finer("callsToRehash = " + callsToRehash);
    }

    int removeIndex(long key) {
        int index = this.getIndex(key);
        if (index != -1) {
            this.state[index] = 2;
            ++this.deletedSlots;
            --this.slotsInUse;
        }
        return index;
    }

    private boolean tableNeedsResize() {
        return this.slotsInUse > this.tableSize * 2 / 3;
    }

    void checkRehash() {
        if ((this.tableNeedsResize() || this.deletedSlots > this.tableSize / 3) && !this.inRehash) {
            this.rehash();
        }
    }

    int putIndex(long key) {
        for (int i = 0; i < this.tableSize; ++i) {
            int index = this.h(key & Long.MAX_VALUE, i);
            if (this.state[index] != 1) {
                this.keys[index] = key;
                if (this.state[index] == 2) {
                    --this.deletedSlots;
                }
                this.state[index] = 1;
                ++this.slotsInUse;
                return index;
            }
            if (this.keys[index] != key) continue;
            return index;
        }
        throw new Error("table full! key = " + key + " tableSize = " + this.tableSize + " slotsInUse = " + this.slotsInUse);
    }

    public IntEnumeration getKeys() {
        return new KeyEnum();
    }

    public long[] getKeysArray() {
        long[] akeys = new long[this.slotsInUse];
        int j = 0;
        for (int i = 0; i < this.tableSize; ++i) {
            if (this.state[i] != 1) continue;
            akeys[j++] = this.keys[i];
        }
        return akeys;
    }

    private int h(long k, int i) {
        long l = (long)this.h1(k) + (long)i * (long)this.h2(k);
        return (int)(l % (long)this.tableSize);
    }

    private int h1(long k) {
        return (int)(k % (long)this.tableSize);
    }

    private int h2(long k) {
        return (int)(1L + k % (long)(this.tableSize - 2));
    }

    private static boolean isprime(int x) {
        int stop;
        int div = 0;
        for (int i = 0; i < smallPrimes.length; ++i) {
            div = smallPrimes[i];
            if (x % div != 0) continue;
            return false;
        }
        for (stop = x; x / stop < stop; stop >>= 1) {
        }
        stop <<= 1;
        div += 2;
        while (div < stop) {
            if (x % div == 0) {
                return false;
            }
            div += 2;
        }
        return true;
    }

    static {
        smallPrimes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37};
    }

    private class KeyEnum
    implements IntEnumeration {
        int index = 0;
        boolean hasMore = true;

        KeyEnum() {
            this.reset();
        }

        void next() {
            while (this.index < AbstractHashMap.this.tableSize && AbstractHashMap.this.state[this.index] != 1) {
                ++this.index;
            }
            if (this.index == AbstractHashMap.this.tableSize) {
                this.hasMore = false;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMore;
        }

        public Object nextElement() {
            return this.nextInt();
        }

        @Override
        public long nextInt() {
            long key = AbstractHashMap.this.keys[this.index++];
            this.next();
            return key;
        }

        public long peekInt() {
            return AbstractHashMap.this.keys[this.index];
        }

        public void reset() {
            this.index = 0;
            this.hasMore = true;
            this.next();
        }
    }
}

