/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BitLevel;
import java.math.Conversion;
import java.math.Division;
import java.math.Elementary;
import java.math.Logical;
import java.math.Multiplication;
import java.math.Primality;
import java.util.Random;
import org.apache.harmony.math.internal.nls.Messages;

public class BigInteger
extends Number
implements Comparable<BigInteger>,
Serializable {
    private static final long serialVersionUID = -8287574255936472291L;
    transient int[] digits;
    static BigInteger maxInt = new BigInteger(1, Integer.MAX_VALUE);
    transient int numberLength;
    transient int sign;
    public static final BigInteger ZERO = new BigInteger(0, 0);
    public static final BigInteger ONE = new BigInteger(1, 1);
    public static final BigInteger TEN = new BigInteger(1, 10);
    static final BigInteger MINUS_ONE = new BigInteger(-1, 1);
    static final int EQUALS = 0;
    static final int GREATER = 1;
    static final int LESS = -1;
    static final BigInteger[] SMALL_VALUES = new BigInteger[]{ZERO, ONE, new BigInteger(1, 2), new BigInteger(1, 3), new BigInteger(1, 4), new BigInteger(1, 5), new BigInteger(1, 6), new BigInteger(1, 7), new BigInteger(1, 8), new BigInteger(1, 9), TEN};
    static final BigInteger[] TWO_POWS = new BigInteger[32];
    private transient int firstNonzeroDigit = -2;
    private int signum;
    private byte[] magnitude;
    private int bitCount;
    private int firstNonzeroByteNum;
    private int bitLength;
    private int lowestSetBit;
    private transient int hashCode = 0;

    public BigInteger(int n, Random random) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("math.1B"));
        }
        if (n == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = 1;
            this.numberLength = n + 31 >> 5;
            this.digits = new int[this.numberLength];
            for (int i = 0; i < this.numberLength; ++i) {
                this.digits[i] = random.nextInt();
            }
            int n2 = this.numberLength - 1;
            this.digits[n2] = this.digits[n2] >>> (-n & 0x1F);
            this.cutOffLeadingZeroes();
        }
    }

    public BigInteger(int n, int n2, Random random) {
        if (n < 2) {
            throw new ArithmeticException(Messages.getString("math.1C"));
        }
        BigInteger bigInteger = Primality.consBigInteger(n, n2, random);
        this.sign = bigInteger.sign;
        this.numberLength = bigInteger.numberLength;
        this.digits = bigInteger.digits;
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n < 2 || n > 36) {
            throw new NumberFormatException(Messages.getString("math.11"));
        }
        if (string.length() == 0) {
            throw new NumberFormatException(Messages.getString("math.12"));
        }
        BigInteger.setFromString(this, string, n);
    }

    public BigInteger(int n, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < -1 || n > 1) {
            throw new NumberFormatException(Messages.getString("math.13"));
        }
        if (n == 0) {
            for (byte by : byArray) {
                if (by == 0) continue;
                throw new NumberFormatException(Messages.getString("math.14"));
            }
        }
        if (byArray.length == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = n;
            this.putBytesPositiveToIntegers(byArray);
            this.cutOffLeadingZeroes();
        }
    }

    public BigInteger(byte[] byArray) {
        if (byArray.length == 0) {
            throw new NumberFormatException(Messages.getString("math.12"));
        }
        if (byArray[0] < 0) {
            this.sign = -1;
            this.putBytesNegativeToIntegers(byArray);
        } else {
            this.sign = 1;
            this.putBytesPositiveToIntegers(byArray);
        }
        this.cutOffLeadingZeroes();
    }

    BigInteger(int n, int n2) {
        this.sign = n;
        this.numberLength = 1;
        this.digits = new int[]{n2};
    }

    BigInteger(int n, int n2, int[] nArray) {
        this.sign = n;
        this.numberLength = n2;
        this.digits = nArray;
    }

    BigInteger(int n, long l) {
        this.sign = n;
        if ((l & 0xFFFFFFFF00000000L) == 0L) {
            this.numberLength = 1;
            this.digits = new int[]{(int)l};
        } else {
            this.numberLength = 2;
            this.digits = new int[]{(int)l, (int)(l >> 32)};
        }
    }

    BigInteger(int n, int[] nArray) {
        if (nArray.length == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = n;
            this.numberLength = nArray.length;
            this.digits = nArray;
            this.cutOffLeadingZeroes();
        }
    }

    public static BigInteger valueOf(long l) {
        if (l < 0L) {
            if (l != -1L) {
                return new BigInteger(-1, -l);
            }
            return MINUS_ONE;
        }
        if (l <= 10L) {
            return SMALL_VALUES[(int)l];
        }
        return new BigInteger(1, l);
    }

    public byte[] toByteArray() {
        int n;
        if (this.sign == 0) {
            return new byte[]{0};
        }
        BigInteger bigInteger = this;
        int n2 = this.bitLength();
        int n3 = this.getFirstNonzeroDigit();
        int n4 = (n2 >> 3) + 1;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 4;
        if (n4 - (this.numberLength << 2) == 1) {
            byArray[0] = (byte)(this.sign < 0 ? -1 : 0);
            n = 4;
            ++n5;
        } else {
            int n8 = n4 & 3;
            n = n8 == 0 ? 4 : n8;
        }
        n6 = n3;
        n4 -= n3 << 2;
        if (this.sign < 0) {
            int n9 = -bigInteger.digits[n6];
            if (++n6 == this.numberLength) {
                n7 = n;
            }
            int n10 = 0;
            while (n10 < n7) {
                byArray[--n4] = (byte)n9;
                ++n10;
                n9 >>= 8;
            }
            while (n4 > n5) {
                n9 = ~bigInteger.digits[n6];
                if (++n6 == this.numberLength) {
                    n7 = n;
                }
                n10 = 0;
                while (n10 < n7) {
                    byArray[--n4] = (byte)n9;
                    ++n10;
                    n9 >>= 8;
                }
            }
        } else {
            while (n4 > n5) {
                int n11 = bigInteger.digits[n6];
                if (++n6 == this.numberLength) {
                    n7 = n;
                }
                int n12 = 0;
                while (n12 < n7) {
                    byArray[--n4] = (byte)n11;
                    ++n12;
                    n11 >>= 8;
                }
            }
        }
        return byArray;
    }

    private static void setFromString(BigInteger bigInteger, String string, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n5 = string.length();
        int n7 = string.lastIndexOf(45);
        if (n7 + (n4 = string.lastIndexOf(43)) <= -1) {
            if ((n7 == 0 || n4 == 0) && n5 == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
        } else {
            throw new NumberFormatException("Illegal embedded sign character");
        }
        if (string.charAt(0) == '-') {
            n3 = -1;
            n2 = 1;
            --n5;
        } else {
            n3 = 1;
            n2 = 0;
        }
        int n8 = Conversion.digitFitInInt[n];
        int n9 = n5 / n8;
        int n10 = n5 % n8;
        if (n10 != 0) {
            ++n9;
        }
        int[] nArray = new int[n9];
        int n11 = Conversion.bigRadices[n - 2];
        int n12 = 0;
        int n13 = n2 + (n10 == 0 ? n8 : n10);
        int n14 = n2;
        while (n14 < n6) {
            int n15 = Integer.parseInt(string.substring(n14, n13), n);
            int n16 = Multiplication.multiplyByInt(nArray, n12, n11);
            nArray[n12++] = n16 += Elementary.inplaceAdd(nArray, n12, n15);
            n14 = n13;
            n13 = n14 + n8;
        }
        int n17 = n12;
        bigInteger.sign = n3;
        bigInteger.numberLength = n17;
        bigInteger.digits = nArray;
        bigInteger.cutOffLeadingZeroes();
    }

    public BigInteger abs() {
        return this.sign < 0 ? new BigInteger(1, this.numberLength, this.digits) : this;
    }

    public BigInteger negate() {
        return this.sign == 0 ? this : new BigInteger(-this.sign, this.numberLength, this.digits);
    }

    public BigInteger add(BigInteger bigInteger) {
        return Elementary.add(this, bigInteger);
    }

    public BigInteger subtract(BigInteger bigInteger) {
        return Elementary.subtract(this, bigInteger);
    }

    public int signum() {
        return this.sign;
    }

    public BigInteger shiftRight(int n) {
        if (n == 0 || this.sign == 0) {
            return this;
        }
        return n > 0 ? BitLevel.shiftRight(this, n) : BitLevel.shiftLeft(this, -n);
    }

    public BigInteger shiftLeft(int n) {
        if (n == 0 || this.sign == 0) {
            return this;
        }
        return n > 0 ? BitLevel.shiftLeft(this, n) : BitLevel.shiftRight(this, -n);
    }

    BigInteger shiftLeftOneBit() {
        return this.sign == 0 ? this : BitLevel.shiftLeftOneBit(this);
    }

    public int bitLength() {
        return BitLevel.bitLength(this);
    }

    public boolean testBit(int n) {
        if (n == 0) {
            return (this.digits[0] & 1) != 0;
        }
        if (n < 0) {
            throw new ArithmeticException(Messages.getString("math.15"));
        }
        int n2 = n >> 5;
        if (n2 >= this.numberLength) {
            return this.sign < 0;
        }
        int n3 = this.digits[n2];
        n = 1 << (n & 0x1F);
        if (this.sign < 0) {
            int n4 = this.getFirstNonzeroDigit();
            if (n2 < n4) {
                return false;
            }
            n3 = n4 == n2 ? -n3 : (n3 ^= 0xFFFFFFFF);
        }
        return (n3 & n) != 0;
    }

    public BigInteger setBit(int n) {
        if (!this.testBit(n)) {
            return BitLevel.flipBit(this, n);
        }
        return this;
    }

    public BigInteger clearBit(int n) {
        if (this.testBit(n)) {
            return BitLevel.flipBit(this, n);
        }
        return this;
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException(Messages.getString("math.15"));
        }
        return BitLevel.flipBit(this, n);
    }

    public int getLowestSetBit() {
        if (this.sign == 0) {
            return -1;
        }
        int n = this.getFirstNonzeroDigit();
        return (n << 5) + Integer.numberOfTrailingZeros(this.digits[n]);
    }

    public int bitCount() {
        return BitLevel.bitCount(this);
    }

    public BigInteger not() {
        return Logical.not(this);
    }

    public BigInteger and(BigInteger bigInteger) {
        return Logical.and(this, bigInteger);
    }

    public BigInteger or(BigInteger bigInteger) {
        return Logical.or(this, bigInteger);
    }

    public BigInteger xor(BigInteger bigInteger) {
        return Logical.xor(this, bigInteger);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        return Logical.andNot(this, bigInteger);
    }

    @Override
    public int intValue() {
        return this.sign * this.digits[0];
    }

    @Override
    public long longValue() {
        long l = this.numberLength > 1 ? (long)this.digits[1] << 32 | (long)this.digits[0] & 0xFFFFFFFFL : (long)this.digits[0] & 0xFFFFFFFFL;
        return (long)this.sign * l;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return Conversion.bigInteger2Double(this);
    }

    @Override
    public int compareTo(BigInteger bigInteger) {
        if (this.sign > bigInteger.sign) {
            return 1;
        }
        if (this.sign < bigInteger.sign) {
            return -1;
        }
        if (this.numberLength > bigInteger.numberLength) {
            return this.sign;
        }
        if (this.numberLength < bigInteger.numberLength) {
            return -bigInteger.sign;
        }
        return this.sign * Elementary.compareArrays(this.digits, bigInteger.digits, this.numberLength);
    }

    public BigInteger min(BigInteger bigInteger) {
        return this.compareTo(bigInteger) == -1 ? this : bigInteger;
    }

    public BigInteger max(BigInteger bigInteger) {
        return this.compareTo(bigInteger) == 1 ? this : bigInteger;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int n = 0;
        int n2 = this.digits.length;
        while (n2 > 0 && this.digits[--n2] == 0) {
        }
        for (int i = 0; i <= n2; ++i) {
            n = n * 33 + (this.digits[i] & 0xFFFFFFFF);
        }
        this.hashCode = n * this.sign;
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            return this.sign == bigInteger.sign && this.numberLength == bigInteger.numberLength && this.equalsArrays(bigInteger.digits);
        }
        return false;
    }

    boolean equalsArrays(int[] nArray) {
        int n;
        for (n = this.numberLength - 1; n >= 0 && this.digits[n] == nArray[n]; --n) {
        }
        return n < 0;
    }

    public String toString() {
        return Conversion.toDecimalScaledString(this, 0);
    }

    public String toString(int n) {
        return Conversion.bigInteger2String(this, n);
    }

    public BigInteger gcd(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.abs();
        BigInteger bigInteger3 = bigInteger.abs();
        if (bigInteger2.signum() == 0) {
            return bigInteger3;
        }
        if (bigInteger3.signum() == 0) {
            return bigInteger2;
        }
        if ((bigInteger2.numberLength == 1 || bigInteger2.numberLength == 2 && bigInteger2.digits[1] > 0) && (bigInteger3.numberLength == 1 || bigInteger3.numberLength == 2 && bigInteger3.digits[1] > 0)) {
            return BigInteger.valueOf(Division.gcdBinary(bigInteger2.longValue(), bigInteger3.longValue()));
        }
        return Division.gcdBinary(bigInteger2.copy(), bigInteger3.copy());
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (bigInteger.sign == 0) {
            return ZERO;
        }
        if (this.sign == 0) {
            return ZERO;
        }
        return Multiplication.multiply(this, bigInteger);
    }

    public BigInteger pow(int n) {
        if (n < 0) {
            throw new ArithmeticException(Messages.getString("math.16"));
        }
        if (n == 0) {
            return ONE;
        }
        if (n == 1 || this.equals(ONE) || this.equals(ZERO)) {
            return this;
        }
        if (!this.testBit(0)) {
            int n2 = 1;
            while (!this.testBit(n2)) {
                ++n2;
            }
            return BigInteger.getPowerOfTwo(n2 * n).multiply(this.shiftRight(n2).pow(n));
        }
        return Multiplication.pow(this, n);
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        int n;
        int n2 = bigInteger.sign;
        if (n2 == 0) {
            throw new ArithmeticException(Messages.getString("math.17"));
        }
        int n3 = bigInteger.numberLength;
        int[] nArray = bigInteger.digits;
        if (n3 == 1) {
            return Division.divideAndRemainderByInteger(this, nArray[0], n2);
        }
        int[] nArray2 = this.digits;
        int n4 = this.numberLength;
        int n5 = n4 != n3 ? (n4 > n3 ? 1 : -1) : (n = Elementary.compareArrays(nArray2, nArray, n4));
        if (n < 0) {
            return new BigInteger[]{ZERO, this};
        }
        int n6 = this.sign;
        int n7 = n4 - n3 + 1;
        int n8 = n3;
        int n9 = n6 == n2 ? 1 : -1;
        int[] nArray3 = new int[n7];
        int[] nArray4 = Division.divide(nArray3, n7, nArray2, n4, nArray, n3);
        BigInteger bigInteger2 = new BigInteger(n9, n7, nArray3);
        BigInteger bigInteger3 = new BigInteger(n6, n8, nArray4);
        bigInteger2.cutOffLeadingZeroes();
        bigInteger3.cutOffLeadingZeroes();
        return new BigInteger[]{bigInteger2, bigInteger3};
    }

    public BigInteger divide(BigInteger bigInteger) {
        int n;
        int n2;
        if (bigInteger.sign == 0) {
            throw new ArithmeticException(Messages.getString("math.17"));
        }
        int n3 = bigInteger.sign;
        if (bigInteger.isOne()) {
            return bigInteger.sign > 0 ? this : this.negate();
        }
        int n4 = this.sign;
        int n5 = this.numberLength;
        int n6 = bigInteger.numberLength;
        if (n5 + n6 == 2) {
            long l = ((long)this.digits[0] & 0xFFFFFFFFL) / ((long)bigInteger.digits[0] & 0xFFFFFFFFL);
            if (n4 != n3) {
                l = -l;
            }
            return BigInteger.valueOf(l);
        }
        int n7 = n5 != n6 ? (n5 > n6 ? 1 : -1) : (n2 = Elementary.compareArrays(this.digits, bigInteger.digits, n5));
        if (n2 == 0) {
            return n4 == n3 ? ONE : MINUS_ONE;
        }
        if (n2 == -1) {
            return ZERO;
        }
        int n8 = n5 - n6 + 1;
        int[] nArray = new int[n8];
        int n9 = n = n4 == n3 ? 1 : -1;
        if (n6 == 1) {
            Division.divideArrayByInt(nArray, this.digits, n5, bigInteger.digits[0]);
        } else {
            Division.divide(nArray, n8, this.digits, n5, bigInteger.digits, n6);
        }
        BigInteger bigInteger2 = new BigInteger(n, n8, nArray);
        bigInteger2.cutOffLeadingZeroes();
        return bigInteger2;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        if (bigInteger.sign == 0) {
            throw new ArithmeticException(Messages.getString("math.17"));
        }
        int n = this.numberLength;
        int n2 = bigInteger.numberLength;
        if ((n != n2 ? (n > n2 ? 1 : -1) : Elementary.compareArrays(this.digits, bigInteger.digits, n)) == -1) {
            return this;
        }
        int n3 = n2;
        int[] nArray = new int[n3];
        if (n3 == 1) {
            nArray[0] = Division.remainderArrayByInt(this.digits, n, bigInteger.digits[0]);
        } else {
            int n4 = n - n2 + 1;
            nArray = Division.divide(null, n4, this.digits, n, bigInteger.digits, n2);
        }
        BigInteger bigInteger2 = new BigInteger(this.sign, n3, nArray);
        bigInteger2.cutOffLeadingZeroes();
        return bigInteger2;
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        if (bigInteger.sign <= 0) {
            throw new ArithmeticException(Messages.getString("math.18"));
        }
        if (!this.testBit(0) && !bigInteger.testBit(0)) {
            throw new ArithmeticException(Messages.getString("math.19"));
        }
        if (bigInteger.isOne()) {
            return ZERO;
        }
        BigInteger bigInteger2 = Division.modInverseMontgomery(this.abs().mod(bigInteger), bigInteger);
        if (bigInteger2.sign == 0) {
            throw new ArithmeticException(Messages.getString("math.19"));
        }
        bigInteger2 = this.sign < 0 ? bigInteger.subtract(bigInteger2) : bigInteger2;
        return bigInteger2;
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        if (bigInteger2.sign <= 0) {
            throw new ArithmeticException(Messages.getString("math.18"));
        }
        int n = bigInteger2.getLowestSetBit();
        if (n >= 31) {
            if (bigInteger.compareTo(maxInt) <= 0) {
                int n2 = bigInteger.intValue();
                BigInteger bigInteger4 = this.pow(n2);
                return bigInteger4.mod(bigInteger2);
            }
            throw new ArithmeticException("BigInteger: pow of this ^ exponent is too large");
        }
        BigInteger bigInteger5 = this;
        if (bigInteger2.isOne() | bigInteger.sign > 0 & bigInteger5.sign == 0) {
            return ZERO;
        }
        if (bigInteger.sign == 0) {
            return ONE.mod(bigInteger2);
        }
        if (bigInteger.sign < 0) {
            bigInteger5 = this.modInverse(bigInteger2);
            bigInteger = bigInteger.negate();
        }
        BigInteger bigInteger6 = bigInteger3 = bigInteger2.testBit(0) ? Division.oddModPow(bigInteger5.abs(), bigInteger, bigInteger2) : Division.evenModPow(bigInteger5.abs(), bigInteger, bigInteger2);
        if (bigInteger5.sign < 0 && bigInteger.testBit(0)) {
            bigInteger3 = bigInteger2.subtract(ONE).multiply(bigInteger3).mod(bigInteger2);
        }
        return bigInteger3;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (bigInteger.sign <= 0) {
            throw new ArithmeticException(Messages.getString("math.18"));
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        return bigInteger2.sign < 0 ? bigInteger2.add(bigInteger) : bigInteger2;
    }

    public boolean isProbablePrime(int n) {
        return Primality.isProbablePrime(this.abs(), n);
    }

    public BigInteger nextProbablePrime() {
        if (this.sign < 0) {
            throw new ArithmeticException(Messages.getString("math.1A", this));
        }
        return Primality.nextProbablePrime(this);
    }

    public static BigInteger probablePrime(int n, Random random) {
        return new BigInteger(n, 100, random);
    }

    final void cutOffLeadingZeroes() {
        while (this.numberLength > 0 && this.digits[--this.numberLength] == 0) {
        }
        if (this.digits[this.numberLength++] == 0) {
            this.sign = 0;
        }
        for (int i = this.numberLength + 1; i < this.digits.length; ++i) {
            this.digits[i] = 0;
        }
    }

    boolean isOne() {
        return this.numberLength == 1 && this.digits[0] == 1;
    }

    private void putBytesPositiveToIntegers(byte[] byArray) {
        int n;
        int n2 = (n = byArray.length) & 3;
        this.numberLength = (n >> 2) + (n2 == 0 ? 0 : 1);
        this.digits = new int[this.numberLength];
        int n3 = 0;
        while (n > n2) {
            this.digits[n3++] = byArray[--n] & 0xFF | (byArray[--n] & 0xFF) << 8 | (byArray[--n] & 0xFF) << 16 | (byArray[--n] & 0xFF) << 24;
        }
        for (int i = 0; i < n; ++i) {
            this.digits[n3] = this.digits[n3] << 8 | byArray[i] & 0xFF;
        }
    }

    private void putBytesNegativeToIntegers(byte[] byArray) {
        int n;
        int n2 = (n = byArray.length) & 3;
        this.numberLength = (n >> 2) + (n2 == 0 ? 0 : 1);
        this.digits = new int[this.numberLength];
        int n3 = 0;
        this.digits[this.numberLength - 1] = -1;
        while (n > n2) {
            this.digits[n3] = byArray[--n] & 0xFF | (byArray[--n] & 0xFF) << 8 | (byArray[--n] & 0xFF) << 16 | (byArray[--n] & 0xFF) << 24;
            if (this.digits[n3] != 0) {
                this.digits[n3] = -this.digits[n3];
                this.firstNonzeroDigit = n3++;
                while (n > n2) {
                    this.digits[n3] = byArray[--n] & 0xFF | (byArray[--n] & 0xFF) << 8 | (byArray[--n] & 0xFF) << 16 | (byArray[--n] & 0xFF) << 24;
                    this.digits[n3] = ~this.digits[n3];
                    ++n3;
                }
                break;
            }
            ++n3;
        }
        if (n2 != 0) {
            if (this.firstNonzeroDigit != -2) {
                for (int i = 0; i < n; ++i) {
                    this.digits[n3] = this.digits[n3] << 8 | byArray[i] & 0xFF;
                }
                this.digits[n3] = ~this.digits[n3];
            } else {
                for (int i = 0; i < n; ++i) {
                    this.digits[n3] = this.digits[n3] << 8 | byArray[i] & 0xFF;
                }
                this.digits[n3] = -this.digits[n3];
            }
        }
    }

    int getFirstNonzeroDigit() {
        if (this.firstNonzeroDigit == -2) {
            int n;
            if (this.sign == 0) {
                n = -1;
            } else {
                n = 0;
                while (this.digits[n] == 0) {
                    ++n;
                }
            }
            this.firstNonzeroDigit = n;
        }
        return this.firstNonzeroDigit;
    }

    BigInteger copy() {
        int[] nArray = new int[this.numberLength];
        System.arraycopy(this.digits, 0, nArray, 0, this.numberLength);
        return new BigInteger(this.sign, this.numberLength, nArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.magnitude.length == 0) {
            if (this.signum != 0) {
                throw new StreamCorruptedException(Messages.getString("math.14"));
            }
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = this.signum;
            this.putBytesPositiveToIntegers(this.magnitude);
            this.firstNonzeroDigit = this.firstNonzeroByteNum;
            this.cutOffLeadingZeroes();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.bitCount = this.bitCount();
        this.firstNonzeroByteNum = this.getFirstNonzeroDigit();
        this.bitLength = this.bitLength();
        this.lowestSetBit = this.getLowestSetBit();
        this.signum = this.signum();
        byte[] byArray = this.abs().toByteArray();
        this.magnitude = this.sign == 0 && byArray.length != 0 ? new byte[]{} : byArray;
        objectOutputStream.defaultWriteObject();
    }

    void unCache() {
        this.firstNonzeroDigit = -2;
    }

    static BigInteger getPowerOfTwo(int n) {
        if (n < TWO_POWS.length) {
            return TWO_POWS[n];
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        int[] nArray = new int[n2 + 1];
        nArray[n2] = 1 << n3;
        return new BigInteger(1, n2 + 1, nArray);
    }

    public long longValueExact() {
        if (this.numberLength <= 2 && this.bitLength() <= 63) {
            return this.longValue();
        }
        throw new ArithmeticException("BigInteger out of long range");
    }

    public int intValueExact() {
        if (this.numberLength <= 1 && this.bitLength() <= 31) {
            return this.intValue();
        }
        throw new ArithmeticException("BigInteger out of int range");
    }

    public short shortValueExact() {
        int n;
        if (this.numberLength <= 1 && this.bitLength() <= 31 && (n = this.intValue()) >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            return this.shortValue();
        }
        throw new ArithmeticException("BigInteger out of short range");
    }

    public byte byteValueExact() {
        int n;
        if (this.numberLength <= 1 && this.bitLength() <= 31 && (n = this.intValue()) >= -128 && n <= 127) {
            return this.byteValue();
        }
        throw new ArithmeticException("BigInteger out of byte range");
    }

    static {
        for (int i = 0; i < TWO_POWS.length; ++i) {
            BigInteger.TWO_POWS[i] = BigInteger.valueOf(1L << i);
        }
    }
}

