/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.ws.install.internal.cmdline.ExeHelpAction;
import com.ibm.ws.install.utility.internal.cmdline.Action;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class HelpAction
implements ActionHandler {
    public static final String NL = System.getProperty("line.separator");
    public static final String COMMAND = "installUtility";
    public static final ResourceBundle featureToolOptions = ExeHelpAction.getOptions();
    public static final ResourceBundle installUtilityToolOptions = ResourceBundle.getBundle("com.ibm.ws.install.utility.internal.resources.InstallUtilityToolOptions");
    private static final ResourceBundle licenseOptions = ResourceBundle.getBundle("wlp.lib.extract.SelfExtractMessages");
    private static final Map<String, String> LICENSE_KEY_MAPPING = new HashMap<String, String>();

    public String getScriptUsage() {
        StringBuffer scriptUsage = new StringBuffer(NL);
        scriptUsage.append(HelpAction.getHelpPart("usage", COMMAND));
        scriptUsage.append(" {");
        Action[] tasks = Action.values();
        for (int i = 0; i < tasks.length; ++i) {
            Action task = tasks[i];
            scriptUsage.append(task.toString());
            if (i == tasks.length - 1) continue;
            scriptUsage.append("|");
        }
        scriptUsage.append("} [");
        scriptUsage.append(HelpAction.getHelpPart("global.options.lower", new Object[0]));
        scriptUsage.append("]");
        scriptUsage.append(NL);
        return scriptUsage.toString();
    }

    public String getTaskUsage(Action task) {
        StringBuilder taskUsage = new StringBuilder(NL);
        taskUsage.append(HelpAction.getHelpPart("global.usage", new Object[0]));
        taskUsage.append(NL);
        taskUsage.append('\t');
        taskUsage.append(COMMAND);
        taskUsage.append(' ');
        taskUsage.append((Object)task);
        if (task.showOptions()) {
            taskUsage.append(" [");
            taskUsage.append(HelpAction.getHelpPart("global.options.lower", new Object[0]));
            taskUsage.append("]");
        }
        List<String> options = task.getCommandOptions();
        for (String option : options) {
            if (option.charAt(0) == '-') continue;
            taskUsage.append(' ');
            taskUsage.append(option);
        }
        taskUsage.append(NL);
        taskUsage.append(NL);
        taskUsage.append(HelpAction.getHelpPart("global.description", new Object[0]));
        taskUsage.append(NL);
        taskUsage.append(this.getDescription(task));
        taskUsage.append(NL);
        if (options.size() > 0) {
            taskUsage.append(NL);
            taskUsage.append(HelpAction.getHelpPart("global.options", new Object[0]));
            for (String option : task.getCommandOptions()) {
                String optionKey;
                taskUsage.append(NL);
                try {
                    optionKey = HelpAction.getHelpPart((Object)((Object)task) + ".option-key." + option, new Object[0]);
                }
                catch (MissingResourceException e) {
                    optionKey = "    " + option;
                }
                taskUsage.append(optionKey);
                taskUsage.append(NL);
                taskUsage.append(HelpAction.getHelpPart((Object)((Object)task) + ".option-desc." + option, new Object[0]));
                taskUsage.append(NL);
            }
        }
        taskUsage.append(NL);
        return taskUsage.toString();
    }

    private StringBuilder verboseHelp() {
        StringBuilder verboseHelp = new StringBuilder(this.getScriptUsage());
        verboseHelp.append(NL);
        verboseHelp.append(HelpAction.getHelpPart("global.actions", new Object[0]));
        verboseHelp.append(NL);
        for (Action action : Action.values()) {
            verboseHelp.append(NL);
            verboseHelp.append("    ");
            verboseHelp.append(action.toString());
            verboseHelp.append(NL);
            verboseHelp.append(this.getDescription(action));
            verboseHelp.append(NL);
        }
        verboseHelp.append(NL);
        verboseHelp.append(HelpAction.getHelpPart("global.options", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(HelpAction.getHelpPart("global.options.statement", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(NL);
        return verboseHelp;
    }

    private String getDescription(Action action) {
        return HelpAction.getHelpPart((Object)((Object)action) + ".desc", new Object[0]);
    }

    public ReturnCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        ReturnCode retCode = ReturnCode.OK;
        String actionName = args.getAction();
        if (actionName == null) {
            stdout.println(this.getScriptUsage());
        } else if (args.getPositionalArguments().isEmpty()) {
            stdout.println(this.verboseHelp());
        } else {
            try {
                Action task = Action.valueOf((String)args.getPositionalArguments().get(0));
                stdout.println(this.getTaskUsage(task));
            }
            catch (IllegalArgumentException e) {
                stderr.println();
                stderr.println(HelpAction.getHelpPart("task.unknown", args.getPositionalArguments().get(0)));
                stdout.println(this.getScriptUsage());
                retCode = ReturnCode.BAD_ARGUMENT;
            }
        }
        return retCode;
    }

    public static String getHelpPart(String key, Object ... args) {
        String option;
        if (LICENSE_KEY_MAPPING.containsKey(key)) {
            option = MessageFormat.format(licenseOptions.getString(key = LICENSE_KEY_MAPPING.get(key)), new Object[0]);
            if (!option.isEmpty() && !Character.isWhitespace(option.charAt(0))) {
                option = "\t" + option.replaceAll("[\r\n]+", "$0\t");
            }
        } else {
            option = installUtilityToolOptions.getString(key);
        }
        return args.length == 0 ? option : MessageFormat.format(option, args);
    }

    static {
        LICENSE_KEY_MAPPING.put("deploy.option-desc.--acceptLicense", "helpAcceptLicense");
        LICENSE_KEY_MAPPING.put("deploy.option-desc.--viewLicenseAgreement", "helpAgreement");
        LICENSE_KEY_MAPPING.put("deploy.option-desc.--viewLicenseInfo", "helpInformation");
        LICENSE_KEY_MAPPING.put("download.option-desc.--acceptLicense", "helpAcceptLicense");
        LICENSE_KEY_MAPPING.put("download.option-desc.--viewLicenseAgreement", "helpAgreement");
        LICENSE_KEY_MAPPING.put("download.option-desc.--viewLicenseInfo", "helpInformation");
        LICENSE_KEY_MAPPING.put("install.option-desc.--acceptLicense", "helpAcceptLicense");
        LICENSE_KEY_MAPPING.put("install.option-desc.--viewLicenseAgreement", "helpAgreement");
        LICENSE_KEY_MAPPING.put("install.option-desc.--viewLicenseInfo", "helpInformation");
    }
}

