/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.AlgorithmDecomposer;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractAlgorithmConstraints
implements AlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    protected AbstractAlgorithmConstraints(AlgorithmDecomposer decomposer) {
        this.decomposer = decomposer;
    }

    static Set<String> getAlgorithms(final String propertyName) {
        String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(propertyName);
            }
        });
        String[] algorithmsInProperty = null;
        if (property != null && !property.isEmpty()) {
            if (property.length() >= 2 && property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
                property = property.substring(1, property.length() - 1);
            }
            algorithmsInProperty = property.split(",");
            for (int i = 0; i < algorithmsInProperty.length; ++i) {
                algorithmsInProperty[i] = algorithmsInProperty[i].trim();
            }
        }
        if (algorithmsInProperty == null) {
            algorithmsInProperty = new String[]{};
        }
        if (propertyName.equals("jdk.tls.disabledAlgorithms")) {
            boolean foundDH = false;
            boolean foundSHA1 = false;
            boolean foundDSA = false;
            boolean runFIPS140_3 = false;
            String[] tempmode = (String[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String[] stringProperties = new String[]{System.getProperty("com.ibm.jsse2.usefipsprovider", "false"), System.getProperty("com.ibm.jsse2.usefipsProviderName"), System.getProperty("com.ibm.fips.mode")};
                    return stringProperties;
                }
            });
            if (tempmode[0].equalsIgnoreCase("true") && tempmode[1] != null && tempmode[1].equals("IBMJCEPlusFIPS") && tempmode[2] != null && tempmode[2].equals("140-3")) {
                runFIPS140_3 = true;
            }
            for (int i = 0; i < algorithmsInProperty.length; ++i) {
                if (algorithmsInProperty[i] != null && algorithmsInProperty[i].toLowerCase(Locale.ENGLISH).startsWith("dh")) {
                    foundDH = true;
                    if (!runFIPS140_3) {
                        break;
                    }
                } else if (runFIPS140_3) {
                    if (algorithmsInProperty[i] != null && algorithmsInProperty[i].toLowerCase(Locale.ENGLISH).startsWith("sha1")) {
                        foundSHA1 = true;
                    } else if (algorithmsInProperty[i] != null && algorithmsInProperty[i].toLowerCase(Locale.ENGLISH).startsWith("dsa")) {
                        foundDSA = true;
                    }
                }
                if (foundDH && foundSHA1 && foundDSA) break;
            }
            String[] addAlgorithms = new String[3];
            int addit = 0;
            if (!foundDH) {
                addAlgorithms[addit++] = "DH keySize < 768";
            }
            if (runFIPS140_3) {
                if (!foundSHA1) {
                    addAlgorithms[addit++] = "SHA1";
                }
                if (!foundDSA) {
                    addAlgorithms[addit++] = "DSA";
                }
            }
            if (addit > 0) {
                String[] largerAlgorithmsInProperty = new String[algorithmsInProperty.length + addit];
                System.arraycopy(algorithmsInProperty, 0, largerAlgorithmsInProperty, 0, algorithmsInProperty.length);
                int i = 0;
                if (!foundDH) {
                    largerAlgorithmsInProperty[largerAlgorithmsInProperty.length - i - 1] = addAlgorithms[i++];
                }
                if (runFIPS140_3) {
                    if (!foundSHA1) {
                        largerAlgorithmsInProperty[largerAlgorithmsInProperty.length - i - 1] = addAlgorithms[i++];
                    }
                    if (!foundDSA) {
                        largerAlgorithmsInProperty[largerAlgorithmsInProperty.length - i - 1] = addAlgorithms[i++];
                    }
                }
                TreeSet<String> algorithmsInPropertySet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                algorithmsInPropertySet.addAll(Arrays.asList(largerAlgorithmsInProperty));
                return algorithmsInPropertySet;
            }
        }
        TreeSet<String> algorithmsInPropertySet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        algorithmsInPropertySet.addAll(Arrays.asList(algorithmsInProperty));
        return algorithmsInPropertySet;
    }

    public static boolean checkAlgorithm(String[] algorithms, String algorithm, AlgorithmDecomposer decomposer) {
        TreeSet<String> algorithmsSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        algorithmsSet.addAll(Arrays.asList(algorithms));
        return AbstractAlgorithmConstraints.checkAlgorithm(algorithmsSet, algorithm, decomposer);
    }

    protected static boolean checkAlgorithm(Set<String> algorithms, String algorithm, AlgorithmDecomposer decomposer) {
        if (algorithm == null || algorithm.isEmpty()) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        if (algorithms.contains(algorithm)) {
            return false;
        }
        Set<String> elements = decomposer.decompose(algorithm);
        for (String element : elements) {
            if (!algorithms.contains(element)) continue;
            return false;
        }
        return true;
    }
}

