/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime;

import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.smime.SMIME;
import com.ibm.security.smime.SMIMEMessage;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public final class SMIMESender
implements Cloneable {
    private ContentInfo contentInfo;
    private CertificationRequest certRequest;
    private Certificate[] recipientCerts;
    private static int msgcounter = 0;
    private static final int SMTP_PORT = 25;
    private String mailhost;
    private String provider = null;
    private boolean oldTypes = true;
    private static String oldPKCS7Signature = "application/x-pkcs7-signature";
    private static String oldPKCS7MIME = "application/x-pkcs7-mime";
    private static String oldPKCS10 = "application/x-pkcs10";
    private static String newPKCS7Signature = "application/pkcs7-signature";
    private static String newPKCS7MIME = "application/pkcs7-mime";
    private static String newPKCS10 = "application/pkcs10";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.SMIMESender";

    public SMIMESender() {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender");
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(String provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", (Object)der);
        }
        this.contentInfo = new ContentInfo(der, this.provider);
        this.certRequest = null;
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(byte[] der, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender", der, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.contentInfo = new ContentInfo(der, this.provider);
        this.certRequest = null;
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(ContentInfo contentInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", contentInfo);
        }
        this.contentInfo = (ContentInfo)contentInfo.clone();
        this.certRequest = null;
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(ContentInfo contentInfo, String provider) {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender", contentInfo, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.contentInfo = (ContentInfo)contentInfo.clone();
        this.certRequest = null;
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(CertificationRequest certRequest) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", certRequest);
        }
        this.contentInfo = null;
        this.certRequest = (CertificationRequest)certRequest.clone();
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(CertificationRequest certRequest, String provider) {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender", certRequest, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.contentInfo = null;
        this.certRequest = (CertificationRequest)certRequest.clone();
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(SMIMEMessage message) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", message);
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "SMIMESender", "message must be specified.");
            }
            throw new IOException("message must be specified.");
        }
        byte[] bytes = message.getContentInfoBytes();
        if (bytes == null) {
            if (debug != null) {
                debug.text(16384L, className, "SMIMESender", "message does not contain a contentInfo object.");
            }
            throw new IOException("message does not contain a contentInfo object.");
        }
        bytes = message.getBytes();
        this.contentInfo = new ContentInfo(PKCSOID.DATA_OID, bytes, this.provider);
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(SMIMEMessage message, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender", message, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "SMIMESender", "message must be specified.");
            }
            throw new IOException("message must be specified.");
        }
        byte[] bytes = message.getContentInfoBytes();
        if (bytes == null) {
            if (debug != null) {
                debug.text(16384L, className, "SMIMESender", "message does not contain a contentInfo object.");
            }
            throw new IOException("message does not contain a contentInfo object.");
        }
        bytes = message.getBytes();
        this.contentInfo = new ContentInfo(PKCSOID.DATA_OID, bytes, this.provider);
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            SMIMESender smime = new SMIMESender(this.provider);
            smime.oldTypes = this.oldTypes;
            if (this.contentInfo != null) {
                smime.setContentInfo((ContentInfo)this.contentInfo.clone());
            }
            if (this.certRequest != null) {
                smime.setCertificationRequest((CertificationRequest)this.certRequest.clone());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", smime);
            }
            return smime;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    private void addRecipientCertificate(Certificate cert) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addRecipientCertificate", cert);
        }
        if (cert == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addRecipientCertificate_1");
            }
            return;
        }
        if (this.recipientCerts == null) {
            this.recipientCerts = new Certificate[1];
            this.recipientCerts[0] = cert;
        } else {
            int len = this.recipientCerts.length;
            Certificate[] newcerts = new Certificate[len + 1];
            for (int i = 0; i < len; ++i) {
                newcerts[i] = this.recipientCerts[i];
            }
            newcerts[len] = cert;
            this.recipientCerts = newcerts;
        }
        if (debug != null) {
            debug.exit(8192L, className, "addRecipientCertificate_2");
        }
    }

    public boolean hasRecipientCertificate() {
        if (debug != null) {
            debug.entry(16384L, className, "hasRecipientCertificate");
            debug.exit(16384L, (Object)className, "hasRecipientCertificate", this.recipientCerts != null && this.recipientCerts.length > 0);
        }
        return this.recipientCerts != null && this.recipientCerts.length > 0;
    }

    public void addRecipientCertificate(Certificate[] certs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipientCertificate", certs);
        }
        if (certs == null || certs.length == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipientCertificate_1");
            }
            return;
        }
        if (this.recipientCerts == null) {
            this.recipientCerts = new Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                this.recipientCerts[i] = certs[i];
            }
        } else {
            int i;
            int len = this.recipientCerts.length;
            Certificate[] newcerts = new Certificate[len + certs.length];
            for (i = 0; i < len; ++i) {
                newcerts[i] = this.recipientCerts[i];
            }
            for (i = 0; i < certs.length; ++i) {
                newcerts[len + i] = certs[i];
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipientCertificate_2");
        }
    }

    private void setRecipientCertificate(Certificate cert) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setRecipientCertificate", cert);
        }
        if (cert == null) {
            this.recipientCerts = null;
            if (debug != null) {
                debug.exit(8192L, className, "setRecipientCertificate_1");
            }
            return;
        }
        this.recipientCerts = null;
        this.addRecipientCertificate(cert);
        if (debug != null) {
            debug.exit(8192L, className, "setRecipientCertificate_2");
        }
    }

    public void setRecipientCertificate(Certificate[] certs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setRecipientCertificate", certs);
        }
        if (certs == null) {
            this.recipientCerts = null;
            if (debug != null) {
                debug.exit(16384L, className, "setRecipientCertificate_1");
            }
            return;
        }
        this.recipientCerts = null;
        this.addRecipientCertificate(certs);
        if (debug != null) {
            debug.exit(16384L, className, "setRecipientCertificate_2");
        }
    }

    private void setCertificateOnly(Certificate cert) throws IOException {
        ContentInfo ci;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setCertificateOnly", cert);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(8192L, className, "setCertificateOnly", "Certificate not specified.");
            }
            throw new IllegalArgumentException("Certificate not specified.");
        }
        Certificate[] certs = new Certificate[]{cert};
        SignedData sd = new SignedData(certs, null, this.provider);
        this.contentInfo = ci = new ContentInfo(sd, this.provider);
        this.certRequest = null;
        if (debug != null) {
            debug.exit(8192L, className, "setCertificateOnly");
        }
    }

    public void setCertificateOnly(Certificate[] certs) throws IOException, PKCSException {
        ContentInfo ci;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setCertificateOnly", certs);
        }
        if (certs == null || certs.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "Certificates not specified.");
            }
            throw new IllegalArgumentException("Certificates not specified.");
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "ContentInfo value already set.");
            }
            throw new PKCSException("ContentInfo value already set.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "CertificationRequest value already set.");
            }
            throw new PKCSException("CertificationRequest value already set.");
        }
        SignedData sd = new SignedData(certs, null, this.provider);
        this.contentInfo = ci = new ContentInfo(sd, this.provider);
        this.certRequest = null;
        if (debug != null) {
            debug.exit(16384L, className, "setCertificateOnly");
        }
    }

    public void setContentInfo(ContentInfo contentInfo) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setContentInfo", contentInfo);
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "setContentInfo", "ContentInfo value already set.");
            }
            throw new PKCSException("ContentInfo value already set.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "setContentInfo", "CertificationRequest value already set.");
            }
            throw new PKCSException("CertificationRequest value already set.");
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "setContentInfo", "ContentInfo not specified.");
            }
            throw new IllegalArgumentException("ContentInfo not specified.");
        }
        this.contentInfo = (ContentInfo)contentInfo.clone();
        this.certRequest = null;
        if (debug != null) {
            debug.exit(16384L, className, "setContentInfo");
        }
    }

    public ContentInfo getContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", (ContentInfo)this.contentInfo.clone());
        }
        return (ContentInfo)this.contentInfo.clone();
    }

    public void setCertificationRequest(CertificationRequest certRequest) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setCertificationRequest", certRequest);
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificationRequest", "ContentInfo value already set.");
            }
            throw new PKCSException("ContentInfo value already set.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificationRequest", "CertificationRequest value already set.");
            }
            throw new PKCSException("CertificationRequest value already set.");
        }
        if (certRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificationRequest", "certRequest not specified.");
            }
            throw new IllegalArgumentException("certRequest not specified.");
        }
        this.contentInfo = null;
        this.certRequest = (CertificationRequest)certRequest.clone();
        if (debug != null) {
            debug.exit(16384L, className, "setCertificationRequest");
        }
    }

    public CertificationRequest getCertificationRequest() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
            debug.exit(16384L, (Object)className, "getCertificationRequest", this.certRequest);
        }
        return this.certRequest;
    }

    public void setMailhost(String mailhost) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setMailhost", mailhost);
            debug.exit(16384L, className, "setMailhost");
        }
        this.mailhost = mailhost;
    }

    public String getMailhost() {
        if (debug != null) {
            debug.entry(16384L, className, "getMailhost");
            debug.exit(16384L, className, "getMailhost");
        }
        return this.mailhost;
    }

    public void setMessageWithHeader(String message) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setMessageWithHeader", message);
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "setMessageWithHeader", "ContentInfo value already set.");
            }
            throw new PKCSException("ContentInfo value already set.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "setMessageWithHeader", "CertificationRequest value already set.");
            }
            throw new PKCSException("CertificationRequest value already set.");
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "setMessageWithHeader", "Message not specified.");
            }
            throw new IllegalArgumentException("Message not specified.");
        }
        String msgheader = "Content-Type: text/plain; charset=\"us-ascii\"\r\n\r\n";
        String msg = msgheader + message;
        Data data = new Data(this.provider);
        try {
            data.setData(msg.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "setMessageWithHeader", e);
            }
            data.setData(msg.getBytes());
        }
        this.contentInfo = new ContentInfo(data, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "setMessageWithHeader");
        }
    }

    public void setSMIMEContentType(boolean old) {
        this.oldTypes = old;
    }

    public boolean getSMIMEContentType() {
        return this.oldTypes;
    }

    public byte[] encrypt(int encryptionStrength) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encrypt", new Integer(encryptionStrength));
        }
        String encryptionAlgorithm = SMIME.getEncryptionAlgorithm(encryptionStrength);
        int keySize = SMIME.getEncryptionKeySize(encryptionStrength);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encrypt", this.encrypt(encryptionAlgorithm, keySize));
        }
        return this.encrypt(encryptionAlgorithm, keySize);
    }

    public byte[] encrypt(String encryptionAlgorithm, int keySize) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "encrypt", encryptionAlgorithm, new Integer(keySize));
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "ContentInfo must be specified.");
            }
            throw new PKCSException("ContentInfo must be specified.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "CertificationRequest must not be specified.");
            }
            throw new PKCSException("CertificationRequest must not be specified.");
        }
        if (encryptionAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "encryptionAlgorithm not specified.");
            }
            throw new IllegalArgumentException("encryptionAlgorithm not specified.");
        }
        if (!this.hasRecipientCertificate()) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "One or more recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("One or more recipient certificates must be specified.");
        }
        if (!this.contentInfo.isData()) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
            }
            throw new PKCSException("ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
        }
        this.contentInfo = this.contentInfo.encrypt(this.recipientCerts, encryptionAlgorithm, keySize);
        String filename = "smime.p7m";
        String header = this.createMessageHeader(filename);
        byte[] byteheader = null;
        try {
            byteheader = header.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            byteheader = header.getBytes();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(byteheader);
        baos.write(this.getBase64Content());
        byte[] retval = baos.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encrypt", retval);
        }
        return retval;
    }

    public byte[] sign(Certificate signerCert, String digestSignatureAlgorithm, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{signerCert, digestSignatureAlgorithm, privateKey};
            debug.entry(16384L, (Object)className, "sign", parms);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "digestSignatureAlgorithm not specified.");
            }
            throw new IllegalArgumentException("digestSignatureAlgorithm not specified.");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "ContentInfo must be specified.");
            }
            throw new PKCSException("ContentInfo must be specified.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "CertificationRequest must not be specified.");
            }
            throw new PKCSException("CertificationRequest must not be specified.");
        }
        if (!this.contentInfo.isData()) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
            }
            throw new PKCSException("ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
        }
        boolean signatureOnly = false;
        this.contentInfo = this.contentInfo.sign(signerCert, digestSignatureAlgorithm, privateKey, signatureOnly);
        String filename = "smime.p7m";
        String header = this.createMessageHeader(filename);
        byte[] byteheader = null;
        try {
            byteheader = header.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", e);
            }
            byteheader = header.getBytes();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(byteheader);
        baos.write(this.getBase64Content());
        byte[] retval = baos.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", retval);
        }
        return retval;
    }

    public byte[] signSignatureOnly(Certificate signerCert, String digestSignatureAlgorithm, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        return this.signSignatureOnly(signerCert, digestSignatureAlgorithm, privateKey, true);
    }

    public byte[] signSignatureOnly(Certificate signerCert, String digestSignatureAlgorithm, PrivateKey privateKey, boolean isBannerOn) throws PKCSException, IOException, NoSuchAlgorithmException {
        ContentInfo cinew;
        if (debug != null) {
            Object[] parms = new Object[]{signerCert, digestSignatureAlgorithm, privateKey};
            debug.entry(16384L, (Object)className, "signSignatureOnly", parms);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "digestSignatureAlgorithm must be specified.");
            }
            throw new IllegalArgumentException("digestSignatureAlgorithm must be specified.");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "ContentInfo must be specified.");
            }
            throw new PKCSException("ContentInfo must be specified.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "CertificationRequest must not be specified.");
            }
            throw new PKCSException("CertificationRequest must not be specified.");
        }
        if (!this.contentInfo.isData()) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
            }
            throw new PKCSException("ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
        }
        Data data = (Data)this.contentInfo.getContent();
        boolean signatureOnly = false;
        SignedData sd = new SignedData(signerCert, this.contentInfo, digestSignatureAlgorithm, privateKey, signatureOnly, this.provider);
        sd.removeContent();
        this.contentInfo = cinew = new ContentInfo(sd, this.provider);
        String filename = "smime.p7s";
        String boundary = this.createBoundary();
        String boundaryHeader = "\r\n--" + boundary + "\r\n";
        byte[] byteboundaryHeader = null;
        try {
            byteboundaryHeader = boundaryHeader.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "signSignatureOnly", e);
            }
            byteboundaryHeader = boundaryHeader.getBytes();
        }
        String digestAlgorithm = PKCS7.getDigestAlgorithm(digestSignatureAlgorithm);
        String header = this.createMultipartMessageHeader(digestAlgorithm, boundary);
        if (isBannerOn) {
            header = header + "This is a cryptographically signed message in MIME format.\r\n";
        }
        byte[] byteheader = null;
        try {
            byteheader = header.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "signSignatureOnly", e);
            }
            byteheader = header.getBytes();
        }
        String fileHeader = this.createMultipartMessageFileHeader(filename);
        byte[] bytefileHeader = null;
        try {
            bytefileHeader = fileHeader.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "signSignatureOnly", e);
            }
            bytefileHeader = fileHeader.getBytes();
        }
        String boundaryFooter = "\r\n--" + boundary + "--\r\n";
        byte[] byteboundaryFooter = null;
        try {
            byteboundaryFooter = boundaryFooter.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "signSignatureOnly", e);
            }
            byteboundaryFooter = boundaryFooter.getBytes();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(byteheader);
        baos.write(byteboundaryHeader);
        baos.write(data.getData());
        baos.write(byteboundaryHeader);
        baos.write(bytefileHeader);
        baos.write(this.getBase64Content());
        baos.write(byteboundaryFooter);
        byte[] retval = baos.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "signSignatureOnly", retval);
        }
        return retval;
    }

    private String createBoundary() {
        if (debug != null) {
            debug.entry(8192L, className, "createBoundary");
        }
        Calendar cal = Calendar.getInstance();
        long time = cal.get(13);
        long time2 = cal.get(14);
        String boundary = "----boundary" + time + time2 + msgcounter++;
        if (debug != null) {
            debug.exit(8192L, (Object)className, "createBoundary", boundary);
        }
        return boundary;
    }

    public byte[] getBase64Content() throws IOException {
        DerOutputStream derout = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "getBase64Content");
        }
        if (this.contentInfo != null) {
            this.contentInfo.encode(derout);
        } else {
            this.certRequest.encode(derout);
        }
        byte[] encoding = derout.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getBase64Content", this.getBase64(encoding));
        }
        return this.getBase64(encoding);
    }

    private byte[] getBase64(byte[] bytesToEncode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getBase64", (Object)bytesToEncode);
        }
        BASE64Encoder encoder = new BASE64Encoder();
        encoder.encode(bytesToEncode, (OutputStream)baos);
        byte[] retval = baos.toByteArray();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getBase64", retval);
        }
        return retval;
    }

    private String createMultipartMessageHeader(String digestAlgorithm, String boundary) {
        String micalg = digestAlgorithm;
        if (debug != null) {
            debug.entry(8192L, className, "createMultipartMessageHeader", digestAlgorithm, boundary);
        }
        if (micalg.equalsIgnoreCase("md5")) {
            micalg = "md5";
        } else if (micalg.equalsIgnoreCase("sha") || micalg.equalsIgnoreCase("sha1") || micalg.equalsIgnoreCase("sha-1")) {
            micalg = "sha1";
        }
        String msgHeader = "Content-Type: multipart/signed;";
        msgHeader = this.oldTypes ? msgHeader + " protocol=\"" + oldPKCS7Signature + "\";" : msgHeader + " protocol=\"" + newPKCS7Signature + "\";";
        msgHeader = msgHeader + " micalg=" + micalg + "; boundary=\"" + boundary + "\"\r\n";
        msgHeader = msgHeader + "\r\n";
        if (debug != null) {
            debug.exit(8192L, (Object)className, "createMultipartMessageHeader", msgHeader);
        }
        return msgHeader;
    }

    private String createMultipartMessageFileHeader(String filename) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "createMultipartMessageFileHeader", filename);
        }
        String msgHeader = "Content-Type: ";
        msgHeader = this.oldTypes ? msgHeader + oldPKCS7Signature + ";" : msgHeader + newPKCS7Signature + ";";
        msgHeader = msgHeader + " name=\"" + filename + "\"\r\n";
        msgHeader = msgHeader + "Content-Transfer-Encoding: base64\r\n";
        msgHeader = msgHeader + "Content-Disposition: attachment; filename=\"" + filename + "\"\r\n";
        if (filename.equals("smime.p7s")) {
            msgHeader = msgHeader + "Content-Description: S/MIME Cryptographic Signature\r\n";
        }
        msgHeader = msgHeader + "\r\n";
        if (debug != null) {
            debug.exit(8192L, (Object)className, "createMultipartMessageFileHeader", msgHeader);
        }
        return msgHeader;
    }

    private String createMessageHeader(String filename) {
        String msgHeader;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "createMessageHeader", filename);
        }
        if (this.certRequest != null) {
            msgHeader = "Content-Type: ";
            msgHeader = this.oldTypes ? msgHeader + oldPKCS10 + "; name=" + filename + "\r\n" : msgHeader + newPKCS10 + "; name=" + filename + "\r\n";
            msgHeader = msgHeader + "Content-Transfer-Encoding: base64\r\n";
            msgHeader = msgHeader + "Content-Disposition: attachment; filename=" + filename + "\r\n";
        } else {
            String smimetype = this.getSMIMEType();
            msgHeader = "Content-Type: ";
            msgHeader = this.oldTypes ? msgHeader + oldPKCS7MIME + ";" : msgHeader + newPKCS7MIME + ";";
            msgHeader = msgHeader + " smime-type=";
            msgHeader = msgHeader + smimetype;
            msgHeader = msgHeader + ";";
            msgHeader = msgHeader + " name=\"";
            msgHeader = msgHeader + filename;
            msgHeader = msgHeader + "\"\r\n";
            msgHeader = msgHeader + "Content-Transfer-Encoding: base64\r\n";
            msgHeader = msgHeader + "Content-Disposition: attachment; filename=\"" + filename + "\"\r\n";
            if (this.contentInfo.isEnvelopedData()) {
                msgHeader = msgHeader + "Content-Description: S/MIME Encrypted Message\r\n";
            }
        }
        msgHeader = msgHeader + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "createMessageHeader", msgHeader);
        }
        return msgHeader;
    }

    public String getSMIMEType() {
        if (debug != null) {
            debug.entry(16384L, className, "getSMIMEType");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSMIMEType_1", null);
            }
            return null;
        }
        if (this.contentInfo.isSignedData()) {
            SignedData sd = (SignedData)this.contentInfo.getContent();
            if (sd.hasCertificatesOnly()) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getSMIMEType_2", "certs-only");
                }
                return "certs-only";
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSMIMEType_3", "signed-data");
            }
            return "signed-data";
        }
        if (this.contentInfo.isEnvelopedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSMIMEType_4", "enveloped-data");
            }
            return "enveloped-data";
        }
        if (debug != null) {
            debug.text(16384L, className, "getSMIMEType", "Unknown/Unsupported smime-type for ContentInfo of type " + this.contentInfo.getContentTypeString());
        }
        throw new IllegalArgumentException("Unknown/Unsupported smime-type for ContentInfo of type " + this.contentInfo.getContentTypeString());
    }

    public String getFileName() {
        if (debug != null) {
            debug.entry(16384L, className, "getFileName");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFileName_1", "smime.p10");
            }
            return "smime.p10";
        }
        if (this.contentInfo.isSignedData()) {
            SignedData sd = (SignedData)this.contentInfo.getContent();
            if (!sd.hasSignerInfos()) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getFileName_2", "smime.p7c");
                }
                return "smime.p7c";
            }
            if (!sd.hasContent()) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getFileName_3", "smime.p7s");
                }
                return "smime.p7s";
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFileName_4", "smime.p7m");
            }
            return "smime.p7m";
        }
        if (this.contentInfo.isEnvelopedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFileName_5", "smime.p7m");
            }
            return "smime.p7m";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getFileName_6", "smime.dat");
        }
        return "smime.dat";
    }

    private Vector getEmailAddress(String recipientAddress, byte[] bytes) throws PKCSException, IOException {
        ContentInfo ci = null;
        if (debug != null) {
            debug.entry(8192L, className, "getEmailAddress", recipientAddress, bytes);
        }
        if (bytes != null) {
            SMIMEMessage message = new SMIMEMessage(bytes, this.provider);
            ci = message.getContentInfo();
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getEmailAddress", this.getEmailAddress(recipientAddress, ci));
        }
        return this.getEmailAddress(recipientAddress, ci);
    }

    private Vector getEmailAddress(String recipientAddress, ContentInfo ci) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getEmailAddress", recipientAddress, ci);
        }
        Vector<String> v = new Vector<String>();
        boolean benvelopeddata = ci != null && ci.isEnvelopedData();
        boolean bfound = false;
        int len = 0;
        if (this.recipientCerts != null) {
            len = this.recipientCerts.length;
        }
        for (int i = 0; i < len; ++i) {
            Certificate cert = this.recipientCerts[i];
            String email = this.getEmailAddress(cert);
            if (email == null) continue;
            v.add(email);
            if (recipientAddress == null || !recipientAddress.equalsIgnoreCase(email)) continue;
            bfound = true;
        }
        if (recipientAddress != null && !bfound && !benvelopeddata) {
            v.add(recipientAddress);
            bfound = true;
        }
        if (recipientAddress == null || bfound) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getEmailAddress", v);
            }
            return v;
        }
        if (debug != null) {
            debug.text(8192L, className, "getEmailAddress", "Could not find " + recipientAddress + " in the e-mail addresses for the certificates stored with this EnvelopedData object.");
        }
        throw new PKCSException("Could not find " + recipientAddress + " in the e-mail addresses for the certificates stored with this EnvelopedData object.");
    }

    private String getEmailAddress(Certificate cert) throws PKCSException, IOException {
        GeneralName gn;
        String emailaddress;
        block22: {
            GeneralNames gnames;
            block21: {
                byte[] subaltname;
                block20: {
                    emailaddress = null;
                    if (debug != null) {
                        debug.entry(8192L, (Object)className, "getEmailAddress", cert);
                    }
                    if (cert == null) {
                        if (debug != null) {
                            debug.exit(8192L, (Object)className, "getEmailAddress_1", emailaddress);
                        }
                        return emailaddress;
                    }
                    if (!(cert instanceof X509Certificate)) {
                        if (debug != null) {
                            debug.text(8192L, className, "getEmailAddress", "cert must be of type X509Certificate");
                        }
                        throw new PKCSException("cert must be of type X509Certificate");
                    }
                    X509Certificate x509cert = (X509Certificate)cert;
                    X500Name x500name = new X500Name(x509cert.getSubjectDN().getName());
                    emailaddress = x500name.getEmail();
                    if (emailaddress != null) {
                        if (debug != null) {
                            debug.exit(8192L, (Object)className, "getEmailAddress_2", emailaddress);
                        }
                        return emailaddress;
                    }
                    subaltname = null;
                    try {
                        X509CertImpl tmpCert = (X509CertImpl)cert;
                        subaltname = tmpCert.getExtensionValue("2.5.29.17");
                    }
                    catch (Exception e) {
                        if (debug == null) break block20;
                        debug.exception(8192L, className, "getEmailAddress", e);
                    }
                }
                if (subaltname == null) {
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "getEmailAddress_3", emailaddress);
                    }
                    return emailaddress;
                }
                DerValue derval = new DerValue(subaltname);
                gnames = null;
                try {
                    gnames = new GeneralNames(derval);
                }
                catch (GeneralNamesException e) {
                    if (debug == null) break block21;
                    debug.exception(8192L, className, "getEmailAddress", e);
                }
            }
            if (gnames == null) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "getEmailAddress_4", emailaddress);
                }
                return emailaddress;
            }
            gn = null;
            try {
                gn = gnames.getGeneralName(1);
            }
            catch (GeneralNamesException e) {
                if (debug == null) break block22;
                debug.exception(8192L, className, "getEmailAddress", e);
            }
        }
        if (gn == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getEmailAddress_5", emailaddress);
            }
            return emailaddress;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getEmailAddress_6", gn.toString());
        }
        return gn.toString();
    }

    public void mail(String senderAddress, String recipientAddress, String subject) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{senderAddress, recipientAddress, subject};
            debug.entry(16384L, (Object)className, "mail", parms);
        }
        if (this.mailhost == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "mailhost must be specified.");
            }
            throw new PKCSException("mailhost must be specified.");
        }
        if (senderAddress == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "senderAddress must be specified.");
            }
            throw new IllegalArgumentException("senderAddress must be specified.");
        }
        if (this.contentInfo == null && this.certRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "ContentInfo or CertificationRequest must be specified.");
            }
            throw new PKCSException("ContentInfo or CertificationRequest must be specified.");
        }
        if (!this.hasRecipientCertificate() && recipientAddress == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "recipientAddress or recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("recipientAddress or recipient certificates must be specified.");
        }
        byte[] base64encoding = this.getBase64Content();
        String smimefilename = this.getFileName();
        Vector v = this.getEmailAddress(recipientAddress, this.contentInfo);
        if (v == null || v.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "No recipientAddresses found to mail.");
            }
            throw new PKCSException("No recipientAddresses found to mail.");
        }
        Enumeration names = v.elements();
        while (names.hasMoreElements()) {
            String recipientname = (String)names.nextElement();
            Socket mailSocket = new Socket(this.mailhost, 25);
            PrintWriter out = new PrintWriter(mailSocket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(mailSocket.getInputStream()));
            this.checkSMTPReturn(in);
            out.println("HELO " + this.mailhost);
            this.checkSMTPReturn(in);
            out.println("MAIL FROM:<" + senderAddress + ">");
            this.checkSMTPReturn(in);
            out.println("RCPT TO:<" + recipientname + ">");
            this.checkSMTPReturn(in);
            out.println("DATA");
            this.checkSMTPReturn(in);
            String header = this.getMailHeader(senderAddress, recipientname, subject);
            out.print(header);
            out.print(this.createMessageHeader(smimefilename));
            try {
                out.write(new String(base64encoding, "8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "mail", e);
                }
                out.write(new String(base64encoding));
            }
            out.println();
            out.println(".");
            this.checkSMTPReturn(in);
            out.println("QUIT");
            this.checkSMTPReturn(in);
            out.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "mail");
        }
    }

    public void mail(byte[] message, String senderAddress, String recipientAddress, String subject) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{message, senderAddress, recipientAddress, subject};
            debug.entry(16384L, (Object)className, "mail", parms);
        }
        if (this.mailhost == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "mailhost must be specified.");
            }
            throw new PKCSException("mailhost must be specified.");
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "message must be specified.");
            }
            throw new IllegalArgumentException("message must be specified.");
        }
        if (senderAddress == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "senderAddress must be specified.");
            }
            throw new IllegalArgumentException("senderAddress must be specified.");
        }
        if (!this.hasRecipientCertificate() && recipientAddress == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "recipientAddress or recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("recipientAddress or recipient certificates must be specified.");
        }
        Vector v = this.getEmailAddress(recipientAddress, message);
        if (v == null || v.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "No recipientAddresses found to mail.");
            }
            throw new PKCSException("No recipientAddresses found to mail.");
        }
        Enumeration names = v.elements();
        while (names.hasMoreElements()) {
            String recipientname = (String)names.nextElement();
            Socket mailSocket = new Socket(this.mailhost, 25);
            PrintWriter out = new PrintWriter(mailSocket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(mailSocket.getInputStream()));
            this.checkSMTPReturn(in);
            out.println("HELO " + this.mailhost);
            this.checkSMTPReturn(in);
            out.println("MAIL FROM:<" + senderAddress + ">");
            this.checkSMTPReturn(in);
            out.println("RCPT TO:<" + recipientname + ">");
            this.checkSMTPReturn(in);
            out.println("DATA");
            this.checkSMTPReturn(in);
            String header = this.getMailHeader(senderAddress, recipientname, subject);
            out.print(header);
            try {
                out.write(new String(message, "8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "mail", e);
                }
                out.write(new String(message));
            }
            out.println();
            out.println(".");
            this.checkSMTPReturn(in);
            out.println("QUIT");
            this.checkSMTPReturn(in);
            out.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "mail");
        }
    }

    private void checkSMTPReturn(BufferedReader in) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "checkSMTPReturn", in);
        }
        String smtpreturn = in.readLine();
        if (debug != null) {
            debug.exit(8192L, className, "checkSMTPReturn");
        }
    }

    private String getMailHeader(String senderAddress, String recipientAddress, String subject) {
        if (debug != null) {
            Object[] parms = new Object[]{senderAddress, recipientAddress, subject};
            debug.entry(8192L, (Object)className, "getMailHeader", parms);
        }
        Date date = new Date();
        SimpleDateFormat datefmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String dateString = datefmt.format(date);
        String header = new String();
        header = header + "Date: " + dateString + "\r\n";
        header = header + "From: <" + senderAddress + ">\r\n";
        header = header + "X-Mailer: IBM Security Software Development Kit SMIMESender\r\n";
        header = header + "X-Accept-Language: en\r\n";
        header = header + "MIME-Version: 1.0\r\n";
        header = header + "To: <" + recipientAddress + ">\r\n";
        if (subject != null) {
            header = header + "Subject: " + subject + "\r\n";
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getMailHeader", header);
        }
        return header;
    }

    public void writeMailToFile(String filename, String senderAddress, String recipientAddress, String subject) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{filename, senderAddress, recipientAddress, subject};
            debug.entry(16384L, (Object)className, "writeMailToFile", parms);
        }
        if (senderAddress == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "senderAddress must be specified.");
            }
            throw new IllegalArgumentException("senderAddress must be specified.");
        }
        if (!this.hasRecipientCertificate() && recipientAddress == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "recipientAddress or recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("recipientAddress or recipient certificates must be specified.");
        }
        if (filename == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "filename must be specified.");
            }
            throw new IllegalArgumentException("filename must be specified.");
        }
        if (this.contentInfo == null && this.certRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "ContentInfo or CertificationRequest must be specified.");
            }
            throw new PKCSException("ContentInfo or CertificationRequest must be specified.");
        }
        byte[] base64encoding = this.getBase64Content();
        String smimefilename = this.getFileName();
        Vector v = this.getEmailAddress(recipientAddress, this.contentInfo);
        if (v == null || v.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "No recipientAddresses found to mail.");
            }
            throw new PKCSException("No recipientAddresses found to mail.");
        }
        Enumeration names = v.elements();
        int count = 0;
        while (names.hasMoreElements()) {
            String recipientname = (String)names.nextElement();
            String header = this.getMailHeader(senderAddress, recipientname, subject);
            header = header + this.createMessageHeader(smimefilename);
            byte[] byteheader = null;
            try {
                byteheader = header.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "writeMailToFile", e);
                }
                byteheader = header.getBytes();
            }
            FileOutputStream fos = null;
            fos = v.size() == 1 ? new FileOutputStream(filename) : new FileOutputStream(filename + "." + count++);
            fos.write(byteheader);
            fos.write(base64encoding);
            fos.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "writeMailToFile");
        }
    }

    public void writeMailToFile(byte[] message, String filename, String senderAddress, String recipientAddress, String subject) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{message, filename, senderAddress, recipientAddress, subject};
            debug.entry(16384L, (Object)className, "writeMailToFile", parms);
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "message must be specified.");
            }
            throw new IllegalArgumentException("message must be specified.");
        }
        if (senderAddress == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "senderAddress must be specified.");
            }
            throw new IllegalArgumentException("senderAddress must be specified.");
        }
        if (!this.hasRecipientCertificate() && recipientAddress == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "recipientAddress or recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("recipientAddress or recipient certificates must be specified.");
        }
        if (filename == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "filename must be specified.");
            }
            throw new IllegalArgumentException("filename must be specified.");
        }
        Vector v = this.getEmailAddress(recipientAddress, message);
        if (v == null || v.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "No recipientAddresses found to mail.");
            }
            throw new PKCSException("No recipientAddresses found to mail.");
        }
        Enumeration names = v.elements();
        int count = 0;
        while (names.hasMoreElements()) {
            String recipientname = (String)names.nextElement();
            String header = this.getMailHeader(senderAddress, recipientAddress, subject);
            byte[] byteheader = null;
            try {
                byteheader = header.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "writeMailToFile", e);
                }
                byteheader = header.getBytes();
            }
            FileOutputStream fos = null;
            fos = v.size() == 1 ? new FileOutputStream(filename) : new FileOutputStream(filename + "." + count++);
            fos.write(byteheader);
            fos.write(message);
            fos.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "writeMailToFile");
        }
    }

    public String toString() {
        String out = "SMIMESender ";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.certRequest != null) {
            out = out + "PKCS #10:\r\n";
            out = out + this.certRequest;
        } else if (this.contentInfo != null) {
            out = out + "PKCS #7:\r\n";
            out = out + this.contentInfo;
        } else {
            out = out + ": ContentInfo or CertificationRequest object not set.";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

