/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs5;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.SmudgedBytes;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PKCS5 {
    public static final String MESSAGE_DIGEST_MD2 = "MD2";
    public static final String MESSAGE_DIGEST_MD5 = "MD5";
    public static final String MESSAGE_DIGEST_SHA = "SHA";
    public static final String MESSAGE_DIGEST_SHA1 = "SHA1";
    public static final String CIPHER_MODE_CBC = "CBC";
    public static final String PADDING_ALGORITHM_PKCS5 = "PKCS5Padding";
    public static final String CIPHER_ALGORITHM_DES = "DES";
    public static final String CIPHER_ALGORITHM_TRIPLE_DES = "TripleDES";
    public static final String CIPHER_ALGORITHM_DESEDE = "DESede";
    public static final String CIPHER_ALGORITHM_3DES = "3DES";
    public static final String CIPHER_ALGORITHM_RC2 = "RC2";
    public static final int PKCS5_VERSION1 = 1;
    public static final int PKCS5_VERSION2 = 2;
    public static final String KEY_ALGORITHM_PBKDF1 = "PBKDF1";
    public static final String KEY_ALGORITHM_PBKDF2 = "PBKDF2";
    public static final String ENCRYPTION_ALGORITHM_PBES1 = "PBES1";
    public static final String ENCRYPTION_ALGORITHM_PBES2 = "PBES2";
    private byte[] salt = null;
    private int iterationCount = 1000;
    private SmudgedBytes password;
    private int keyLength = 16;
    private String digestAlgorithm = "MD5";
    private String cipherAlgorithm = "DES";
    private String cipherMode = "CBC";
    private String paddingAlgorithm = "PKCS5Padding";
    private int version = 1;
    private String keyAlgorithm = "PBKDF1";
    private String encryptionAlgorithm = "PBES1";
    private String keyEncryptionFunction = "MD5";
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs5.PKCS5";
    private static final String[] supportedMessageDigests = new String[]{"MD2", "MD5", "SHA", "SHA1"};
    private static final String[] supportedKeyEncryptionFunctions = new String[]{"MD2", "MD5", "SHA", "SHA1"};
    private static final int[] maxKeyLengths = new int[]{16, 16, 20, 20};
    private static final String[] supportedCipherModes = new String[]{"CBC"};
    private static final String[] supportedPaddingAlgorithms = new String[]{"PKCS5Padding"};
    private static final String[] supportedCipherAlgorithms = new String[]{"DES", "TripleDES", "DESede", "3DES", "RC2"};
    private static final String[] supportedKeyAlgorithms = new String[]{"PBKDF1", "PBKDF2"};
    private static final String[] supportedEncryptionAlgorithms = new String[]{"PBES1", "PBES2"};

    public PKCS5(byte[] password, byte[] salt, int iterationCount) {
        if (debug != null) {
            Object[] parms = new Object[]{password, salt, new Integer(iterationCount)};
            debug.entry(16384L, (Object)className, "PKCS5", parms);
        }
        this.setPassword(password);
        this.setSalt(salt);
        this.setIterationCount(iterationCount);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS5");
        }
    }

    public PKCS5(byte[] password, byte[] salt, int iterationCount, String provname) {
        this(password, salt, iterationCount);
        if (debug != null) {
            Object[] parms = new Object[]{password, salt, new Integer(iterationCount), provname};
            debug.entry(16384L, (Object)className, "PKCS5", parms);
        }
        if (provname != null) {
            this.provider = new String(provname);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS5");
        }
    }

    public PKCS5(byte[] password, byte[] salt, int iterations, String digest, String cipher, String keyFunc, int version) {
        if (debug != null) {
            Object[] parms = new Object[]{password, salt, new Integer(iterations), digest, cipher, keyFunc, new Integer(version)};
            debug.entry(16384L, (Object)className, "PKCS5", parms);
        }
        this.setPassword(password);
        this.setSalt(salt);
        this.setIterationCount(iterations);
        if (!PKCS5.inSet(digest, supportedMessageDigests)) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS5", "Digest Algorithm " + digest + " not supported. Must be one of MD2, MD5, or SHA1.");
            }
            throw new IllegalArgumentException("Digest Algorithm " + digest + " not supported. Must be one of MD2, MD5 or SHA1.");
        }
        this.digestAlgorithm = digest.toUpperCase(Locale.US);
        this.setCipherAlgorithm(cipher);
        if (!PKCS5.inSet(keyFunc, supportedKeyEncryptionFunctions)) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS5", "Key Encryption Function " + keyFunc + " not supported. Must be one of MD2, MD5, or SHA1.");
            }
            throw new IllegalArgumentException("Key Encryption Function " + keyFunc + " not supported.  Must be one of MD2, MD5 or SHA1.");
        }
        this.keyEncryptionFunction = keyFunc.toUpperCase(Locale.US);
        if (this.digestAlgorithm.equals(MESSAGE_DIGEST_MD2) || this.digestAlgorithm.equals(MESSAGE_DIGEST_MD5)) {
            this.setKeyLength(16);
        } else if (this.digestAlgorithm.equals(MESSAGE_DIGEST_SHA) || this.digestAlgorithm.equals(MESSAGE_DIGEST_SHA1)) {
            this.setKeyLength(20);
        }
        if (version == 1) {
            this.setKeyAlgorithm(KEY_ALGORITHM_PBKDF1);
            this.setEncryptionAlgorithm(ENCRYPTION_ALGORITHM_PBES1);
        } else if (version == 2) {
            this.setKeyAlgorithm(KEY_ALGORITHM_PBKDF2);
            this.setEncryptionAlgorithm(ENCRYPTION_ALGORITHM_PBES2);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "PKCS5", "PKCS #5 version " + version + " not supported.");
            }
            throw new IllegalArgumentException("PKCS #5 version " + version + " not supported.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS5");
        }
    }

    public PKCS5(byte[] password, byte[] salt, int iterations, String digest, String cipher, String keyFunc, int version, String provname) {
        this(password, salt, iterations, digest, cipher, keyFunc, version);
        if (debug != null) {
            Object[] parms = new Object[]{password, salt, new Integer(iterations), digest, cipher, keyFunc, new Integer(version), provname};
            debug.entry(16384L, (Object)className, "PKCS5", parms);
        }
        if (provname != null) {
            this.provider = new String(provname);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS5");
        }
    }

    public static boolean isSupportedMessageDigest(String digestAlgorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSupportedMessageDigest", digestAlgorithm);
        }
        if (!PKCS5.inSet(digestAlgorithm, supportedMessageDigests)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isSupportedMessageDigest", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isSupportedMessageDigest", new Boolean(true));
        }
        return true;
    }

    public byte[] getSalt() {
        if (debug != null) {
            debug.entry(16384L, className, "getSalt");
            debug.exit(16384L, (Object)className, "getSalt", this.salt.clone());
        }
        return (byte[])this.salt.clone();
    }

    public int getIterationCount() {
        if (debug != null) {
            debug.entry(16384L, className, "getIterationCount");
            debug.exit(16384L, (Object)className, "getIterationCount", this.iterationCount);
        }
        return this.iterationCount;
    }

    public int getKeyLength() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyLength");
            debug.exit(16384L, (Object)className, "getKeyLength", this.keyLength);
        }
        return this.keyLength;
    }

    public String getDigestAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", this.digestAlgorithm);
        }
        return this.digestAlgorithm;
    }

    public String getCipherAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getCipherAlgorithm");
            debug.exit(16384L, (Object)className, "getCipherAlgorithm", this.cipherAlgorithm);
        }
        return this.cipherAlgorithm;
    }

    public String getPaddingAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getPaddingAlgorithm");
            debug.exit(16384L, (Object)className, "getPaddingAlgorithm", this.paddingAlgorithm);
        }
        return this.paddingAlgorithm;
    }

    public String getCipherMode() {
        if (debug != null) {
            debug.entry(16384L, className, "getCipherMode");
            debug.exit(16384L, (Object)className, "getCipherMode", this.cipherMode);
        }
        return this.cipherMode;
    }

    public String getCipherString() {
        if (debug != null) {
            debug.entry(16384L, className, "getCipherString");
        }
        if (this.cipherAlgorithm.length() > 6 && this.cipherAlgorithm.substring(0, 7).equalsIgnoreCase("PBEWith")) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCipherString", this.cipherAlgorithm);
            }
            return this.cipherAlgorithm;
        }
        String cipher = this.cipherAlgorithm;
        String keyfunc = this.keyEncryptionFunction;
        if (cipher.equalsIgnoreCase(CIPHER_ALGORITHM_DESEDE) || cipher.equalsIgnoreCase(CIPHER_ALGORITHM_3DES)) {
            cipher = CIPHER_ALGORITHM_TRIPLE_DES;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCipherString", "PBEWith" + keyfunc + "And" + cipher);
        }
        return "PBEWith" + keyfunc + "And" + cipher;
    }

    public String getHMACString() {
        if (debug != null) {
            debug.entry(16384L, className, "getHMACString");
            debug.exit(16384L, (Object)className, "getHMACString", "Hmac" + this.digestAlgorithm);
        }
        return "Hmac" + this.digestAlgorithm;
    }

    public String getKeyAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyAlgorithm");
            debug.exit(16384L, (Object)className, "getKeyAlgorithm", this.keyAlgorithm);
        }
        return this.keyAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptionAlgorithm");
            debug.exit(16384L, (Object)className, "getEncryptionAlgorithm", this.digestAlgorithm);
        }
        return this.encryptionAlgorithm;
    }

    public String getKeyEncryptionFunction() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyEncryptionFunction");
            debug.exit(16384L, (Object)className, "getKeyEncryptionFunction", this.keyEncryptionFunction);
        }
        return this.keyEncryptionFunction;
    }

    public int getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public String toString() {
        String pkcs5 = "PKCS #5:";
        pkcs5 = pkcs5 + "\r\n\tdigestAlgorithm = " + this.digestAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tcipherAlgorithm = " + this.cipherAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tcipherMode = " + this.cipherMode;
        pkcs5 = pkcs5 + "\r\n\tpaddingAlgorithm = " + this.paddingAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tkeyAlgorithm = " + this.keyAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tencryptionAlgorithm = " + this.encryptionAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tkeyEncryptionFunction = " + this.keyEncryptionFunction;
        return pkcs5;
    }

    public String toDetailedString() {
        String pkcs5 = "PKCS #5:";
        pkcs5 = pkcs5 + "\r\n\tsalt = " + this.salt;
        pkcs5 = pkcs5 + "\r\n\titerationCount = " + this.iterationCount;
        pkcs5 = pkcs5 + "\r\n\tpassword = <NOT SHOWN>";
        pkcs5 = pkcs5 + "\r\n\tkeyLength = " + this.keyLength;
        pkcs5 = pkcs5 + "\r\n\tdigestAlgorithm = " + this.digestAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tcipherAlgorithm = " + this.cipherAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tcipherMode = " + this.cipherMode;
        pkcs5 = pkcs5 + "\r\n\tpaddingAlgorithm = " + this.paddingAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tversion = " + this.version;
        pkcs5 = pkcs5 + "\r\n\tkeyAlgorithm = " + this.keyAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tencryptionAlgorithm = " + this.encryptionAlgorithm;
        pkcs5 = pkcs5 + "\r\n\tkeyEncryptionFunction = " + this.keyEncryptionFunction;
        return pkcs5;
    }

    public byte[] encodePBEParameters() throws NoSuchAlgorithmException, InvalidParameterSpecException, IOException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, className, "encodePBEParameters");
        }
        AlgorithmParameters ap = AlgorithmParameters.getInstance("PBE");
        PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        ap.init(paramSpec);
        result = ap.getEncoded();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encodePBEParameters", result);
        }
        return result;
    }

    public byte[] encrypt(byte[] data) throws NoSuchAlgorithmException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encrypt", (Object)data);
        }
        if (data == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Data value not specified");
            }
            throw new IllegalArgumentException("Data value not specified.");
        }
        if (data.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Data value has no length");
            }
            throw new IllegalArgumentException("Data value has no length.");
        }
        try {
            Cipher cipher = null;
            cipher = this.provider == null ? Cipher.getInstance(this.getCipherString()) : Cipher.getInstance(this.getCipherString(), this.provider);
            PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            SecretKeyFactory secretKeyFactory = null;
            secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.getCipherString()) : SecretKeyFactory.getInstance(this.getCipherString(), this.provider);
            byte[] unsmudgedbytes = this.getPassword();
            char[] passwordchars = new char[unsmudgedbytes.length];
            for (int i = 0; i < passwordchars.length; ++i) {
                passwordchars[i] = (char)(unsmudgedbytes[i] & 0x7F);
            }
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passwordchars);
            Arrays.fill(passwordchars, ' ');
            Arrays.fill(unsmudgedbytes, (byte)0);
            SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
            cipher.init(1, (Key)secretKey, pbeSpec);
            byte[] result = cipher.doFinal(data);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "encrypt", result);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (NoSuchPaddingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (BadPaddingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (IllegalBlockSizeException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (InvalidAlgorithmParameterException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
    }

    public byte[] decrypt(byte[] data) throws PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", (Object)data);
        }
        if (data == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Data value not specified");
            }
            throw new IllegalArgumentException("Data value not specified.");
        }
        if (data.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Data value has no length.");
            }
            throw new IllegalArgumentException("Data value has no length.");
        }
        Cipher cipher = null;
        try {
            cipher = this.provider == null ? Cipher.getInstance(this.getCipherString()) : Cipher.getInstance(this.getCipherString(), this.provider);
            PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            SecretKeyFactory secretKeyFactory = null;
            secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.getCipherString()) : SecretKeyFactory.getInstance(this.getCipherString(), this.provider);
            byte[] unsmudgedbytes = this.getPassword();
            char[] passwordchars = new char[unsmudgedbytes.length];
            for (int i = 0; i < passwordchars.length; ++i) {
                passwordchars[i] = (char)(unsmudgedbytes[i] & 0x7F);
            }
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passwordchars);
            Arrays.fill(passwordchars, ' ');
            Arrays.fill(unsmudgedbytes, (byte)0);
            SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
            cipher.init(2, (Key)secretKey, pbeSpec);
            byte[] result = cipher.doFinal(data);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decrypt", result);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (NoSuchPaddingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (BadPaddingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (IllegalBlockSizeException e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (InvalidAlgorithmParameterException e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
    }

    public byte[] generateMAC(byte[] data) throws IllegalArgumentException, NoSuchAlgorithmException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateMAC", (Object)data);
        }
        if (data == null) {
            if (debug != null) {
                debug.text(16384L, className, "generateMAC", "Data value not specified.");
            }
            throw new IllegalArgumentException("Data value not specified.");
        }
        if (data.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "generateMAC", "Data value has no length.");
            }
            throw new IllegalArgumentException("Data value has no length.");
        }
        try {
            Mac mac = null;
            String hMacString = this.getHMACString();
            mac = Mac.getInstance(hMacString);
            PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            SecretKeyFactory secretKeyFactory = null;
            secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.getCipherString()) : SecretKeyFactory.getInstance(this.getCipherString(), this.provider);
            byte[] unsmudgedbytes = this.getPassword();
            char[] passwordchars = new char[unsmudgedbytes.length];
            for (int i = 0; i < passwordchars.length; ++i) {
                passwordchars[i] = (char)(unsmudgedbytes[i] & 0x7F);
            }
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passwordchars);
            Arrays.fill(passwordchars, ' ');
            Arrays.fill(unsmudgedbytes, (byte)0);
            SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
            mac.init(secretKey);
            byte[] result = mac.doFinal(data);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "generateMAC", result);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(16384L, className, "generateMAC", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(16384L, className, "generateMAC", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(16384L, className, "generateMAC", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(16384L, className, "generateMAC", e);
            }
            throw new PKCSException(e, "Error encrypting data (" + e.toString() + ")");
        }
    }

    public void verifyMAC(byte[] mac, byte[] data) throws PKCSException, IllegalArgumentException, NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, className, "verifyMAC", mac, data);
        }
        if (mac == null) {
            if (debug != null) {
                debug.text(16384L, className, "verifyMAC", "MAC value not specified.");
            }
            throw new IllegalArgumentException("MAC value not specified.");
        }
        if (mac.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "verifyMAC", "MAC value has no length.");
            }
            throw new IllegalArgumentException("MAC value has no length.");
        }
        int j = mac.length;
        byte[] generatedMAC = this.generateMAC(data);
        int k = generatedMAC.length;
        if (j != k) {
            if (debug != null) {
                debug.text(16384L, className, "verifyMAC", "MAC value is invalid.");
            }
            throw new PKCSException("MAC value is invalid.");
        }
        for (int i = 0; i < j; ++i) {
            if (mac[i] == generatedMAC[i]) continue;
            if (debug != null) {
                debug.text(16384L, className, "verifyMAC", "MAC value is invalid. (1)");
            }
            throw new PKCSException("MAC value is invalid.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verifyMAC");
        }
    }

    private void setPassword(byte[] bytes) {
        if (debug != null) {
            debug.entry(8192L, className, "setPassword");
            debug.exit(8192L, className, "setPassword");
        }
        this.password = new SmudgedBytes(bytes);
    }

    private byte[] getPassword() {
        if (debug != null) {
            debug.entry(8192L, className, "getPassword");
            debug.exit(8192L, className, "getPassword");
        }
        if (this.password == null) {
            return null;
        }
        return this.password.getClearText();
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(8192L, className, "finalize");
            debug.exit(8192L, className, "finalize");
        }
        this.password = null;
    }

    private static boolean inSet(String checkString, String[] arrayString) {
        boolean result = false;
        if (debug != null) {
            debug.entry(8192L, className, "inSet", checkString, arrayString);
        }
        if (arrayString != null && checkString != null && arrayString.length > 0) {
            for (int i = 0; i < arrayString.length; ++i) {
                if (!checkString.equalsIgnoreCase(arrayString[i])) continue;
                result = true;
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "inSet", new Boolean(result));
        }
        return result;
    }

    private void setKeyAlgorithm(String keyAlgorithm) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setKeyAlgorithm", keyAlgorithm);
        }
        if (!PKCS5.inSet(keyAlgorithm, supportedKeyAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setKeyAlgorithm", "Key Algorithm " + keyAlgorithm + " not supported.");
            }
            throw new IllegalArgumentException("Key Algorithm " + keyAlgorithm + " not supported.");
        }
        this.keyAlgorithm = keyAlgorithm.toUpperCase(Locale.US);
        if (debug != null) {
            debug.exit(8192L, className, "setKeyAlgorithm");
        }
    }

    private void setEncryptionAlgorithm(String encryptionAlgorithm) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncryptionAlgorithm", encryptionAlgorithm);
        }
        if (!PKCS5.inSet(encryptionAlgorithm, supportedEncryptionAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setEncryptionAlgorithm", "Encryption Algorithm " + this.keyAlgorithm + " not supported.");
            }
            throw new IllegalArgumentException("Encryption Algorithm " + encryptionAlgorithm + " not supported.");
        }
        this.encryptionAlgorithm = encryptionAlgorithm.toUpperCase(Locale.US);
        if (debug != null) {
            debug.exit(8192L, className, "setEncryptionAlgorithm");
        }
    }

    private void setSalt(byte[] salt) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSalt", (Object)salt);
        }
        if (salt.length != 8) {
            if (debug != null) {
                debug.text(8192L, className, "setSalt", "Salt value must be 8 bytes long.");
            }
            throw new IllegalArgumentException("Salt value must be 8 bytes long.");
        }
        this.salt = (byte[])salt.clone();
        if (debug != null) {
            debug.exit(8192L, className, "setSalt");
        }
    }

    private void setIterationCount(int iterations) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setIterationCount", new Integer(iterations));
        }
        if (iterations < 1) {
            if (debug != null) {
                debug.text(8192L, className, "setIterationCount", "Iteration count must be greater than 0.");
            }
            throw new IllegalArgumentException("Iteration count must be greater than 0.");
        }
        this.iterationCount = iterations;
        if (debug != null) {
            debug.exit(8192L, className, "setIterationCount");
        }
    }

    private void setDigestAlgorithm(String digest) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setDigestAlgorithm", digest);
        }
        if (!PKCS5.inSet(digest, supportedMessageDigests)) {
            if (debug != null) {
                debug.text(8192L, className, "setDigestAlgorithm", "Digest Algorithm " + digest + " not supported. Must be one of MD2, MD5 or SHA1.");
            }
            throw new IllegalArgumentException("Digest Algorithm " + digest + " not supported. Must be one of MD2, MD5 or SHA1.");
        }
        this.digestAlgorithm = digest.toUpperCase(Locale.US);
        if (debug != null) {
            debug.exit(8192L, className, "setDigestAlgorithm");
        }
    }

    private void setCipherAlgorithm(String cipherAlgorithm) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setCipherAlgorithm", cipherAlgorithm);
        }
        if (cipherAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "setCipherAlgorithm", "No algorithm given");
            }
            throw new IllegalArgumentException("No algorithm given");
        }
        int count = 0;
        String[] parts = new String[3];
        StringTokenizer parser = new StringTokenizer(cipherAlgorithm, "/");
        try {
            while (parser.hasMoreTokens() && count < 3) {
                parts[count++] = parser.nextToken();
            }
            if (count == 0 || count == 2 || parser.hasMoreTokens()) {
                if (debug != null) {
                    debug.text(8192L, className, "setCipherAlgorithm", "Wrong algorithm format");
                }
                throw new IllegalArgumentException("Wrong algorithm format");
            }
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(8192L, className, "setCipherAlgorithm", e);
            }
            throw new IllegalArgumentException("Wrong algorithm format");
        }
        if (!PKCS5.inSet(parts[0], supportedCipherAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setCipherAlgorithm", "Cipher Algorithm " + parts[0] + " not supported. Must be one of DES, DESede or RC2.");
            }
            throw new IllegalArgumentException("Cipher Algorithm " + parts[0] + " not supported. Must be one of DES, DESede or RC2.");
        }
        if (parts[0].equalsIgnoreCase(CIPHER_ALGORITHM_DESEDE) || parts[0].equalsIgnoreCase(CIPHER_ALGORITHM_3DES)) {
            parts[0] = CIPHER_ALGORITHM_TRIPLE_DES;
        }
        this.cipherAlgorithm = parts[0].toUpperCase(Locale.US);
        if (parts[1] != null) {
            if (!PKCS5.inSet(parts[1], supportedCipherModes)) {
                if (debug != null) {
                    debug.text(8192L, className, "setCipherAlgorithm", "Cipher Mode " + parts[1] + " not supported. Must be CBC.");
                }
                throw new IllegalArgumentException("Cipher Mode " + parts[1] + " not supported. Must be CBC.");
            }
            this.cipherMode = parts[1].toUpperCase(Locale.US);
        }
        if (parts[2] != null) {
            if (!PKCS5.inSet(parts[2], supportedPaddingAlgorithms)) {
                if (debug != null) {
                    debug.text(8192L, className, "setCipherAlgorithm", "Padding Algorithm " + parts[2] + " not supported. Must be PKCS5Padding.");
                }
                throw new IllegalArgumentException("Padding Algorithm " + parts[2] + " not supported. Must be PKCS5Padding.");
            }
            this.paddingAlgorithm = parts[2].toUpperCase(Locale.US);
        }
        if (debug != null) {
            debug.exit(8192L, className, "setCipherAlgorithm");
        }
    }

    private void setPaddingAlgorithm(String padding) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setPaddingAlgorithm", padding);
        }
        if (!PKCS5.inSet(padding, supportedPaddingAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setPaddingAlgorithm", "Padding Algorithm " + padding + " not supported.");
            }
            throw new IllegalArgumentException("Padding Algorithm " + padding + " not supported.");
        }
        this.paddingAlgorithm = padding.toUpperCase(Locale.US);
        if (debug != null) {
            debug.exit(8192L, className, "setPaddingAlgorithm");
        }
    }

    private void setCipherMode(String cipherMode) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setCipherMode", cipherMode);
        }
        if (!PKCS5.inSet(cipherMode, supportedCipherModes)) {
            if (debug != null) {
                debug.text(8192L, className, "setCipherMode", "Cipher Mode " + cipherMode + " not supported.");
            }
            throw new IllegalArgumentException("Cipher Mode " + cipherMode + " not supported.");
        }
        this.cipherMode = cipherMode.toUpperCase(Locale.US);
        if (debug != null) {
            debug.exit(8192L, className, "setCipherMode");
        }
    }

    private void setKeyEncryptionFunction(String keyEncryptionFunction) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setKeyEncryptionFunction", keyEncryptionFunction);
        }
        if (!PKCS5.inSet(keyEncryptionFunction, supportedKeyEncryptionFunctions)) {
            if (debug != null) {
                debug.text(8192L, className, "setKeyEncryptionFunction", "Key Encryption Function " + keyEncryptionFunction + " not supported. Must be one of MD2, MD5 or SHA1.");
            }
            throw new IllegalArgumentException("Key Encryption Function " + keyEncryptionFunction + " not supported.  Must be one of MD2, MD5 or SHA1.");
        }
        this.keyEncryptionFunction = keyEncryptionFunction.toUpperCase(Locale.US);
        if (debug != null) {
            debug.exit(8192L, className, "setKeyEncryptionFunction");
        }
    }

    private void setVersion(int version) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setVersion", new Integer(version));
        }
        if (version == 1) {
            this.setKeyAlgorithm(KEY_ALGORITHM_PBKDF1);
            this.setEncryptionAlgorithm(ENCRYPTION_ALGORITHM_PBES1);
            if (debug != null) {
                debug.exit(8192L, className, "setVersion");
            }
            return;
        }
        if (version == 2) {
            this.setKeyAlgorithm(KEY_ALGORITHM_PBKDF2);
            this.setEncryptionAlgorithm(ENCRYPTION_ALGORITHM_PBES2);
            if (debug != null) {
                debug.exit(8192L, className, "setVersion");
            }
            return;
        }
        if (debug != null) {
            debug.text(8192L, className, "setVersion", "PKCS #5 version " + version + " not supported.");
        }
        throw new IllegalArgumentException("PKCS #5 version " + version + " not supported.");
    }

    private void setKeyLength(int keyLength) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setKeyLength", new Integer(keyLength));
        }
        int maxKeyLen = 16;
        for (int i = 0; i < supportedKeyEncryptionFunctions.length; ++i) {
            if (!this.keyEncryptionFunction.equalsIgnoreCase(supportedKeyEncryptionFunctions[i])) continue;
            maxKeyLen = maxKeyLengths[i];
        }
        if (keyLength > maxKeyLen) {
            if (debug != null) {
                debug.text(8192L, className, "setKeyLength", "Key length " + keyLength + " is too large for key derivation function " + this.keyEncryptionFunction);
            }
            throw new IllegalArgumentException("Key length " + keyLength + " is too large for key derivation function " + this.keyEncryptionFunction);
        }
        this.keyLength = keyLength;
        if (debug != null) {
            debug.exit(8192L, className, "setKeyLength");
        }
    }

    private void decodePBEParameters(byte[] der) throws NoSuchAlgorithmException, IOException, ClassNotFoundException, InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "decodePBEParameters", (Object)der);
        }
        AlgorithmParameters ap = AlgorithmParameters.getInstance("PBE");
        ap.init(der);
        Class<?> cls = Class.forName("PBEParameterSpec");
        PBEParameterSpec paramSpec = (PBEParameterSpec)ap.getParameterSpec(cls);
        this.salt = paramSpec.getSalt();
        this.iterationCount = paramSpec.getIterationCount();
        if (debug != null) {
            debug.exit(8192L, className, "decodePBEParameters");
        }
    }
}

