/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.DataType;
import com.ibm.j9ddr.vm29_00.j9.MonitorTable;
import com.ibm.j9ddr.vm29_00.j9.MonitorTableListIterator;
import com.ibm.j9ddr.vm29_00.j9.ObjectModel;
import com.ibm.j9ddr.vm29_00.pointer.PointerPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9MonitorTableListEntryPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29_00.types.U32;

public class MonitorTableList {
    protected static MonitorTable[] monitorTables = null;
    protected static boolean initialized = false;

    public static MonitorTableList from() throws CorruptDataException {
        return new MonitorTableList();
    }

    public MonitorTableListIterator iterator() throws CorruptDataException {
        return new MonitorTableListIterator();
    }

    public static J9ObjectMonitorPointer peek(J9ObjectPointer object) throws CorruptDataException {
        if (null == object || object.isNull()) {
            return J9ObjectMonitorPointer.NULL;
        }
        MonitorTable table = null;
        if (!initialized) {
            MonitorTableList.initializeCaches();
        }
        J9ObjectMonitorPointer objectMonitor = J9ObjectMonitorPointer.NULL;
        long hashcode = new U32(ObjectModel.getObjectHashCode(object)).longValue();
        int index = (int)(hashcode % (long)monitorTables.length);
        table = monitorTables[index];
        if (table == null) {
            return objectMonitor;
        }
        if (null != table && null == (objectMonitor = table.peek(object))) {
            return J9ObjectMonitorPointer.NULL;
        }
        return objectMonitor;
    }

    private static synchronized void initializeCaches() throws CorruptDataException {
        if (!initialized) {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            PointerPointer cursor = vm.monitorTables();
            int count = vm.monitorTableCount().intValue();
            monitorTables = new MonitorTable[count];
            block0: for (int i = 0; i < count; ++i) {
                J9MonitorTableListEntryPointer entries = vm.monitorTableList();
                while (entries.notNull()) {
                    if (entries.monitorTable().eq(cursor.at(i))) {
                        MonitorTableList.monitorTables[i] = MonitorTable.from(entries);
                        continue block0;
                    }
                    entries = entries.next();
                }
            }
            initialized = true;
        }
    }
}

