/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.types.UDATA;

public class GCExtensions {
    private static MM_GCExtensionsPointer gcExtensions;
    private static boolean isSegregatedHeap;
    private static boolean isMetronomeGC;
    private static boolean isStandardGC;
    private static boolean isVLHGC;
    private static boolean scavengerEnabled;
    private static UDATA softMx;

    public static boolean isSegregatedHeap() {
        return isSegregatedHeap;
    }

    public static boolean isMetronomeGC() {
        return isMetronomeGC;
    }

    public static boolean isStandardGC() {
        return isStandardGC;
    }

    public static boolean isVLHGC() {
        return isVLHGC;
    }

    public static boolean scavengerEnabled() {
        return scavengerEnabled;
    }

    public static UDATA softMx() {
        return softMx;
    }

    public static MM_GCExtensionsPointer getGCExtensionsPointer() {
        return gcExtensions;
    }

    static {
        try {
            gcExtensions = GCBase.getExtensions();
            if (J9BuildFlags.J9VM_GC_COMBINATION_SPEC) {
                isSegregatedHeap = gcExtensions._isSegregatedHeap();
                isMetronomeGC = gcExtensions._isMetronomeGC();
                isStandardGC = gcExtensions._isStandardGC();
                isVLHGC = gcExtensions._isVLHGC();
            } else {
                isSegregatedHeap = J9BuildFlags.J9VM_GC_SEGREGATED_HEAP;
                isMetronomeGC = J9BuildFlags.J9VM_GC_REALTIME;
                isStandardGC = J9BuildFlags.J9VM_GC_MODRON_STANDARD;
                isVLHGC = J9BuildFlags.J9VM_GC_VLHGC;
            }
            scavengerEnabled = J9BuildFlags.J9VM_GC_MODRON_SCAVENGER || J9BuildFlags.J9VM_GC_VLHGC ? gcExtensions.scavengerEnabled() : false;
            softMx = gcExtensions.softMx();
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error initializing GCExtensions", cde, true);
            gcExtensions = null;
        }
    }
}

