/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm28.events.DefaultEventListener;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm28.j9.LiveSetWalker;
import com.ibm.j9ddr.vm28.j9.ObjectModel;
import com.ibm.j9ddr.vm28.j9.RootSet;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ObjectHelper;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Stack;

public class RootPathCommand
extends Command {
    boolean _verboseEnabled = false;
    DefaultEventListener _listener = new DefaultEventListener();

    public RootPathCommand() {
        this.addCommand("rootpathfindall", "<address>", "prints out all the paths from a (strong) root to an object");
        this.addCommand("rootpathfind", "<address>", "prints out a path from a (strong) root to an object");
        this.addCommand("isobjectalive", "<address>", "determines whether an object is reachable from a (strong) roots or not.  Use !rootfind <address> or !rootfindall <address> to print out the path(s)");
        this.addCommand("strongrootpathfindall", "<address>", "prints out all the paths from a (strong) root to an object");
        this.addCommand("strongrootpathfind", "<address>", "prints out a path from a (strong) root to an object");
        this.addCommand("anyrootpathfindall", "<address>", "same as rootpathfindall but also includes weak roots e.g. classes, classloaders, weak references");
        this.addCommand("anyrootpathfind", "<address>", "same as rootpathfind but also includes weak roots e.g. classes, classloaders, weak references");
        this.addCommand("weakrootpathfindall", "<address>", "same as rootpathfindall but only for weak roots e.g. classes, classloaders, weak references");
        this.addCommand("weakrootpathfind", "<address>", "same as rootpathfind but only weak for roots e.g. classes, classloaders, weak references");
        this.addCommand("rootpathverbose", "", "enables displaying errors when walking live set");
        this.addCommand("rootpathnoverbose", "", "disables displaying errors when walking live set");
    }

    public static String objectToString(J9ObjectPointer object) throws CorruptDataException {
        J9ClassPointer clazz = J9ObjectHelper.clazz(object);
        StringWriter buf = new StringWriter();
        String className = J9ClassHelper.getJavaName(clazz);
        if (className.equals("java/lang/Class")) {
            buf.write("class ");
            buf.write(J9ClassHelper.getJavaName(ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(object)));
            buf.write(64);
            buf.write(object.getHexAddress());
        } else if (className.equals("java/lang/String")) {
            buf.write(34);
            buf.write(J9ObjectHelper.stringValue(object));
            buf.write("\"@");
            buf.write(object.getHexAddress());
        } else {
            buf.write(className);
            buf.write(64);
            buf.write(object.getHexAddress());
            if (ObjectModel.isIndexable(object)) {
                buf.write(" = ");
                buf.write(J9IndexableObjectHelper.getDataAsString(J9IndexableObjectPointer.cast(object)));
            }
        }
        return buf.toString();
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        switch (args.length) {
            case 0: {
                if (args.length != 0) break;
                if (command.equals("!rootpathverbose")) {
                    out.println("verbose output enabled for rootpath command.  run !rootpathnoverbose to disable verbose output");
                    this._verboseEnabled = true;
                    break;
                }
                if (command.equals("!rootpathnoverbose")) {
                    out.println("verbose output disabled for rootpath command.  run !rootpathverbose to enable verbose output");
                    this._verboseEnabled = false;
                    break;
                }
                throw new UnsupportedOperationException("Unrecognized command passed to RoothPathCommand");
            }
            case 1: {
                long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
                J9ObjectPointer objectToFind = J9ObjectPointer.cast(address);
                try {
                    J9ClassPointer clazz = J9ObjectHelper.clazz(objectToFind);
                    if (!J9ClassHelper.hasValidEyeCatcher(clazz)) {
                        throw new DDRInteractiveCommandException("object class is not valid (eyecatcher is not 0x99669966)");
                    }
                }
                catch (CorruptDataException cde) {
                    throw new DDRInteractiveCommandException("memory fault de-referencing address argument", cde);
                }
                try {
                    RootPathCommandListener listener = new RootPathCommandListener();
                    EventManager.register(listener);
                    if (command.equals("!rootpathfindall") || command.equals("!strongrootpathfindall")) {
                        LiveSetWalker.walkLiveSet(new RootPathsFinder(objectToFind, out), RootSet.RootSetType.STRONG_REACHABLE);
                    } else if (command.equals("!anyrootpathfindall")) {
                        LiveSetWalker.walkLiveSet(new RootPathsFinder(objectToFind, out), RootSet.RootSetType.ALL);
                    } else if (command.equals("!weakrootpathfindall")) {
                        LiveSetWalker.walkLiveSet(new RootPathsFinder(objectToFind, out), RootSet.RootSetType.WEAK_REACHABLE);
                    } else if (command.equals("!rootpathfind") || command.equals("!strongrootpathfind")) {
                        RootPathFinder pathFinder = new RootPathFinder(objectToFind, out);
                        LiveSetWalker.walkLiveSet(pathFinder, RootSet.RootSetType.STRONG_REACHABLE);
                        if (!pathFinder._pathFound) {
                            out.println("No paths from roots found");
                        }
                    } else if (command.equals("!anyrootpathfind")) {
                        RootPathFinder pathFinder = new RootPathFinder(objectToFind, out);
                        LiveSetWalker.walkLiveSet(pathFinder, RootSet.RootSetType.ALL);
                        if (!pathFinder._pathFound) {
                            out.println("No paths from roots found");
                        }
                    } else if (command.equals("!weakrootpathfindall")) {
                        RootPathFinder pathFinder = new RootPathFinder(objectToFind, out);
                        LiveSetWalker.walkLiveSet(pathFinder, RootSet.RootSetType.WEAK_REACHABLE);
                        if (!pathFinder._pathFound) {
                            out.println("No paths from roots found");
                        }
                    } else if (command.equals("!isobjectalive")) {
                        ObjectFinderVisitor objectFinder = new ObjectFinderVisitor(objectToFind);
                        LiveSetWalker.walkLiveSet(objectFinder);
                        if (objectFinder._objectFound) {
                            out.println("Object is live");
                        } else {
                            out.println("Object is not live");
                        }
                    }
                    if (listener._corruptionFound) {
                        out.println("Corruption detected walking live set");
                        if (!this._verboseEnabled) {
                            out.println("run !rootpathverbose and re-run command to see corruptions");
                        }
                    }
                    EventManager.unregister(listener);
                    break;
                }
                catch (CorruptDataException cde) {
                    throw new DDRInteractiveCommandException("Memory fault while walking live set", cde);
                }
            }
            default: {
                throw new DDRInteractiveCommandException("Invalid number of arguments");
            }
        }
    }

    private class ObjectFinderVisitor
    implements LiveSetWalker.ObjectVisitor {
        boolean _objectFound = false;
        J9ObjectPointer _objectToFind;

        public ObjectFinderVisitor(J9ObjectPointer objectToFind) {
            this._objectToFind = objectToFind;
        }

        @Override
        public boolean visit(J9ObjectPointer object, VoidPointer address) {
            if (this._objectFound) {
                return false;
            }
            if (object.equals(this._objectToFind)) {
                this._objectFound = true;
                return false;
            }
            return true;
        }

        @Override
        public void finishVisit(J9ObjectPointer object, VoidPointer address) {
        }
    }

    private class RootPathCommandListener
    implements IEventListener {
        public boolean _corruptionFound = false;

        private RootPathCommandListener() {
        }

        @Override
        public void corruptData(String message2, CorruptDataException e, boolean fatal) {
            this._corruptionFound = true;
            if (RootPathCommand.this._verboseEnabled) {
                RootPathCommand.this._listener.corruptData(message2, e, fatal);
            }
        }
    }

    private class RootPathFinder
    implements LiveSetWalker.ObjectVisitor {
        boolean _pathFound = false;
        J9ObjectPointer _objectToFind;
        Stack<J9ObjectPointer> _scanStack = new Stack();
        PrintStream _out;

        public RootPathFinder(J9ObjectPointer objectToFind, PrintStream out) {
            this._objectToFind = objectToFind;
            this._out = out;
        }

        @Override
        public boolean visit(J9ObjectPointer object, VoidPointer address) {
            if (this._pathFound) {
                return false;
            }
            this._scanStack.push(object);
            if (object.equals(this._objectToFind)) {
                this.dumpTree();
                this._pathFound = true;
                this._scanStack.pop();
                return false;
            }
            return true;
        }

        private void dumpTree() {
            this._out.println("\n========================================");
            for (int i = 0; i < this._scanStack.size(); ++i) {
                for (int j = i; j > 0; --j) {
                    this._out.print("  ");
                }
                try {
                    this._out.println(RootPathCommand.objectToString((J9ObjectPointer)this._scanStack.get(i)));
                    continue;
                }
                catch (CorruptDataException cde) {
                    this._out.println("Invalid Object");
                }
            }
        }

        @Override
        public void finishVisit(J9ObjectPointer object, VoidPointer address) {
            this._scanStack.pop();
        }
    }

    private class RootPathsFinder
    implements LiveSetWalker.ObjectVisitor {
        Stack<J9ObjectPointer> _scanStack = new Stack();
        J9ObjectPointer _objectToFind;
        PrintStream _out;

        public RootPathsFinder(J9ObjectPointer objectToFind, PrintStream out) {
            this._objectToFind = objectToFind;
            this._out = out;
        }

        @Override
        public boolean visit(J9ObjectPointer object, VoidPointer address) {
            this._scanStack.push(object);
            if (object.equals(this._objectToFind)) {
                this.dumpTree();
                this._scanStack.pop();
                return false;
            }
            return true;
        }

        private void dumpTree() {
            this._out.println("\n========================================");
            for (int i = 0; i < this._scanStack.size(); ++i) {
                for (int j = i; j > 0; --j) {
                    this._out.print("  ");
                }
                try {
                    this._out.println(RootPathCommand.objectToString((J9ObjectPointer)this._scanStack.get(i)));
                    continue;
                }
                catch (CorruptDataException cde) {
                    this._out.println("Invalid Object");
                }
            }
        }

        @Override
        public void finishVisit(J9ObjectPointer object, VoidPointer address) {
            this._scanStack.pop();
        }
    }
}

