/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm28.j9.J9JavaStackIterator;
import com.ibm.j9ddr.vm28.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm28.pointer.UDATAPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm28.pointer.generated.J9JavaStackPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.io.PrintStream;

public class FindStackValueCommand
extends Command {
    public FindStackValueCommand() {
        this.addCommand("findstackvalue", "<stackvalue>", "search stacks for a specific value");
    }

    private void printUsage(PrintStream out) {
        out.println("\tUSAGE: ");
        out.println("\t!findstackvalue <stackvalue>");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (0 == args.length) {
            out.println("Usage error: Missing stackvalue to search for. See usage.");
            this.printUsage(out);
            return;
        }
        if (1 < args.length) {
            out.println("Usage error: Too many stackvalues to search for. See usage.");
            this.printUsage(out);
            return;
        }
        try {
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            UDATAPointer value = UDATAPointer.cast(address);
            GCVMThreadListIterator gcvmThreadListIterator = GCVMThreadListIterator.from();
            while (gcvmThreadListIterator.hasNext()) {
                J9VMThreadPointer vmThreadPointer = gcvmThreadListIterator.next();
                J9JavaStackPointer javaStackPointer = vmThreadPointer.stackObject();
                J9JavaStackIterator javaStackIterator = J9JavaStackIterator.fromJ9JavaStack(javaStackPointer);
                boolean found = false;
                UDATA relativeSP = new UDATA(javaStackPointer.end().sub(vmThreadPointer.sp()));
                while (javaStackIterator.hasNext()) {
                    J9JavaStackPointer stack = javaStackIterator.next();
                    UDATAPointer localEnd = stack.end().sub(1L).add(1L);
                    UDATAPointer search = localEnd.sub(relativeSP);
                    while (!search.eq(localEnd)) {
                        if (search.at(0L).longValue() == value.longValue()) {
                            if (!found) {
                                out.append(String.format("!j9vmthread %s\n", Long.toHexString(vmThreadPointer.getAddress())));
                                found = true;
                            }
                            out.append(String.format("\tFound at %s\n", Long.toHexString(search.getAddress())));
                        }
                        search = search.add(1L);
                    }
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

