/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.vm27.j9.ObjectMonitor;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm27.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm27.view.dtfj.java.DTFJJavaThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class DTFJJavaObjectMonitor
implements JavaMonitor {
    private final Logger log = DTFJContext.getLogger();
    private final ObjectMonitor monitor;
    private String name = null;

    public DTFJJavaObjectMonitor(ObjectMonitor ptr) {
        this.monitor = ptr;
        this.log.fine(String.format("Created object monitor 0x%016x", this.monitor.getObject().getAddress()));
    }

    public Iterator getEnterWaiters() {
        try {
            return this.convertToDTFJThreads(this.monitor.getBlockedThreads());
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    private Iterator<?> convertToDTFJThreads(List<J9VMThreadPointer> threads) {
        ArrayList<DTFJJavaThread> dtfjthreads = new ArrayList<DTFJJavaThread>();
        for (J9VMThreadPointer thread : threads) {
            dtfjthreads.add(new DTFJJavaThread(thread));
        }
        return dtfjthreads.iterator();
    }

    public ImagePointer getID() {
        try {
            if (this.monitor.isInflated()) {
                return DTFJContext.getImagePointer(this.monitor.getInflatedMonitor().getAddress());
            }
            return DTFJContext.getImagePointer(this.monitor.getObject().getAddress());
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            return new J9DDRImagePointer(DTFJContext.getProcess(), 1002855686514536461L);
        }
    }

    public String getName() throws CorruptDataException {
        if (this.name == null) {
            try {
                String objaddress = Long.toHexString(this.monitor.getObject().getAddress());
                String id = Long.toHexString(this.getID().getAddress());
                this.name = String.format("(un-named monitor @0x%s for object @0x%s)", id, objaddress);
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return this.name;
    }

    public Iterator getNotifyWaiters() {
        try {
            return this.convertToDTFJThreads(this.monitor.getWaitingThreads());
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public JavaObject getObject() {
        return new DTFJJavaObject(this.monitor.getObject());
    }

    public JavaThread getOwner() throws CorruptDataException {
        try {
            J9VMThreadPointer ptr = this.monitor.getOwner();
            if (ptr == null || ptr.isNull()) {
                return null;
            }
            return new DTFJJavaThread(ptr);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DTFJJavaObjectMonitor)) {
            return false;
        }
        DTFJJavaObjectMonitor test = (DTFJJavaObjectMonitor)obj;
        return this.getID().equals((Object)test.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

