/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Humanize;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantContextHelper;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_AllocationContextTarokPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionDescriptorVLHGCPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.HashMap;

public class TenantRegionsCommand
extends Command {
    public TenantRegionsCommand() {
        this.addCommand("tenantregions", "", "Dump all regions with tenant details");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            TenantContextHelper tenantContextHelper = new TenantContextHelper(vm);
            Table table = new Table("Regions");
            table.row("num", "region", "start", "end", "subspace", "type", "size", "owningContext", "tenant");
            HashMap<Long, J9ObjectPointer> tenantsByAC = new HashMap<Long, J9ObjectPointer>();
            for (J9ObjectPointer tenantObject : tenantContextHelper.getAllTenants()) {
                long acRef = tenantContextHelper.allocationContextRef(tenantObject);
                tenantsByAC.put(acRef, tenantObject);
            }
            GCHeapRegionIterator gcHeapRegionIterator = GCHeapRegionIterator.from();
            int regionNumber = 0;
            long totalSize = 0L;
            while (gcHeapRegionIterator.hasNext()) {
                GCHeapRegionDescriptor heapRegionDescriptor = gcHeapRegionIterator.next();
                MM_HeapRegionDescriptorPointer mmRegion = heapRegionDescriptor.getHeapRegionDescriptorPointer();
                MM_HeapRegionDescriptorVLHGCPointer vlhgcRegion = MM_HeapRegionDescriptorVLHGCPointer.cast(mmRegion);
                MM_AllocationContextTarokPointer owningContext = vlhgcRegion._allocateData()._owningContext();
                J9ObjectPointer owningTenant = (J9ObjectPointer)tenantsByAC.get(owningContext.longValue());
                table.row(Integer.toString(regionNumber), heapRegionDescriptor.getHeapRegionDescriptorPointer().getHexAddress(), heapRegionDescriptor.getLowAddress().getHexAddress(), heapRegionDescriptor.getHighAddress().getHexAddress(), heapRegionDescriptor.getSubSpace().getHexAddress(), Humanize.pointer(heapRegionDescriptor.getTypeFlags().longValue()), Humanize.bytes(heapRegionDescriptor.getSize().longValue()), owningContext.getHexAddress(), owningTenant != null ? tenantContextHelper.id(owningTenant) : "-");
                totalSize += heapRegionDescriptor.getSize().longValue();
                ++regionNumber;
            }
            table.row("", "", "", "", "", "total", Humanize.bytes(totalSize), "", "");
            table.render(out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

