/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.GCIterator;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import java.util.NoSuchElementException;

public class GCVMThreadListIterator
extends GCIterator {
    protected J9VMThreadPointer initialVMThread;
    protected J9VMThreadPointer currentVMThread;
    protected boolean consumedInitial;

    protected GCVMThreadListIterator() throws CorruptDataException {
        this.currentVMThread = this.initialVMThread = GCVMThreadListIterator.getJavaVM().mainThread();
    }

    public static GCVMThreadListIterator from() throws CorruptDataException {
        return new GCVMThreadListIterator();
    }

    @Override
    public boolean hasNext() {
        return this.currentVMThread.notNull();
    }

    @Override
    public J9VMThreadPointer next() {
        try {
            if (this.hasNext()) {
                J9VMThreadPointer next = this.currentVMThread;
                this.currentVMThread = this.currentVMThread.linkNext();
                if (this.currentVMThread.equals(this.initialVMThread)) {
                    this.currentVMThread = J9VMThreadPointer.NULL;
                }
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            this.currentVMThread = J9VMThreadPointer.NULL;
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

