/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_OwnableSynchronizerObjectListPointer;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckOwnableSynchronizerList
extends Check {
    CheckOwnableSynchronizerList() {
    }

    @Override
    public void check() {
        try {
            MM_OwnableSynchronizerObjectListPointer ownableSynchronizerObjectList = this.getGCExtensions().ownableSynchronizerObjectLists();
            while (ownableSynchronizerObjectList.notNull()) {
                J9ObjectPointer object = ownableSynchronizerObjectList._head();
                while (object.notNull()) {
                    if (this._engine.checkSlotOwnableSynchronizerList(object, ownableSynchronizerObjectList) != 0) {
                        return;
                    }
                    object = ObjectAccessBarrier.getOwnableSynchronizerLink(object);
                }
                ownableSynchronizerObjectList = ownableSynchronizerObjectList._nextList();
            }
        }
        catch (CorruptDataException ownableSynchronizerObjectList) {
        }
        catch (NoSuchFieldError e) {
            return;
        }
    }

    @Override
    public String getCheckName() {
        return "OWNABLE_SYNCHRONIZER";
    }

    @Override
    public void print() {
        try {
            MM_OwnableSynchronizerObjectListPointer ownableSynchronizerObjectList = this.getGCExtensions().ownableSynchronizerObjectLists();
            ScanFormatter formatter = new ScanFormatter(this, "ownableSynchronizerObjectList");
            while (ownableSynchronizerObjectList.notNull()) {
                formatter.section("list", ownableSynchronizerObjectList);
                J9ObjectPointer object = ownableSynchronizerObjectList._head();
                while (object.notNull()) {
                    formatter.entry(object);
                    object = ObjectAccessBarrier.getOwnableSynchronizerLink(object);
                }
                formatter.endSection();
                ownableSynchronizerObjectList = ownableSynchronizerObjectList._nextList();
            }
            formatter.end("ownableSynchronizerObjectList");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

