/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.structure.J9CfrClassFile;
import com.ibm.j9ddr.vm26.structure.J9FieldFlags;
import com.ibm.j9ddr.vm26.structure.J9ROMFieldShape;
import com.ibm.j9ddr.vm26.types.UDATA;

public class J9ROMFieldShapeHelper {
    public static String getName(J9ROMFieldShapePointer fieldShapePointer) throws CorruptDataException {
        return J9UTF8Helper.stringValue(fieldShapePointer.nameAndSignature().name());
    }

    public static String getSignature(J9ROMFieldShapePointer fieldShapePointer) throws CorruptDataException {
        return J9UTF8Helper.stringValue(fieldShapePointer.nameAndSignature().signature());
    }

    public static String toString(J9ROMFieldShapePointer fieldShapePointer) throws CorruptDataException {
        return String.format("%s(%s, %s)", fieldShapePointer.getClass().getSimpleName(), J9ROMFieldShapeHelper.getName(fieldShapePointer), J9ROMFieldShapeHelper.getSignature(fieldShapePointer));
    }

    public static J9ROMFieldShapePointer next(J9ROMFieldShapePointer fieldShapePointer) throws CorruptDataException {
        return J9ROMFieldShapePointer.cast(fieldShapePointer.addOffset(J9ROMFieldShapeHelper.romFieldSizeOf(fieldShapePointer)));
    }

    public static UDATA romFieldSizeOf(J9ROMFieldShapePointer fieldShapePointer) throws CorruptDataException {
        long size = J9ROMFieldShape.SIZEOF;
        if (fieldShapePointer.modifiers().allBitsIn(J9FieldFlags.J9FieldFlagConstant)) {
            size += (long)(fieldShapePointer.modifiers().allBitsIn(J9FieldFlags.J9FieldSizeDouble) ? 8 : 4);
        }
        if (fieldShapePointer.modifiers().allBitsIn(J9FieldFlags.J9FieldFlagHasGenericSignature)) {
            size += 4L;
        }
        if (fieldShapePointer.modifiers().allBitsIn(J9FieldFlags.J9FieldFlagHasFieldAnnotations)) {
            long bytesToPad = 0L;
            long annotationSize = U32Pointer.cast(fieldShapePointer.addOffset(size)).at(0L).longValue();
            size += annotationSize;
            size += 4L;
            bytesToPad = 4L - annotationSize % 4L;
            if (4L == bytesToPad) {
                bytesToPad = 0L;
            }
            size += bytesToPad;
        }
        return new UDATA(size);
    }

    public static U32Pointer getFieldAnnotationsDataFromROMField(J9ROMFieldShapePointer fieldShapePointer) throws CorruptDataException {
        if (!fieldShapePointer.modifiers().allBitsIn(J9FieldFlags.J9FieldFlagHasFieldAnnotations)) {
            return U32Pointer.NULL;
        }
        long size = 0L;
        if (fieldShapePointer.modifiers().allBitsIn(J9FieldFlags.J9FieldFlagConstant)) {
            size += (long)(fieldShapePointer.modifiers().allBitsIn(J9FieldFlags.J9FieldSizeDouble) ? 8 : 4);
        }
        if (fieldShapePointer.modifiers().allBitsIn(J9FieldFlags.J9FieldFlagHasGenericSignature)) {
            size += 4L;
        }
        return U32Pointer.cast(fieldShapePointer.add(1L)).addOffset(size);
    }

    public static int getReflectModifiers(J9ROMFieldShapePointer fieldShapePointer) throws CorruptDataException {
        return fieldShapePointer.modifiers().bitAnd(J9CfrClassFile.CFR_FIELD_ACCESS_MASK).intValue();
    }
}

