/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.gc.GCIterator;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MemorySegmentPointer;
import java.util.NoSuchElementException;

public class GCClassLoaderSegmentIterator
extends GCIterator {
    private J9ClassLoaderPointer classLoader;
    private J9MemorySegmentPointer memorySegment;
    private long flags;

    protected GCClassLoaderSegmentIterator(J9ClassLoaderPointer classLoader, long flags) throws CorruptDataException {
        this.classLoader = classLoader;
        this.memorySegment = this.classLoader.classSegments();
        this.flags = flags;
    }

    public static GCClassLoaderSegmentIterator fromJ9ClassLoader(J9ClassLoaderPointer classLoader, long flags) throws CorruptDataException {
        return new GCClassLoaderSegmentIterator(classLoader, flags);
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.memorySegment.notNull()) {
                if (this.memorySegment.type().allBitsIn(this.flags)) {
                    return true;
                }
                this.memorySegment = this.memorySegment.nextSegmentInClassLoader();
            }
            return false;
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error determining next segment", cde, true);
            return false;
        }
    }

    @Override
    public J9MemorySegmentPointer next() {
        try {
            if (this.hasNext()) {
                J9MemorySegmentPointer currentMemorySegment = this.memorySegment;
                this.memorySegment = this.memorySegment.nextSegmentInClassLoader();
                return currentMemorySegment;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error returning next segment", cde, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

