/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.structure.J9Consts;
import com.ibm.j9ddr.vm26.types.I32;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;

public class ObjectHash {
    private static U32 getSalt(J9JavaVMPointer vm) throws CorruptDataException {
        U32 salt = new U32(1421595292L).bitXor(new U32(UDATA.cast(vm)));
        return salt;
    }

    static U32 rotateLeft(U32 value, int count) {
        return value.leftShift(count).bitXor(value.rightShift(32 - count));
    }

    static U32 mix(U32 hashValue, U32 datum) {
        U32 MUL1 = new U32(-862048943L);
        U32 MUL2 = new U32(461845907L);
        U32 ADD1 = new U32(-430675100L);
        datum = datum.mult(MUL1);
        datum = ObjectHash.rotateLeft(datum, 15);
        datum = datum.mult(MUL2);
        hashValue = hashValue.bitXor(datum);
        hashValue = ObjectHash.rotateLeft(hashValue, 13);
        hashValue = hashValue.mult(5);
        hashValue = hashValue.add(ADD1);
        return hashValue;
    }

    private static I32 inlineConvertObjectAddressToHash(J9JavaVMPointer vm, J9ObjectPointer objectPointer) throws CorruptDataException {
        U32 MUL1 = new U32(-2048144789L);
        U32 MUL2 = new U32(-1028477387L);
        U32 hashValue = ObjectHash.getSalt(vm);
        UDATA shiftedAddress = UDATA.cast(objectPointer).div(J9Consts.J9_GC_OBJECT_ALIGNMENT_IN_BYTES);
        U32 datum = new U32(shiftedAddress.bitAnd(-1));
        hashValue = ObjectHash.mix(hashValue, datum);
        if (J9BuildFlags.env_data64) {
            datum = new U32(shiftedAddress.rightShift(32));
            hashValue = ObjectHash.mix(hashValue, datum);
        }
        hashValue = hashValue.bitXor(UDATA.SIZEOF);
        hashValue = hashValue.bitXor(hashValue.rightShift(16));
        hashValue = hashValue.mult(MUL1);
        hashValue = hashValue.bitXor(hashValue.rightShift(13));
        hashValue = hashValue.mult(MUL2);
        hashValue = hashValue.bitXor(hashValue.rightShift(16));
        return new I32(hashValue);
    }

    public static I32 convertObjectAddressToHash(J9JavaVMPointer vm, J9ObjectPointer object) throws CorruptDataException {
        return ObjectHash.inlineConvertObjectAddressToHash(vm, object);
    }
}

