/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;

public class ForeachCommand
extends Command {
    public static String[] foreachArgs = null;

    public ForeachCommand() {
        this.addCommand("foreach", "", "build up a list of elements to operate on ");
        this.addCommand("do", "<command>", "repeat a command for each element in the list");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (command.equals("!do")) {
            boolean echo = false;
            boolean quiet = false;
            String token = null;
            int commandIndex = 0;
            while (commandIndex < args.length) {
                if (args[commandIndex].equals("help")) {
                    out.println("The !do command is used to repeat a command on the elements gathered by the !foreach command.");
                    out.println("Syntax:\t!do [echo] [quiet] [token=<token>] <cmd> [args]");
                    out.println();
                    out.println("\techo\t\tOutput each command before it is run.");
                    out.println("\tquiet\t\tSuppress delimiters between command outputs.");
                    out.println("\ttoken=<chars>\tSpecify a substitution token. Occurrencs of this string in the args will be replaced by the current element.");
                    return;
                }
                if (args[commandIndex].equals("echo")) {
                    echo = true;
                    ++commandIndex;
                    continue;
                }
                if (args[commandIndex].equals("quiet")) {
                    quiet = true;
                    ++commandIndex;
                    continue;
                }
                if (!args[commandIndex].startsWith("token=")) break;
                token = args[commandIndex].substring("token=".length());
                ++commandIndex;
            }
            if (commandIndex >= args.length) {
                out.println("The do command requires another command to repeat.");
                return;
            }
            if (null == foreachArgs || 0 == foreachArgs.length) {
                out.println("Element list is empty. Use the foreach command to populate it.");
                return;
            }
            for (int i = 0; i < foreachArgs.length; ++i) {
                if (!quiet && i > 0) {
                    out.println("========================================");
                }
                try {
                    Object[] newArgs = null == token ? this.substituteArgs(args, commandIndex, i) : this.substituteArgs(args, commandIndex, i, token);
                    if (echo) {
                        System.out.println("> " + args[commandIndex] + " " + Arrays.toString(newArgs));
                    }
                    CommandParser commandParser = new CommandParser(args[commandIndex], (String[])newArgs);
                    context.execute(commandParser, out);
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace(out);
                    continue;
                }
                catch (Throwable th) {
                    out.println("Exception while executing " + args[commandIndex] + " " + foreachArgs[i]);
                    th.printStackTrace(out);
                }
            }
        } else if (command.equals("!foreach")) {
            if (args.length > 0) {
                out.println("The !foreach command takes no arguments, but will read lines from the console until it encounters a blank line.");
                out.println("These lines can then be used as arguments to commands specified using !do.");
                return;
            }
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String line;
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    break;
                }
                if (0 == line.length()) break;
                lines.add(line);
            }
            String[] newArgs = new String[lines.size()];
            lines.toArray(newArgs);
            foreachArgs = newArgs;
        }
    }

    private String[] substituteArgs(String[] args, int commandIndex, int foreachIndex) {
        String[] newArgs = new String[args.length - commandIndex];
        System.arraycopy(args, commandIndex + 1, newArgs, 0, args.length - commandIndex - 1);
        newArgs[newArgs.length - 1] = foreachArgs[foreachIndex];
        return newArgs;
    }

    private String[] substituteArgs(String[] args, int commandIndex, int foreachIndex, String token) {
        String[] newArgs = new String[args.length - commandIndex - 1];
        System.arraycopy(args, commandIndex + 1, newArgs, 0, args.length - commandIndex - 1);
        for (int i = 0; i < newArgs.length; ++i) {
            newArgs[i] = newArgs[i].replace(token, foreachArgs[foreachIndex]);
        }
        return newArgs;
    }
}

