/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class BaseStructureCommand
implements ICommand {
    private final List<IFieldFormatter> fieldFormatters = new LinkedList<IFieldFormatter>();
    private final List<IStructureFormatter> structureFormatters = new LinkedList<IStructureFormatter>();

    public BaseStructureCommand() {
        this.registerStructureFormatter(new DefaultStructureFormatter());
    }

    @Override
    public final boolean recognises(String command, Context context) {
        if (command.length() < 2) {
            return false;
        }
        StructureReader.StructureDescriptor desc = StructureCommandUtil.getStructureDescriptor(command = command.substring(1), context);
        return desc != null;
    }

    protected void registerFieldFormatter(IFieldFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("Field formatter cannot be null");
        }
        this.fieldFormatters.add(0, formatter);
    }

    protected void registerStructureFormatter(IStructureFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("Structure formatter cannot be null");
        }
        this.structureFormatters.add(0, formatter);
    }

    protected void registerDefaultStructureFormatter(IStructureFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("Structure formatter cannot be null");
        }
        if (this.structureFormatters.size() > 0) {
            this.structureFormatters.remove(this.structureFormatters.size() - 1);
        }
        this.structureFormatters.add(formatter);
    }

    @Override
    public final void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length < 1) {
            out.println("Missing address argument. Usage: " + command + " <address>");
            return;
        }
        boolean is64BitPlatform = context.process.bytesPerPointer() == 8;
        long address = CommandUtils.parsePointer(args[0], is64BitPlatform);
        String[] extraArgs = new String[args.length - 1];
        for (int i = 0; i < extraArgs.length; ++i) {
            extraArgs[i] = args[i + 1];
        }
        this.formatStructure(command.substring(1), address, out, context, extraArgs);
    }

    private void formatStructure(String type2, long address, PrintStream out, Context context, String[] extraArgs) {
        FormatWalkResult result;
        IStructureFormatter formatter3;
        IStructureFormatter formatter2;
        FormatWalkResult result2;
        ArrayList<IFieldFormatter> localFieldFormatters = new ArrayList<IFieldFormatter>(this.fieldFormatters);
        Iterator<IStructureFormatter> iterator = this.structureFormatters.iterator();
        while (iterator.hasNext() && (result2 = (formatter2 = iterator.next()).preFormat(type2, address, out, context, localFieldFormatters, extraArgs)) != FormatWalkResult.STOP_WALKING) {
        }
        boolean found = false;
        for (IStructureFormatter formatter3 : this.structureFormatters) {
            result = formatter3.format(type2, address, out, context, localFieldFormatters, extraArgs);
            if (result != FormatWalkResult.STOP_WALKING) continue;
            found = true;
            break;
        }
        if (!found) {
            out.println("<<Couldn't format " + type2 + ">>");
        }
        Iterator<IStructureFormatter> iterator2 = this.structureFormatters.iterator();
        while (iterator2.hasNext() && (result = (formatter3 = iterator2.next()).postFormat(type2, address, out, context, localFieldFormatters, extraArgs)) != FormatWalkResult.STOP_WALKING) {
        }
    }

    @Override
    public final Collection<String> getCommandDescriptions() {
        return Collections.singleton("<struct> <address>\t\tFormat <struct> at <address>");
    }

    public Set<String> getCommandNames() {
        return null;
    }

    protected class DefaultStructureFormatter
    extends BaseStructureFormatter {
        protected DefaultStructureFormatter() {
        }

        @Override
        public FormatWalkResult format(String type2, long address, PrintStream out, Context context, List<IFieldFormatter> fieldFormatters, String[] extraArgs) {
            this.setFieldFormatters(fieldFormatters);
            LinkedList<StructureReader.StructureDescriptor> inheritanceStack = new LinkedList<StructureReader.StructureDescriptor>();
            String current = type2;
            while (current != null && current.length() > 0) {
                StructureReader.StructureDescriptor desc = StructureCommandUtil.getStructureDescriptor(current, context);
                inheritanceStack.add(0, desc);
                current = desc.getSuperName();
            }
            StructureReader.StructureDescriptor specifiedType = (StructureReader.StructureDescriptor)inheritanceStack.get(inheritanceStack.size() - 1);
            out.print(specifiedType.getName());
            out.print(" at ");
            out.print("0x");
            out.print(Long.toHexString(address));
            out.print(" {");
            out.println();
            for (StructureReader.StructureDescriptor desc : inheritanceStack) {
                out.println(String.format("  Fields for %s:", desc.getName()));
                for (StructureReader.FieldDescriptor thisField : desc.getFields()) {
                    if (!thisField.isPresent()) continue;
                    out.print("\t0x");
                    out.print(Integer.toHexString(thisField.getOffset()));
                    out.print(": ");
                    out.print(thisField.getDeclaredType());
                    out.print(" ");
                    out.print(thisField.getName());
                    out.print(" = ");
                    try {
                        this.formatField(thisField.getName(), thisField.getType(), thisField.getDeclaredType(), address + (long)thisField.getOffset(), out, context);
                    }
                    catch (CorruptDataException e) {
                        out.print("<FAULT>");
                    }
                    out.println();
                }
            }
            out.println("}");
            return FormatWalkResult.STOP_WALKING;
        }
    }
}

