/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.X500Name;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashMap;
import java.util.Set;

public final class RSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int modlen = 2048;
    private SessionManager sessionManager = null;
    private Config config = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean sign = new Boolean(true);
    private Boolean encrypt = new Boolean(true);
    private Boolean wrapping = new Boolean(true);
    private Boolean extractable = null;
    private boolean paramsUsed = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Debug debugSessionObjectCount = Debug.getInstance((String)"objectcount");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyPairGenerator";

    public RSAPKCS11KeyPairGenerator(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
    }

    public RSAPKCS11KeyPairGenerator() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)params, (Object)random);
        }
        if (params == null || !(params instanceof PKCS11RSAKeyPairParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 RSA KeyPair Parameters must be specified");
        }
        PKCS11RSAKeyPairParameterSpec spec = (PKCS11RSAKeyPairParameterSpec)params;
        try {
            RSAKeyFactory.checkKeyLengths((int)spec.getStrength(), null, (int)512, (int)65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("Invalid key sizes", e);
        }
        this.modlen = spec.getStrength();
        if (spec.getKeyID() != null) {
            try {
                this.id = spec.getKeyID().getBytes("8859_1");
            }
            catch (Exception e) {
                this.id = spec.getKeyID().getBytes();
            }
        }
        if (spec.getSubject() != null) {
            try {
                this.subject = spec.getSubject().getBytes("8859_1");
            }
            catch (Exception e) {
                this.subject = spec.getSubject().getBytes();
            }
        }
        this.label = spec.getLabel();
        this.isSensitive = spec.getSensitive();
        this.isToken = spec.getToken();
        this.sign = spec.getSign();
        this.encrypt = spec.getEncrypt();
        this.wrapping = spec.getWrap();
        this.extractable = spec.getExtractable();
        this.paramsUsed = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + strength), (Object)random);
        }
        try {
            RSAKeyFactory.checkKeyLengths((int)strength, (BigInteger)RSAKeyGenParameterSpec.F4, (int)512, (int)65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        this.modlen = strength;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength) {
        this.initialize(strength, null);
    }

    @Override
    public KeyPair generateKeyPair() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateKeyPair");
        }
        HashMap<Object, Object> hattrs = new HashMap<Integer, Integer>();
        HashMap<Object, Object> hattrs2 = new HashMap();
        if (this.config != null) {
            hattrs = this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA);
            hattrs2 = this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA);
        }
        byte[] encodedSubjNameCopy = null;
        if (this.paramsUsed) {
            if (this.id != null) {
                hattrs.put(258, this.id);
                hattrs2.put(258, this.id);
            }
            if (this.subject != null) {
                encodedSubjNameCopy = this.encodedSubject(this.subject);
                hattrs.put(257, encodedSubjNameCopy);
                hattrs2.put(257, encodedSubjNameCopy);
            }
            if (this.label != null) {
                hattrs.put(3, this.label);
                hattrs2.put(3, this.label);
            }
            if (this.isSensitive != null) {
                hattrs2.put(259, this.isSensitive);
            }
            if (this.isToken != null) {
                hattrs.put(1, this.isToken);
                hattrs2.put(1, this.isToken);
            }
            if (this.sign != null) {
                hattrs.put(266, this.sign);
                hattrs2.put(264, this.sign);
            }
            if (this.encrypt != null) {
                hattrs.put(260, this.encrypt);
                hattrs2.put(261, this.encrypt);
            }
            if (this.wrapping != null) {
                hattrs.put(262, this.wrapping);
                hattrs2.put(263, this.wrapping);
            }
            if (this.extractable != null) {
                hattrs2.put(354, this.extractable);
            }
        }
        hattrs.put(289, new Integer(this.modlen));
        hattrs.put(290, new BigInteger("65537"));
        int size = hattrs.size();
        int[] pubTypes = new int[size];
        Object[] pubValues = new Object[size];
        Set<Object> keySet = hattrs.keySet();
        int count = 0;
        for (Object key : keySet) {
            pubTypes[count] = (Integer)key;
            pubValues[count++] = hattrs.get(key);
        }
        size = hattrs2.size();
        int[] privTypes = new int[size];
        Object[] privValues = new Object[size];
        keySet = hattrs2.keySet();
        count = 0;
        for (Object key : keySet) {
            privTypes[count] = (Integer)key;
            privValues[count++] = hattrs2.get(key);
        }
        String error = "";
        PKCS11Object[] objs = null;
        KeyPair pair = null;
        Session session = null;
        try {
            session = this.sessionManager.getObjSession();
            if (debugSessionObjectCount != null) {
                int sessObjectCount = session.getObjectCount();
                System.out.println("RSAPKCS11KEYPairGenerator.java:  generateKeyPair():  The session id allocated for this keypair is:  " + session.getID());
                if (sessObjectCount != 0) {
                    System.out.println("RSAPKCS11KEYPairGenerator.java:  generateKeyPair():  The session allocated for this keypair contains a non-zero object count.  Oops.");
                }
            }
            objs = session.generateKeyPair(0, null, pubTypes, pubValues, privTypes, privValues);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)e);
            }
            this.sessionManager.releaseSession(session);
            throw new RuntimeException(e.getMessage());
        }
        PKCS11Object[] returnobjs = this.orderObjects(session, objs);
        PKCS11Object pubObj = returnobjs[0];
        PKCS11Object privObj = returnobjs[1];
        try {
            RSAPublicKey pubKey = new RSAPublicKey(session, pubObj, this.id, encodedSubjNameCopy, this.label, this.isToken, this.sign, this.encrypt, this.wrapping, (BigInteger)this.getValue(session, pubObj, 288), (Integer)this.getValue(session, pubObj, 289), (BigInteger)this.getValue(session, pubObj, 290));
            if (!session.getBoolAttributeValue(pubObj, 1)) {
                pubKey.setSession(session);
                if (debugSessionObjectCount != null) {
                    System.out.println("RSAPKCS11KeyPairGenerator.java:  generateKeyPair():  For the generated RSAPublicKey, increment the session object count within session " + session.getID());
                }
                session.addObject();
            }
            RSAPrivateKey privKey = null;
            if (this.isSensitive.booleanValue()) {
                privKey = new RSAPrivateKey(session, privObj, this.id, encodedSubjNameCopy, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(session, privObj, 288), (BigInteger)this.getValue(session, privObj, 290));
            } else {
                try {
                    privKey = new RSAPrivateKey(session, privObj, this.id, encodedSubjNameCopy, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(session, privObj, 288), (BigInteger)this.getValue(session, privObj, 290), (BigInteger)this.getValue(session, privObj, 291), (BigInteger)this.getValue(session, privObj, 292), (BigInteger)this.getValue(session, privObj, 293), (BigInteger)this.getValue(session, privObj, 294), (BigInteger)this.getValue(session, privObj, 295), (BigInteger)this.getValue(session, privObj, 296));
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)ex);
                    }
                    privKey = new RSAPrivateKey(session, privObj, this.id, encodedSubjNameCopy, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(session, privObj, 288), (BigInteger)this.getValue(session, privObj, 290));
                }
            }
            if (!session.getBoolAttributeValue(privObj, 1)) {
                privKey.setSession(session);
                if (debugSessionObjectCount != null) {
                    System.out.println("RSAPKCS11KeyPairGenerator.java:  generateKeyPair():  For the generated RSAPrivateKey, increment the session object count within session " + session.getID());
                }
                session.addObject();
            }
            pair = new KeyPair(pubKey, privKey);
        }
        catch (Exception e) {
            int sessionObjectCount = session.getObjectCount();
            if (debug != null || debugSessionObjectCount != null) {
                System.out.println("RSAPKCS11KeyPairGenerator.java:  generateKeyPair():  An exception was thrown during EC key pair generation.");
                System.out.println("RSAPKCS11KeyPairGenerator.java:  generateKeyPair():  Decrement the session object count to zero, and release the session.");
                System.out.println("RSAPKCS11KeyPairGenerator.java:  generateKeyPair():  The session object count before decrementing is:  " + sessionObjectCount);
            }
            while (sessionObjectCount > 0) {
                session.removeObject();
                sessionObjectCount = session.getObjectCount();
                if (debugSessionObjectCount == null) continue;
                System.out.println("RSAPKCS11KeyPairGenerator.java:  generateKeyPair():  Decremented the session object count to:  " + sessionObjectCount);
            }
            this.sessionManager.releaseSession(session);
            pair = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return pair;
    }

    private PKCS11Object[] orderObjects(Session session, PKCS11Object[] objs) {
        if (debug != null) {
            String objString = objs.toString();
            debug.entry(16384L, (Object)className, "orderObjects", (Object)objString);
        }
        Integer objsType0 = (Integer)this.getValue(session, objs[0], 0);
        Integer objsType1 = (Integer)this.getValue(session, objs[1], 0);
        PKCS11Object privObj = null;
        PKCS11Object pubObj = null;
        if (objsType0.equals(PKCS11Object.PUBLIC_KEY) && objsType1.equals(PKCS11Object.PRIVATE_KEY)) {
            pubObj = objs[0];
            privObj = objs[1];
        } else if (objsType0.equals(PKCS11Object.PRIVATE_KEY) && objsType1.equals(PKCS11Object.PUBLIC_KEY)) {
            pubObj = objs[1];
            privObj = objs[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        objs[0] = pubObj;
        objs[1] = privObj;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects", (Object)objs);
        }
        return objs;
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    private byte[] encodedSubject(byte[] subject) {
        DerOutputStream dos = null;
        String newString = null;
        X500Name subjName = null;
        String[] stringArray = null;
        UnstructuredName unstructName = null;
        byte[] encodedSubjNameCopy = null;
        try {
            if (debug != null) {
                debug.text(16384L, (Object)className, "encodedSubject", "Try DER encoding public key subject name as X500 name initially");
            }
            dos = new DerOutputStream();
            newString = new String(subject, "8859_1");
            subjName = new X500Name(newString);
            subjName.encode(dos);
            encodedSubjNameCopy = dos.toByteArray();
        }
        catch (Exception ex) {
            try {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "encodedSubject", "DER encode public key subject name as UnstructuredName instead");
                }
                dos = new DerOutputStream();
                stringArray = new String[]{new String(subject, "8859_1")};
                unstructName = new UnstructuredName(stringArray);
                unstructName.encode((OutputStream)dos);
                encodedSubjNameCopy = dos.toByteArray();
            }
            catch (Exception ex2) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "generateKeyPair_2.3", (Throwable)ex2);
                }
                throw new RuntimeException(ex2.getMessage());
            }
        }
        return encodedSubjNameCopy;
    }
}

