/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.SecureRandom;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SSLHashingwithRSA
extends SignatureSpi {
    private Signature sig;
    private byte[] hashData;
    private int count = 0;
    private SessionManager sessionManager;
    private Session session;
    private boolean isSign;
    private Key sigKey;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");

    public PKCS11SSLHashingwithRSA(Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.sig = new Signature(1, provider);
        this.hashData = new byte[128];
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
    }

    public PKCS11SSLHashingwithRSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    @Override
    protected void engineSetParameter(String key, Object param) {
    }

    @Override
    protected Object engineGetParameter(String key) {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.count = 0;
        if (this.session != null) {
            this.cancelOperation();
        }
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        }
        try {
            this.sig.engineInitSign(this.session, privateKey);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
            throw new InvalidKeyException(ex);
        }
        catch (InvalidKeyException ex) {
            this.sessionManager.releaseSession(this.session);
            this.session = null;
            throw ex;
        }
        this.isSign = true;
        this.sigKey = privateKey;
    }

    private void cancelOperation() {
        if (this.session == null) {
            return;
        }
        if (this.session.hasObjects()) {
            if (this.isSign) {
                try {
                    this.sig.engineSign(this.session, this.hashData, this.count);
                }
                catch (Exception exception) {}
            } else {
                this.sig.engineDummyVerify(this.session, "RSA");
            }
        } else {
            this.sessionManager.closeSession(this.session);
            this.session = null;
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.count = 0;
        if (this.session != null) {
            this.cancelOperation();
        }
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        }
        try {
            this.sig.engineInitVerify(this.session, publicKey);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
            throw new InvalidKeyException(ex);
        }
        catch (InvalidKeyException ex) {
            this.sessionManager.releaseSession(this.session);
            this.session = null;
            throw ex;
        }
        this.isSign = false;
        this.sigKey = publicKey;
    }

    protected void engineInitVerify(PublicKey publicKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
    }

    @Override
    protected void engineUpdate(byte b) {
        if (this.session == null) {
            if (this.sigKey == null) {
                throw new RuntimeException("Signature is not initialized");
            }
            try {
                if (this.isSign) {
                    this.engineInitSign((PrivateKey)this.sigKey);
                } else {
                    this.engineInitVerify((PublicKey)this.sigKey);
                }
            }
            catch (InvalidKeyException ex) {
                if (debug != null) {
                    debug.exception(16384L, (Object)"PKCS11SSLHashingwithRSA", "engineUpdate", (Throwable)ex);
                }
                throw new RuntimeException(ex);
            }
        }
        if (this.count + 1 > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        this.hashData[this.count] = b;
        ++this.count;
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) {
        if (data.length < off + len) {
            throw new IllegalArgumentException("invalid parameter");
        }
        if (this.session == null) {
            if (this.sigKey == null) {
                throw new RuntimeException("Signature is not initialized");
            }
            try {
                if (this.isSign) {
                    this.engineInitSign((PrivateKey)this.sigKey);
                } else {
                    this.engineInitVerify((PublicKey)this.sigKey);
                }
            }
            catch (InvalidKeyException ex) {
                if (debug != null) {
                    debug.exception(16384L, (Object)"PKCS11SSLHashingwithRSA", "engineUpdate", (Throwable)ex);
                }
                throw new RuntimeException(ex);
            }
        }
        if (this.count + len > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128 + len];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        System.arraycopy(data, off, this.hashData, this.count, len);
        this.count += len;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)"PKCS11SSLHashingwithRSA", "engineSign");
        }
        if (!this.isSign || this.sigKey == null) {
            throw new SignatureException("Signature object was not properly initialized");
        }
        if (this.session == null) {
            try {
                this.engineInitSign((PrivateKey)this.sigKey);
            }
            catch (InvalidKeyException ex) {
                throw new SignatureException(ex);
            }
        }
        byte[] rtn = null;
        try {
            rtn = this.sig.engineSign(this.session, this.hashData, this.count);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        finally {
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
        }
        this.count = 0;
        if (debug != null) {
            debug.exit(16384L, (Object)"PKCS11SSLHashingwithRSA", "engineSigne");
        }
        return rtn;
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)"PKCS11SSLHashingwithRSA", "engineVerify");
        }
        if (this.isSign || this.sigKey == null) {
            throw new SignatureException("Signature object was not properly initialized");
        }
        if (this.session == null) {
            try {
                this.engineInitVerify((PublicKey)this.sigKey);
            }
            catch (InvalidKeyException ex) {
                throw new SignatureException(ex);
            }
        }
        boolean rtn = false;
        try {
            rtn = this.sig.engineVerify(this.session, signature, this.hashData, this.count);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (Exception e) {
            throw new SignatureException("invalid encoding for signature :" + e);
        }
        finally {
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
        }
        this.count = 0;
        if (debug != null) {
            debug.exit(16384L, (Object)"PKCS11SSLHashingwithRSA", "engineVerify");
        }
        return rtn;
    }
}

