/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.misc.Debug;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;

public class KDFParameterSpec
implements AlgorithmParameterSpec {
    public static final int CKD_NULL = 1;
    public static final int CKD_SHA1_KDF = 2;
    public static final int CKD_SHA224_KDF = 5;
    public static final int CKD_SHA256_KDF = 6;
    public static final int CKD_SHA384_KDF = 7;
    public static final int CKD_SHA512_KDF = 8;
    protected static final int CKD_INVALID = -1;
    public static final int CKD_SHA256_NIST_KDF = -2147483628;
    private int keySize = 0;
    private int kdf;
    private byte[] sharedInfo = null;
    private static Debug debug = Debug.getInstance((String)"kdf");

    public KDFParameterSpec(int kdf, byte[] sharedInfo) throws InvalidAlgorithmParameterException {
        this(0, kdf, sharedInfo);
    }

    public KDFParameterSpec(int keySize, int kdf, byte[] sharedInfo) throws InvalidAlgorithmParameterException {
        if (kdf != 1 && kdf != 2 && kdf != 5 && kdf != 6 && kdf != 7 && kdf != 8 && kdf != -2147483628) {
            throw new InvalidAlgorithmParameterException("Invalid kdf value supplied.");
        }
        if (kdf == 1 && sharedInfo != null) {
            throw new InvalidAlgorithmParameterException("No sharedInfo should be supplied if kdf==CKD_NULL.");
        }
        if (sharedInfo != null && sharedInfo.length == 0) {
            throw new InvalidAlgorithmParameterException("sharedInfo must have a length greater than zero.");
        }
        this.keySize = keySize;
        this.kdf = kdf;
        this.sharedInfo = sharedInfo;
        if (debug != null) {
            System.out.println("KDFParameterSpec.java:  CONSTRUCTOR:  The keySize value supplied was:  " + keySize);
            System.out.println("                                      A value of 0 means that the user has chosen not to specify a keySize.");
            System.out.println("                                      The default keySize values defined within ECDHPKCS11KeyAgreement will prevail.");
            System.out.println("KDFParameterSpec.java:  CONSTRUCTOR:  The kdf value supplied was:      " + kdf);
            if (sharedInfo == null) {
                System.out.println("KDFParameterSpec.java:  CONSTRUCTOR:  The sharedInfo value supplied was NULL.");
            } else {
                System.out.println("KDFParameterSpec.java:  CONSTRUCTOR:  The sharedInfo value supplied was:");
                System.out.println(KDFParameterSpec.toHexString(sharedInfo));
            }
        }
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getKDF() {
        return this.kdf;
    }

    public byte[] getSharedInfo() {
        if (this.sharedInfo == null) {
            return null;
        }
        byte[] sharedInfoClone = new byte[this.sharedInfo.length];
        for (int i = 0; i < this.sharedInfo.length; ++i) {
            sharedInfoClone[i] = this.sharedInfo[i];
        }
        return sharedInfoClone;
    }

    protected void finalize() throws Throwable {
        if (this.sharedInfo != null) {
            for (int i = 0; i < this.sharedInfo.length; ++i) {
                this.sharedInfo[i] = 0;
            }
            this.sharedInfo = null;
        }
        this.kdf = 0;
    }

    private static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }
}

