/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyPairParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.ec.ECParameters;
import com.ibm.security.ec.NamedCurve;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X500Name;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.HashMap;
import java.util.Set;

public final class ECPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int modlen = 256;
    private SessionManager sessionManager = null;
    private Config config = null;
    private AlgorithmParameterSpec params;
    private byte[] keyIdentifier = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean sign = new Boolean(true);
    private Boolean extractable = null;
    private boolean paramsUsed = false;
    private String namedCurveFromParams = null;
    private SecureRandom random;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Debug debugSessionObjectCount = Debug.getInstance((String)"objectcount");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.ECPKCS11KeyPairGenerator";

    public ECPKCS11KeyPairGenerator(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ECPKCS11KeyPairGenerator");
        }
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "ECPKCS11KeyPairGenerator");
        }
    }

    public ECPKCS11KeyPairGenerator() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            System.out.println("ECPKCS11KeyPairGenerator.java:  initialize(params, random):  METHOD ENTRY");
        }
        if (params == null) {
            throw new InvalidAlgorithmParameterException("An AlgorithmParameterSpec must be specified");
        }
        if (!(params instanceof PKCS11ECKeyPairParameterSpec || params instanceof ECParameterSpec || params instanceof ECGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("A PKCS11ECKeyPairParameterSpec, ECParameterSpec, or ECGenParameterSpec must be specified.");
        }
        if (params instanceof ECParameterSpec || params instanceof ECGenParameterSpec) {
            ECParameterSpec ecParams;
            if (params instanceof ECParameterSpec) {
                ecParams = PKCS11ECKeyFactory.getECParameterSpec((ECParameterSpec)params);
                if (ecParams == null) {
                    throw new InvalidAlgorithmParameterException("Unsupported curve: " + params);
                }
            } else if (params instanceof ECGenParameterSpec) {
                String name = ((ECGenParameterSpec)params).getName();
                if (name == null) {
                    throw new InvalidAlgorithmParameterException("The supplied curve name is null.");
                }
                this.namedCurveFromParams = name;
                ecParams = PKCS11ECKeyFactory.getECParameterSpec(name);
                if (ecParams == null) {
                    throw new InvalidAlgorithmParameterException("Unknown curve name: " + name);
                }
            } else {
                throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
            }
            this.params = ecParams;
            this.random = random;
            this.modlen = ecParams.getCurve().getField().getFieldSize();
            if (this.modlen < 112) {
                throw new InvalidAlgorithmParameterException("Key size must be at least 112 bit");
            }
            if (this.modlen > 2048) {
                throw new InvalidAlgorithmParameterException("Key size must be at most 2048 bit");
            }
        } else if (params instanceof PKCS11ECKeyPairParameterSpec) {
            PKCS11ECKeyPairParameterSpec spec = (PKCS11ECKeyPairParameterSpec)params;
            ECParameterSpec ecParameterSpec = null;
            if (((PKCS11ECKeyPairParameterSpec)params).getECParameterSpec() != null) {
                if (debug != null) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  initialize(params, random):  Initialized with a PKCS11ECKeyPairParameterSpec that carried an ECParameterSpec.");
                }
                ecParameterSpec = (ECParameterSpec)((PKCS11ECKeyPairParameterSpec)params).getECParameterSpec();
                if ((ecParameterSpec = ECParameters.getNamedCurve((ECParameterSpec)ecParameterSpec)) == null) {
                    throw new InvalidAlgorithmParameterException("The ECParameterSpec supplied does not represent a known curve.");
                }
            } else if (((PKCS11ECKeyPairParameterSpec)params).getECGenParameterSpec() != null) {
                String name;
                if (debug != null) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  initialize(params, random):  Initialized with a PKCS11ECKeyPairParameterSpec that carried an ECGenParameterSpec.");
                }
                if ((name = ((ECGenParameterSpec)((PKCS11ECKeyPairParameterSpec)params).getECGenParameterSpec()).getName()) == null) {
                    throw new InvalidAlgorithmParameterException("The ECGenParameterSpec supplied contained a curve name that was null.");
                }
                ecParameterSpec = NamedCurve.getECParameterSpec((String)name);
                if (ecParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("The ECGenParameterSpec supplied contained an unknown curve name:  " + name);
                }
                this.namedCurveFromParams = name;
                if (debug != null) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  initialize(params, random):  The ECGenParameterSpec carried the following curve name:  " + name);
                }
            } else if (((PKCS11ECKeyPairParameterSpec)params).getKeySize() > 0) {
                int keySize;
                if (debug != null) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  initialize(params, random):  Initialized with a PKCS11ECKeyPairParameterSpec that carried an EC key size.");
                }
                if ((ecParameterSpec = NamedCurve.getECParameterSpec((int)(keySize = ((PKCS11ECKeyPairParameterSpec)params).getKeySize()))) == null) {
                    throw new InvalidAlgorithmParameterException("The supplied EC key size is invalid:  " + keySize);
                }
            } else {
                throw new InvalidAlgorithmParameterException("The PKCS11ECKeyPairParameterSpec requires either a key size, ECParameterSpec, or ECGenParameterSpec.");
            }
            this.params = ecParameterSpec;
            this.random = random;
            this.modlen = ecParameterSpec.getCurve().getField().getFieldSize();
            if (this.modlen < 112) {
                throw new InvalidAlgorithmParameterException("Key size must be at least 112 bits");
            }
            if (this.modlen > 2048) {
                throw new InvalidAlgorithmParameterException("Key size must be at most 2048 bits");
            }
            if (spec.getKeyID() != null) {
                try {
                    this.keyIdentifier = spec.getKeyID().getBytes("8859_1");
                }
                catch (Exception e) {
                    this.keyIdentifier = spec.getKeyID().getBytes();
                }
            }
            if (spec.getSubject() != null) {
                try {
                    this.subject = spec.getSubject().getBytes("8859_1");
                }
                catch (Exception e) {
                    this.subject = spec.getSubject().getBytes();
                }
            }
            this.label = spec.getLabel();
            this.isToken = spec.getToken();
            this.isSensitive = spec.getSensitive();
            this.sign = spec.getSign();
            this.extractable = spec.getExtractable();
            this.paramsUsed = true;
        }
        if (debug != null) {
            System.out.println("ECPKCS11KeyPairGenerator.java:  initialize(params, random):  METHOD EXIT");
        }
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + keysize), (Object)random);
        }
        if (keysize < 112) {
            throw new RuntimeException("Key size must be at least 112 bit");
        }
        if (keysize > 2048) {
            throw new RuntimeException("Key size must be at most 2048 bit");
        }
        this.modlen = keysize;
        this.random = random;
        if (keysize == 521) {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  initialize():  Initializing with a key size of 521.  Use secp521r1 instead");
            }
            this.namedCurveFromParams = "secp521r1";
        } else if (keysize == 384) {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  initialize():  Initializing with a key size of 384.  Use secp384r1 instead");
            }
            this.namedCurveFromParams = "secp384r1";
        } else if (keysize == 256) {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  initialize():  Initializing with a key size of 256.  Use secp256r1 instead");
            }
            this.namedCurveFromParams = "secp256r1";
        } else if (keysize == 224) {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  initialize():  Initializing with a key size of 224.  Use secp224r1 instead");
            }
            this.namedCurveFromParams = "secp224r1";
        } else if (keysize == 192) {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  initialize():  Initializing with a key size of 192.  Use secp192r1 instead");
            }
            this.namedCurveFromParams = "secp192r1";
        } else {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  initialize():  Initializing with a key size of " + keysize + ".  Use the curve name for those other than 192,224,256,384,and 521");
            }
            this.params = PKCS11ECKeyFactory.getECParameterSpec(keysize);
            if (this.params == null) {
                throw new InvalidParameterException("No EC parameters available for key size " + keysize + " bits");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength) {
        this.initialize(strength, null);
    }

    @Override
    public KeyPair generateKeyPair() {
        if (debug != null) {
            System.out.println("ECPKcs11KeyPairGenerator.java:  generateKeyPair():  METHOD ENTRY");
        }
        HashMap<Object, Object> hattrs = new HashMap();
        HashMap<Object, Object> hattrs2 = new HashMap();
        if (this.config != null) {
            hattrs = this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.ECDSA);
            hattrs2 = this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.ECDSA);
        }
        byte[] encodedSubjNameCopy = null;
        if (this.paramsUsed) {
            if (this.keyIdentifier != null) {
                hattrs.put(258, this.keyIdentifier);
                hattrs2.put(258, this.keyIdentifier);
            }
            if (this.subject != null) {
                encodedSubjNameCopy = this.encodedSubject(this.subject);
                hattrs.put(257, encodedSubjNameCopy);
                hattrs2.put(257, encodedSubjNameCopy);
            }
            if (this.label != null) {
                hattrs.put(3, this.label);
                hattrs2.put(3, this.label);
            }
            if (this.isSensitive != null) {
                hattrs2.put(259, this.isSensitive);
            }
            if (this.isToken != null) {
                hattrs.put(1, this.isToken);
                hattrs2.put(1, this.isToken);
            }
            if (this.sign != null) {
                hattrs.put(266, this.sign);
                hattrs2.put(264, this.sign);
            }
            if (this.extractable != null) {
                hattrs2.put(354, this.extractable);
            }
        }
        int size = hattrs.size() + 1;
        int[] pubTypes = new int[size];
        Object[] pubValues = new Object[size];
        Set<Object> keySet = hattrs.keySet();
        int count = 0;
        for (Object key : keySet) {
            pubTypes[count] = (Integer)key;
            pubValues[count++] = hattrs.get(key);
        }
        if (this.params == null) {
            this.params = PKCS11ECKeyFactory.getECParameterSpec("secp256r1");
        }
        byte[] encodedParams = PKCS11ECKeyFactory.encodeParameters((ECParameterSpec)this.params);
        if (this.namedCurveFromParams == null) {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  GENERATING THE KEYS BY PASSING THE 'ALL' THE EC PARAMETERS TO THE HSM");
            }
            pubTypes[count] = 384;
            pubValues[count] = encodedParams;
        } else {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  GENERATING THE KEYS BY PASSING THE EC PARAMETERS TO THE HSM AS THE OID OF A NAMED CURVE");
            }
            pubTypes[count] = 384;
            pubValues[count] = ECPKCS11KeyPairGenerator.encodeNamedCurveOID(this.namedCurveFromParams);
        }
        size = hattrs2.size();
        int[] privTypes = new int[size];
        Object[] privValues = new Object[size];
        keySet = hattrs2.keySet();
        count = 0;
        for (Object key : keySet) {
            privTypes[count] = (Integer)key;
            privValues[count++] = hattrs2.get(key);
        }
        String error = "";
        PKCS11Object[] objs = null;
        KeyPair pair = null;
        Session session = null;
        try {
            session = this.sessionManager.getObjSession();
            if (debugSessionObjectCount != null) {
                int sessObjectCount = session.getObjectCount();
                System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  The session id allocated for this keypair is:  " + session.getID());
                if (sessObjectCount != 0) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  Error.  The session allocated for this keypair contains a non-zero object count.  Oops.");
                }
            }
            objs = session.generateKeyPair(4160, null, pubTypes, pubValues, privTypes, privValues);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)e);
            }
            this.sessionManager.releaseSession(session);
            throw new RuntimeException(e.getMessage());
        }
        PKCS11Object[] returnobjs = this.orderObjects(session, objs);
        PKCS11Object pubObj = returnobjs[0];
        PKCS11Object privObj = returnobjs[1];
        try {
            PKCS11ECPublicKey pubKey = new PKCS11ECPublicKey(session, pubObj, null, null, null);
            if (!session.getBoolAttributeValue(pubObj, 1)) {
                pubKey.setSession(session);
                if (debugSessionObjectCount != null) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  For the generated PKCS11ECPublicKey, increment the session object count within session " + session.getID());
                }
                session.addObject();
            }
            PKCS11ECPrivateKey privKey = null;
            if (this.isSensitive.booleanValue()) {
                privKey = new PKCS11ECPrivateKey(session, privObj, null, null, null, (byte[])this.getValue(session, privObj, 384));
            } else {
                try {
                    privKey = new PKCS11ECPrivateKey(session, privObj, null, null, null, (byte[])this.getValue(session, privObj, 384), (BigInteger)this.getValue(session, privObj, 17));
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)ex);
                    }
                    privKey = new PKCS11ECPrivateKey(session, privObj, null, null, null, (byte[])this.getValue(session, privObj, 384));
                }
            }
            if (!session.getBoolAttributeValue(privObj, 1)) {
                privKey.setSession(session);
                if (debugSessionObjectCount != null) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  For the generated PKCS11ECPrivateKey, increment the session object count within session " + session.getID());
                }
                session.addObject();
            }
            pair = new KeyPair(pubKey, privKey);
        }
        catch (Exception e) {
            int sessionObjectCount = session.getObjectCount();
            if (debug != null || debugSessionObjectCount != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  An exception was thrown during EC key pair generation.");
                System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  Decrement the session object count to zero, and release the session.");
                System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  The session object count before decrementing is:  " + sessionObjectCount);
            }
            while (sessionObjectCount > 0) {
                session.removeObject();
                sessionObjectCount = session.getObjectCount();
                if (debugSessionObjectCount == null) continue;
                System.out.println("ECPKCS11KeyPairGenerator.java:  generateKeyPair():  Decremented the session object count to:  " + sessionObjectCount);
            }
            this.sessionManager.releaseSession(session);
            pair = null;
        }
        if (debug != null) {
            System.out.println("ECPKcs11KeyPairGenerator.java:  generateKeyPair():  METHOD EXIT");
        }
        return pair;
    }

    private PKCS11Object[] orderObjects(Session session, PKCS11Object[] objs) {
        if (debug != null) {
            String objString = objs.toString();
            debug.entry(16384L, (Object)className, "orderObjects", (Object)objString);
        }
        Integer objsType0 = (Integer)this.getValue(session, objs[0], 0);
        Integer objsType1 = (Integer)this.getValue(session, objs[1], 0);
        PKCS11Object privObj = null;
        PKCS11Object pubObj = null;
        if (objsType0.equals(PKCS11Object.PUBLIC_KEY) && objsType1.equals(PKCS11Object.PRIVATE_KEY)) {
            pubObj = objs[0];
            privObj = objs[1];
        } else if (objsType0.equals(PKCS11Object.PRIVATE_KEY) && objsType1.equals(PKCS11Object.PUBLIC_KEY)) {
            pubObj = objs[1];
            privObj = objs[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        objs[0] = pubObj;
        objs[1] = privObj;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects", (Object)objs);
        }
        return objs;
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    public static byte[] encodeNamedCurveOID(String id) {
        ObjectIdentifier curveOID;
        byte[] derEncoding;
        DerOutputStream dout;
        block9: {
            if (debug != null) {
                System.out.println("ECPKCS11KeyPairGenerator.java:  encodeNamedCurveOID():  The curve name passed in is:  " + id);
            }
            dout = new DerOutputStream();
            derEncoding = null;
            curveOID = null;
            try {
                curveOID = new ObjectIdentifier(id);
                if (debug != null) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  encodeNamedCurveOID():  The supplied curve id string represents an OID:  " + curveOID);
                }
            }
            catch (Exception ex) {
                if (debug != null) {
                    System.out.println("ECPKCS11KeyPairGenerator.java:  encodeNamedCurveOID():  The supplied curve id string IS NOT an OID:             " + id);
                    System.out.println("ECPKCS11KeyPairGenerator.java:  encodeNamedCurveOID():  The supplied curve id string represents a curve name:   " + id);
                }
                if ((curveOID = NamedCurve.getObjectIdentifier((String)id)) == null) {
                    throw new RuntimeException("The supplied EC curve name was not recognized:  " + id);
                }
                if (debug == null) break block9;
                System.out.println("ECPKCS11KeyPairGenerator.java:  encodeNamedCurveOID():  The OID learned from the named curve is:  " + curveOID);
            }
        }
        try {
            dout.putOID(curveOID);
        }
        catch (Exception e) {
            throw new RuntimeException("The supplied EC curve name was not recognized:  " + id);
        }
        derEncoding = dout.toByteArray();
        if (debug != null) {
            System.out.println("ECPKCS11KeyPairGenerator.java:  encodeNamedCurveOID():  The encoded OID is:");
            System.out.println(ECPKCS11KeyPairGenerator.toHexString(derEncoding));
        }
        return derEncoding;
    }

    private byte[] encodedSubject(byte[] subject) {
        DerOutputStream dos = null;
        String newString = null;
        X500Name subjName = null;
        String[] stringArray = null;
        UnstructuredName unstructName = null;
        byte[] encodedSubjNameCopy = null;
        try {
            if (debug != null) {
                debug.text(16384L, (Object)className, "encodedSubject", "Try DER encoding public key subject name as X500 name initially");
            }
            dos = new DerOutputStream();
            newString = new String(subject, "8859_1");
            subjName = new X500Name(newString);
            subjName.encode(dos);
            encodedSubjNameCopy = dos.toByteArray();
        }
        catch (Exception ex) {
            try {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "encodedSubject", "DER encode public key subject name as UnstructuredName instead");
                }
                dos = new DerOutputStream();
                stringArray = new String[]{new String(subject, "8859_1")};
                unstructName = new UnstructuredName(stringArray);
                unstructName.encode((OutputStream)dos);
                encodedSubjNameCopy = dos.toByteArray();
            }
            catch (Exception ex2) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "generateKeyPair_2.3", (Throwable)ex2);
                }
                throw new RuntimeException(ex2.getMessage());
            }
        }
        return encodedSubjNameCopy;
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }
}

