/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;

public final class MessageFile
extends File {
    private BufferedReader reader;
    private String component;
    private String formatName;
    protected static float verMod;
    private static boolean first;
    private static Hashtable messages;
    private static final String fromDATFile = ".definedInDatFile";
    static int counter;
    static String savedComponentName;

    public MessageFile(String s) throws IOException {
        super(s);
        this.formatName = s;
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(this)));
        first = true;
        this.read();
    }

    public float getVersion() {
        return verMod;
    }

    protected static final void initStatics() {
        verMod = 0.0f;
        first = true;
        messages = null;
    }

    private void read() throws IOException {
        String line = this.reader.readLine();
        while (line != null) {
            this.addMessage(line);
            line = this.reader.readLine();
        }
    }

    protected void addMessage(String messageLine) {
        int firstSpace = messageLine.indexOf(" ");
        int secondSpace = messageLine.indexOf(" ", firstSpace + 1);
        int thirdSpace = messageLine.indexOf(" ", secondSpace + 1);
        String componentName = null;
        int tpNumber = -1;
        String symbol = null;
        String msg = null;
        if (firstSpace == -1 || secondSpace == -1 || thirdSpace == -1) {
            if (first) {
                first = false;
                verMod = messageLine.equals("dg") ? 1.0f : Float.valueOf(messageLine).floatValue();
                if (verMod < TraceFormat.verMod) {
                    TraceFormat.outStream.println(this.formatName + " (Version " + verMod + ") does not match this trace file (Version " + TraceFormat.verMod + ")");
                }
                return;
            }
            this.component = messageLine;
            return;
        }
        if (verMod >= 5.0f) {
            int period;
            int fourthSpace = messageLine.indexOf(" ", thirdSpace + 1);
            componentName = new String(messageLine.substring(0, firstSpace));
            if (verMod >= 5.1f && (period = componentName.indexOf(46)) != -1) {
                String compName = componentName.substring(0, period);
                String tpNum = componentName.substring(period + 1);
                tpNumber = Integer.parseInt(tpNum);
                componentName = compName;
            }
            if (messages == null) {
                messages = new Hashtable();
            }
            if (savedComponentName == null || !componentName.equals(savedComponentName)) {
                String componentCameFromDATFileEntry = componentName + fromDATFile;
                messages.put(componentCameFromDATFileEntry, fromDATFile);
                savedComponentName = componentName;
                counter = 0;
            }
            int id = counter++;
            if (tpNumber >= 0) {
                id = tpNumber;
            }
            int type = Integer.parseInt(messageLine.substring(firstSpace + 1, secondSpace));
            int fifthSpace = messageLine.indexOf(" ", fourthSpace + 1);
            int sixthSpace = messageLine.indexOf(" ", fifthSpace + 1);
            symbol = messageLine.substring(fifthSpace + 1, sixthSpace);
            msg = messageLine.substring(sixthSpace + 2, messageLine.length() - 1);
            Message message = new Message(type, msg, this.component, symbol);
            String messageKey = componentName + "." + id;
            if (messages.containsKey(messageKey)) {
                System.err.println("Duplicate messages in .dat files: " + messageKey);
            } else {
                messages.put(messageKey, message);
            }
        } else {
            int id = Integer.parseInt(messageLine.substring(0, firstSpace), 16);
            int type = Integer.parseInt(messageLine.substring(firstSpace + 1, secondSpace));
            if (verMod < 1.2f) {
                symbol = messageLine.substring(secondSpace + 1, thirdSpace);
                msg = messageLine.substring(thirdSpace + 2, messageLine.length() - 1);
            } else {
                int fourthSpace = messageLine.indexOf(" ", thirdSpace + 1);
                int fifthSpace = messageLine.indexOf(" ", fourthSpace + 1);
                int sixthSpace = messageLine.indexOf(" ", fifthSpace + 1);
                symbol = messageLine.substring(fifthSpace + 1, sixthSpace);
                msg = messageLine.substring(sixthSpace + 2, messageLine.length() - 1);
            }
            Message message = new Message(type, msg, this.component, symbol);
            if (messages == null) {
                messages = new Hashtable();
            }
            messages.put(id, message);
        }
    }

    protected static Message getMessageFromID(int id) {
        if ((double)verMod >= 5.0) {
            TraceFormat.outStream.println("Trying to retrieve an old style message (" + Util.formatAsHexString(id) + ") from 5.0 or newer message file");
            return null;
        }
        if (messages == null) {
            messages = new Hashtable();
        }
        return (Message)messages.get(id);
    }

    protected static Message getMessageFromID(String compName, int id) {
        String messageKey;
        Message message;
        if ((double)verMod < 5.0) {
            TraceFormat.outStream.println("Trying to retrieve a new style message (" + compName + "." + id + ") from 1.1 or older message file");
            return null;
        }
        if (messages == null) {
            messages = new Hashtable();
        }
        if ((message = (Message)messages.get(messageKey = new String(compName + "." + id))) == null) {
            if (MessageFile.componentIsFromDATFile(compName)) {
                TraceFormat.outStream.println("Error: " + compName + "." + id + " not in dat file: dat files old or from incorrect VM.");
                message = new Message(14, "This tracepoint's format string was not available in dat file.", compName, " ");
            } else {
                message = new Message(13, "%s", compName, "%s");
            }
            messages.put(messageKey, message);
        }
        return message;
    }

    public static boolean componentIsFromDATFile(String componentName) {
        String componentCameFromDATFileEntry = componentName + fromDATFile;
        return messages != null && messages.containsKey(componentCameFromDATFileEntry);
    }

    static {
        counter = 0;
        savedComponentName = null;
    }
}

