/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.channel.framework.impl.ChildChannelDataImpl;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChannelDataImpl
implements ChannelData {
    private static final long serialVersionUID = -280440118973381476L;
    private static final TraceComponent tc = Tr.register(ChannelDataImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    public static final String CHILD_STRING = "_CFINTERNAL_CHILD_";
    private String name = null;
    private transient Map properties = null;
    private Class factoryType = null;
    private int discWeight = 0;
    private transient ChannelFramework framework = null;
    private int childId = 0;
    private List children = null;
    private Class deviceInterface;
    private boolean isInbound = true;

    public ChannelDataImpl(String string, Class clazz, Map map, int n, ChannelFramework channelFramework) {
        this.name = string;
        this.factoryType = clazz;
        this.properties = map;
        this.discWeight = n;
        this.isInbound = this.discWeight != 10;
        this.deviceInterface = null;
        this.framework = channelFramework;
        this.childId = 0;
        this.children = new ArrayList(0);
    }

    public String getName() {
        return this.name;
    }

    public Class getFactoryType() {
        return this.factoryType;
    }

    public Map getPropertyBag() {
        return this.properties;
    }

    public void setPropertyBag(Map map) {
        this.properties = map;
    }

    public void setProperty(Object object, Object object2) {
        this.properties.put(object, object2);
    }

    public int getDiscriminatorWeight() {
        return this.discWeight;
    }

    public void setDiscriminatorWeight(int n) {
        this.discWeight = n;
    }

    public Class getDeviceInterface() {
        return this.deviceInterface;
    }

    public void setDeviceInterface(Class clazz) {
        this.deviceInterface = clazz;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public boolean isOutbound() {
        return !this.isInbound;
    }

    public void setIsInbound(boolean bl) {
        this.isInbound = bl;
    }

    public ChannelFramework getChannelFramework() {
        return this.framework;
    }

    public String getExternalName() {
        return this.getName();
    }

    private int nextChildId() {
        return this.childId++;
    }

    public ChildChannelDataImpl createChild() {
        String string = new String(this.name + CHILD_STRING + this.nextChildId());
        ChildChannelDataImpl childChannelDataImpl = new ChildChannelDataImpl(string, this);
        this.children.add(childChannelDataImpl);
        return childChannelDataImpl;
    }

    public ChildChannelDataImpl getInboundChild() {
        ChildChannelDataImpl childChannelDataImpl = null;
        for (int i = 0; i < this.children.size(); ++i) {
            childChannelDataImpl = (ChildChannelDataImpl)this.children.get(i);
            if (!childChannelDataImpl.isInbound()) continue;
            return childChannelDataImpl;
        }
        return null;
    }

    public ChildChannelDataImpl getOutboundChild() {
        ChildChannelDataImpl childChannelDataImpl = null;
        for (int i = 0; i < this.children.size(); ++i) {
            childChannelDataImpl = (ChildChannelDataImpl)this.children.get(i);
            if (!childChannelDataImpl.isOutbound()) continue;
            return childChannelDataImpl;
        }
        return null;
    }

    public void removeChild(ChildChannelDataImpl childChannelDataImpl) {
        this.children.remove(childChannelDataImpl);
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public Iterator children() {
        return this.children.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ChannelData:");
        stringBuffer.append("\r\n\tname = " + this.name);
        stringBuffer.append("\r\n\tdiscweight = " + this.discWeight);
        stringBuffer.append("\r\n\tfactoryType = " + this.factoryType);
        stringBuffer.append("\r\n\tdeviceInterface = " + this.deviceInterface + "\r\n");
        if (null != this.properties) {
            stringBuffer.append("\tproperties: " + this.properties.size() + "\r\n");
            Object[] objectArray = this.properties.keySet().toArray();
            Object[] objectArray2 = this.properties.values().toArray();
            for (int i = 0; i < this.properties.size(); ++i) {
                stringBuffer.append("\t\tkey = " + objectArray[i] + ", " + "value = " + objectArray2[i] + "\r\n");
            }
        }
        stringBuffer.append("\tchildId = " + this.childId + "\r\n");
        stringBuffer.append("\tchildren: " + this.children.size() + "\r\n");
        for (int i = 0; i < this.children.size(); ++i) {
            stringBuffer.append("\t\tchild = " + ((ChildChannelDataImpl)this.children.get(i)).getName() + "\r\n");
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        HashMap hashMap = new HashMap();
        Iterator iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = this.properties.get(k);
            if (v instanceof Serializable || v instanceof Externalizable) {
                hashMap.put(k, v);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "value for key \"" + k + "\" is not serializable");
        }
        objectOutputStream.writeObject(hashMap);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.properties = (Map)objectInputStream.readObject();
    }
}

