/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.ObjectModel;
import com.ibm.j9ddr.vm29_00.j9.gc.GCArrayletObjectModelBase_V1;
import com.ibm.j9ddr.vm29_00.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29_00.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29_00.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9IndexableObjectContiguousPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9IndexablePackedObjectContiguousPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9IndexablePackedObjectDiscontiguousPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29_00.structure.GC_ArrayletObjectModelBase$ArrayLayout;
import com.ibm.j9ddr.vm29_00.structure.J9Consts;
import com.ibm.j9ddr.vm29_00.structure.J9IndexableObjectContiguous;
import com.ibm.j9ddr.vm29_00.structure.J9IndexablePackedObjectContiguous;
import com.ibm.j9ddr.vm29_00.structure.J9IndexablePackedObjectDiscontiguous;
import com.ibm.j9ddr.vm29_00.types.U32;
import com.ibm.j9ddr.vm29_00.types.UDATA;

public class GCPackedArrayObjectModel_V1
extends GCArrayletObjectModelBase_V1 {
    @Override
    protected UDATA getSpineSize(long arrayLayout, UDATA numberArraylets, UDATA dataSizeInBytes, boolean alignData) throws CorruptDataException {
        UDATA spineSize = this.getHeaderSize(arrayLayout).add(this.getSpineSizeWithoutHeader(arrayLayout, numberArraylets, dataSizeInBytes, alignData));
        return spineSize;
    }

    @Override
    public UDATA getDataSizeInBytes(J9IndexableObjectPointer arrayPtr) throws CorruptDataException {
        J9ClassPointer clazzPtr = J9ClassPointer.cast(J9IndexableObjectHelper.clazz(arrayPtr));
        return this.getDataSizeInBytes(clazzPtr, this.getArrayLayout(arrayPtr), this.getSizeInElements(arrayPtr));
    }

    public UDATA getDataSizeInBytes(J9ClassPointer clazzPtr, long layout, UDATA numberOfElements) throws CorruptDataException {
        UDATA result = new UDATA(0L);
        UDATA packedDataSize = this.getPackedDataSize(clazzPtr);
        if (GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous == layout) {
            result = UDATA.roundToSizeofUDATA(numberOfElements.mult(packedDataSize));
        } else if (UDATA.MAX.eq(this.arrayletLeafSize)) {
            result = UDATA.roundToSizeofUDATA(numberOfElements.mult(packedDataSize));
        } else {
            UDATA numberOfElementsPerLeaf = this.arrayletLeafSize.div(packedDataSize);
            UDATA numberOfLeafs = numberOfElements.div(numberOfElementsPerLeaf);
            UDATA dataInSpine = numberOfElements.mod(numberOfElementsPerLeaf).mult(packedDataSize);
            result = UDATA.roundToSizeofUDATA(dataInSpine).add(numberOfLeafs.mult(this.arrayletLeafSize));
        }
        return result;
    }

    @Override
    public J9ObjectPointer getTargetObject(J9IndexableObjectPointer objPtr) throws CorruptDataException {
        J9ObjectPointer targetObjectPtr = J9ObjectPointer.NULL;
        targetObjectPtr = J9BuildFlags.gc_hybridArraylets ? (this.isInlineContiguousArraylet(objPtr) ? J9IndexablePackedObjectContiguousPointer.cast(objPtr).object() : J9IndexablePackedObjectDiscontiguousPointer.cast(objPtr).object()) : J9IndexablePackedObjectDiscontiguousPointer.cast(objPtr).object();
        return targetObjectPtr;
    }

    @Override
    public ObjectReferencePointer getTargetObjectEA(J9IndexableObjectPointer objPtr) throws CorruptDataException {
        ObjectReferencePointer targetObjectPtr = ObjectReferencePointer.NULL;
        targetObjectPtr = J9BuildFlags.gc_hybridArraylets ? (this.isInlineContiguousArraylet(objPtr) ? J9IndexablePackedObjectContiguousPointer.cast(objPtr).objectEA() : J9IndexablePackedObjectDiscontiguousPointer.cast(objPtr).objectEA()) : J9IndexablePackedObjectDiscontiguousPointer.cast(objPtr).objectEA();
        return targetObjectPtr;
    }

    @Override
    public UDATA getTargetOffset(J9IndexableObjectPointer objPtr) throws CorruptDataException {
        UDATA targetOffset = J9BuildFlags.gc_hybridArraylets ? (this.isInlineContiguousArraylet(objPtr) ? J9IndexablePackedObjectContiguousPointer.cast(objPtr).offset() : J9IndexablePackedObjectDiscontiguousPointer.cast(objPtr).offset()) : J9IndexablePackedObjectDiscontiguousPointer.cast(objPtr).offset();
        return targetOffset;
    }

    @Override
    public UDATAPointer getTargetOffsetEA(J9IndexableObjectPointer objPtr) throws CorruptDataException {
        UDATAPointer targetOffset = J9BuildFlags.gc_hybridArraylets ? (this.isInlineContiguousArraylet(objPtr) ? J9IndexablePackedObjectContiguousPointer.cast(objPtr).offsetEA() : J9IndexablePackedObjectDiscontiguousPointer.cast(objPtr).offsetEA()) : J9IndexablePackedObjectDiscontiguousPointer.cast(objPtr).offsetEA();
        return targetOffset;
    }

    @Override
    public boolean isPackedObjectHeader(J9IndexableObjectPointer objectPtr) throws CorruptDataException {
        boolean result = !this.getTargetObject(objectPtr).eq(J9ObjectPointer.cast(objectPtr));
        return result;
    }

    @Override
    public long getArrayLayout(J9IndexableObjectPointer objPtr) throws CorruptDataException {
        long result = GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous;
        if (J9BuildFlags.gc_hybridArraylets && !J9IndexableObjectContiguousPointer.cast(objPtr).size().eq(0L)) {
            return GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous;
        }
        if (objPtr.gte(VoidPointer.cast(this.arrayletRangeBase)) && objPtr.lt(VoidPointer.cast(this.arrayletRangeTop))) {
            UDATA numberOfElements = this.getSizeInElements(objPtr);
            J9ClassPointer clazz = J9ClassPointer.cast(J9IndexableObjectHelper.clazz(objPtr));
            result = this.getArrayLayout(clazz, numberOfElements, this.largestDesirableArraySpineSize);
        }
        return result;
    }

    @Override
    public UDATA getPackedDataSize(J9IndexableObjectPointer objPtr) throws CorruptDataException {
        UDATA result = J9IndexableObjectHelper.clazz(objPtr).packedDataSize();
        return result;
    }

    @Override
    public UDATA getPackedDataSize(J9ClassPointer clazz) throws CorruptDataException {
        UDATA result = clazz.packedDataSize();
        return result;
    }

    @Override
    public UDATA getSizeInBytesWithHeader(J9IndexableObjectPointer objectPtr) throws CorruptDataException {
        UDATA sizeInBytesWithoutHeader = this.getSizeInBytesWithoutHeader(objectPtr);
        UDATA headerSize = this.getHeaderSize(objectPtr);
        UDATA result = sizeInBytesWithoutHeader.add(headerSize);
        return result;
    }

    UDATA getSizeInBytesWithHeader(J9ClassPointer clazz, UDATA numberOfElements, boolean isHeader) throws CorruptDataException {
        long layout = GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous;
        if (J9BuildFlags.gc_hybridArraylets && numberOfElements.eq(0L)) {
            layout = GC_ArrayletObjectModelBase$ArrayLayout.Discontiguous;
        }
        return this.getSizeInBytesWithHeader(clazz, layout, numberOfElements, isHeader);
    }

    UDATA getSizeInBytesWithHeader(J9ClassPointer clazz, long layout, UDATA numberOfElements, boolean isHeader) throws CorruptDataException {
        UDATA result = this.getHeaderSize(layout);
        if (!isHeader) {
            UDATA dataSize = this.getDataSizeInBytes(clazz, layout, numberOfElements);
            UDATA numberOfArraylets = this.numArraylets(dataSize);
            boolean alignData = this.shouldAlignSpineDataSection(clazz);
            result = result.add(this.getSpineSizeWithoutHeader(layout, numberOfArraylets, dataSize, alignData));
        }
        return result;
    }

    @Override
    public UDATA getHeaderSize(J9IndexableObjectPointer objectPtr) throws CorruptDataException {
        U32 size;
        long headerSize = 0L;
        headerSize = J9BuildFlags.gc_hybridArraylets ? ((size = J9IndexablePackedObjectContiguousPointer.cast(objectPtr).size()).eq(0L) ? J9IndexablePackedObjectDiscontiguous.SIZEOF : J9IndexablePackedObjectContiguous.SIZEOF) : J9IndexablePackedObjectDiscontiguous.SIZEOF;
        return new UDATA(headerSize);
    }

    @Override
    public UDATA getHeaderSize(long layout) {
        long headerSize = 0L;
        headerSize = J9BuildFlags.gc_hybridArraylets ? (GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous == layout ? J9IndexablePackedObjectContiguous.SIZEOF : J9IndexablePackedObjectDiscontiguous.SIZEOF) : J9IndexablePackedObjectDiscontiguous.SIZEOF;
        return new UDATA(headerSize);
    }

    @Override
    public VoidPointer getDataPointerForContiguous(J9IndexableObjectPointer arrayPtr) throws CorruptDataException {
        VoidPointer result = VoidPointer.NULL;
        if (this.isPackedObjectHeader(arrayPtr)) {
            J9ObjectPointer targetObject = this.getTargetObject(arrayPtr);
            UDATA targetOffset = this.getTargetOffset(arrayPtr);
            result = VoidPointer.cast(targetObject.addOffset(targetOffset));
        } else if (J9BuildFlags.gc_hybridArraylets) {
            result = VoidPointer.cast(arrayPtr.addOffset(J9IndexablePackedObjectContiguous.SIZEOF));
        } else {
            ObjectReferencePointer arrayoidPointer = this.getArrayoidPointer(arrayPtr);
            result = VoidPointer.cast(arrayoidPointer.at(0L));
        }
        return result;
    }

    UDATA getHashcodeOffset(J9ClassPointer clazzPtr, long layout, UDATA numberOfElements, boolean isHeader) throws CorruptDataException {
        UDATA result = new UDATA(0L);
        if (isHeader) {
            result = this.getHeaderSize(layout);
        } else {
            UDATA packedDataSize = this.getPackedDataSize(clazzPtr);
            if (GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous == layout) {
                result = UDATA.roundToSizeofU32(numberOfElements.mult(packedDataSize)).add(J9IndexablePackedObjectContiguous.SIZEOF);
            } else if (UDATA.MAX.eq(this.arrayletLeafSize)) {
                result = UDATA.roundToSizeofU32(numberOfElements.mult(packedDataSize)).add(J9IndexablePackedObjectDiscontiguous.SIZEOF);
            } else {
                UDATA numberOfElementsPerLeaf = this.arrayletLeafSize.div(packedDataSize);
                UDATA numberOfLeafs = numberOfElements.div(numberOfElementsPerLeaf);
                UDATA dataInSpine = numberOfElements.mod(numberOfElementsPerLeaf).mult(packedDataSize);
                UDATA dataSize = dataInSpine.add(numberOfLeafs.mult(this.arrayletLeafSize));
                boolean alignData = this.shouldAlignSpineDataSection(clazzPtr);
                UDATA spineSize = this.getSpineSize(layout, numberOfLeafs, dataSize, alignData);
                result = UDATA.roundToSizeofU32(spineSize);
            }
        }
        return result;
    }

    @Override
    public UDATA getHashcodeOffset(J9IndexableObjectPointer objectPtr) throws CorruptDataException {
        UDATA result = new UDATA(0L);
        if (this.isPackedObjectHeader(objectPtr)) {
            result = this.getHeaderSize(objectPtr);
        } else {
            J9ClassPointer clazzPtr = J9ClassPointer.cast(J9IndexableObjectHelper.clazz(objectPtr));
            long layout = this.getArrayLayout(objectPtr);
            UDATA numberOfElements = this.getSizeInElements(objectPtr);
            result = this.getHashcodeOffset(clazzPtr, layout, numberOfElements, false);
        }
        return result;
    }

    UDATA getHashcodeOffset(J9ClassPointer clazzPtr, UDATA numberOfElements, boolean isHeader) throws CorruptDataException {
        long layout = GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous;
        if (J9BuildFlags.gc_hybridArraylets && numberOfElements.eq(0L)) {
            layout = GC_ArrayletObjectModelBase$ArrayLayout.Discontiguous;
        }
        return this.getHashcodeOffset(clazzPtr, layout, numberOfElements, isHeader);
    }

    private UDATA getSizeInBytesWithoutHeader(J9IndexableObjectPointer arrayPtr) throws CorruptDataException {
        UDATA result = new UDATA(0L);
        if (!this.isPackedObjectHeader(arrayPtr)) {
            long layout = this.getArrayLayout(arrayPtr);
            UDATA dataSize = this.getDataSizeInBytes(arrayPtr);
            UDATA numberOfArraylets = this.numArraylets(dataSize);
            boolean alignData = this.shouldAlignSpineDataSection(J9IndexableObjectHelper.clazz(arrayPtr));
            result = this.getSpineSizeWithoutHeader(layout, numberOfArraylets, dataSize, alignData);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VoidPointer getElementAddress(J9IndexableObjectPointer objectPtr, int elementIndex, int elementSize) throws CorruptDataException {
        J9ObjectPointer targetObject = this.getTargetObject(objectPtr);
        if (!this.getPackedDataSize(objectPtr).eq(elementSize)) {
            throw new IllegalArgumentException("elementSize != packedDataSize");
        }
        if (targetObject.isNull()) {
            VoidPointer data = VoidPointer.cast(this.getTargetOffset(objectPtr));
            return data.addOffset((long)elementIndex * (long)elementSize);
        }
        if (!ObjectModel.isIndexable(targetObject)) return VoidPointer.cast(targetObject).addOffset(this.getTargetOffset(objectPtr)).addOffset((long)elementIndex * (long)elementSize);
        if (!this.isInlineContiguousArraylet(J9IndexableObjectPointer.cast(targetObject))) throw new IllegalArgumentException("Discontiguous arrays are not supported yet");
        return VoidPointer.cast(targetObject).addOffset(this.getTargetOffset(objectPtr)).addOffset((long)elementIndex * (long)elementSize);
    }

    UDATA getAdjustedDataSizeInBytes(J9ClassPointer clazz, long layout, UDATA numberOfElements) throws CorruptDataException {
        UDATA result = new UDATA(0L);
        UDATA packedDataSize = this.getPackedDataSize(clazz);
        if (UDATA.MAX.eq(this.arrayletLeafSize) || GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous == layout) {
            result = UDATA.roundToSizeofUDATA(numberOfElements.mult(packedDataSize));
        } else {
            UDATA numberOfElementsPerLeaf = this.arrayletLeafSize.div(packedDataSize);
            UDATA numberOfLeafs = numberOfElements.div(numberOfElementsPerLeaf);
            UDATA dataInSpine = numberOfElements.mod(numberOfElementsPerLeaf).mult(packedDataSize);
            result = UDATA.roundToSizeofUDATA(dataInSpine).add(numberOfLeafs.mult(this.arrayletLeafSize));
        }
        return result;
    }

    long getArrayletLayout(J9ClassPointer clazz, UDATA numberOfElements, UDATA largestDesirableSpine, boolean isHeader) throws CorruptDataException {
        long layout = GC_ArrayletObjectModelBase$ArrayLayout.Illegal;
        if (isHeader) {
            layout = GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous;
            if (J9BuildFlags.gc_hybridArraylets && numberOfElements.eq(0L)) {
                layout = GC_ArrayletObjectModelBase$ArrayLayout.Discontiguous;
            }
        } else {
            layout = this.getArrayLayout(clazz, numberOfElements, largestDesirableSpine);
        }
        return layout;
    }

    private long getArrayLayout(J9ClassPointer clazz, UDATA numberOfElements, UDATA largestDesirableArraySpineSize) throws CorruptDataException {
        long layout = GC_ArrayletObjectModelBase$ArrayLayout.Illegal;
        UDATA minimumSpineSize = J9BuildFlags.gc_hybridArraylets ? new UDATA(0L) : new UDATA(ObjectReferencePointer.SIZEOF);
        UDATA packedDataSize = this.getPackedDataSize(clazz);
        UDATA unadjustedDataSizeInBytes = numberOfElements.mult(packedDataSize);
        UDATA minimumSpineSizeAfterGrowing = minimumSpineSize;
        if (GCExtensions.isVLHGC()) {
            minimumSpineSize = minimumSpineSize.add(J9Consts.J9_GC_OBJECT_ALIGNMENT_IN_BYTES);
        }
        if (largestDesirableArraySpineSize.eq(UDATA.MAX) || unadjustedDataSizeInBytes.lte(largestDesirableArraySpineSize.sub(minimumSpineSizeAfterGrowing).sub(J9IndexableObjectContiguous.SIZEOF))) {
            layout = GC_ArrayletObjectModelBase$ArrayLayout.InlineContiguous;
            if (J9BuildFlags.gc_hybridArraylets && unadjustedDataSizeInBytes.eq(0L)) {
                layout = GC_ArrayletObjectModelBase$ArrayLayout.Discontiguous;
            }
        } else {
            UDATA adjustedHybridSpineBytes;
            UDATA numberOfElementsPerLeaf = this.arrayletLeafSize.div(packedDataSize);
            UDATA numberOfLeafs = numberOfElements.div(numberOfElementsPerLeaf);
            UDATA lastArrayletBytes = numberOfElements.mod(numberOfElementsPerLeaf).mult(packedDataSize);
            UDATA adjustedDataSize = UDATA.roundToSizeofUDATA(lastArrayletBytes).add(numberOfLeafs.mult(this.arrayletLeafSize));
            UDATA numArraylets = this.numArraylets(adjustedDataSize);
            boolean align = this.shouldAlignSpineDataSection(J9ArrayClassPointer.cast(clazz));
            UDATA hybridSpineBytes = this.getSpineSize(GC_ArrayletObjectModelBase$ArrayLayout.Hybrid, numArraylets, adjustedDataSize, align);
            UDATA adjustedHybridSpineBytesAfterMove = adjustedHybridSpineBytes = ObjectModel.adjustSizeInBytes(hybridSpineBytes);
            if (GCExtensions.isVLHGC()) {
                adjustedHybridSpineBytesAfterMove = adjustedHybridSpineBytesAfterMove.add(J9Consts.J9_GC_OBJECT_ALIGNMENT_IN_BYTES);
            }
            layout = lastArrayletBytes.gt(0) && adjustedHybridSpineBytesAfterMove.lte(largestDesirableArraySpineSize) ? GC_ArrayletObjectModelBase$ArrayLayout.Hybrid : GC_ArrayletObjectModelBase$ArrayLayout.Discontiguous;
        }
        return layout;
    }

    @Override
    public ObjectReferencePointer getArrayoidPointer(J9IndexableObjectPointer arrayPtr) throws CorruptDataException {
        return ObjectReferencePointer.cast(arrayPtr.addOffset(J9IndexablePackedObjectDiscontiguous.SIZEOF));
    }
}

