/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import java.io.PrintStream;
import java.util.regex.Pattern;

public final class J9ConstantPoolFieldFormatter
extends BaseFieldFormatter {
    private static final Pattern TypePattern = Pattern.compile("(struct\\s+)?J9ConstantPool\\s*\\*");

    @Override
    public FormatWalkResult format(String name, String type2, String declaredType, int typeCode, long address, PrintStream out, Context context, IStructureFormatter structureFormatter) throws CorruptDataException {
        if (121 == typeCode && TypePattern.matcher(type2).matches()) {
            VoidPointer ptr = PointerPointer.cast(address).at(0L);
            J9ConstantPoolPointer cpPtr = J9ConstantPoolPointer.cast(ptr).untag(J9Consts.J9_STARTPC_STATUS);
            long flags = ptr.getAddress() & J9Consts.J9_STARTPC_STATUS;
            out.print("!j9constantpool ");
            out.print(cpPtr.getHexAddress());
            out.print(" (flags = 0x");
            out.print(Long.toHexString(flags).toUpperCase());
            out.print(")");
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }
}

