/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ObjectToSparseDataHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SparseAddressOrderedFixedSizeDataPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SparseDataTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SparseVirtualMemoryPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpAllOffHeapEntriesCommand
extends Command {
    public DumpAllOffHeapEntriesCommand() {
        this.addCommand("dumpalloffheapentries", "[help]", "dump all off-heap entries");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        String argument;
        if (0 != args.length && (argument = args[0]).equalsIgnoreCase("help")) {
            DumpAllOffHeapEntriesCommand.help(out);
            return;
        }
        boolean offHeapPresent = false;
        try {
            J9HashTablePointer objectToSparseDataTable;
            MM_SparseAddressOrderedFixedSizeDataPoolPointer sparseAddressOrderedFixedSizeDataPool;
            MM_GCExtensionsPointer extensions = GCBase.getExtensions();
            MM_SparseVirtualMemoryPointer sparseVirualMemory = extensions.largeObjectVirtualMemory();
            if (sparseVirualMemory.notNull() && (sparseAddressOrderedFixedSizeDataPool = sparseVirualMemory._sparseDataPool()).notNull() && (objectToSparseDataTable = sparseAddressOrderedFixedSizeDataPool._objectToSparseDataTable()).notNull()) {
                offHeapPresent = true;
                HashTable<MM_SparseDataTableEntryPointer> readObjectToSparseDataTable = ObjectToSparseDataHashTable.fromJ9HashTable(objectToSparseDataTable);
                Iterator readSlotIterator = readObjectToSparseDataTable.iterator();
                long count = readObjectToSparseDataTable.getCount();
                out.format("Off-heap entries (%,d entries)%n", count);
                if (0L < count) {
                    out.format("+------------------+------------------+------------------%n", new Object[0]);
                    out.format("| array object     | data address     | size             %n", new Object[0]);
                    out.format("+------------------+------------------+------------------%n", new Object[0]);
                    while (readSlotIterator.hasNext()) {
                        MM_SparseDataTableEntryPointer readSparseDataTableEntryPtr2 = MM_SparseDataTableEntryPointer.cast(readSlotIterator.nextAddress());
                        VoidPointer dataPrt = readSparseDataTableEntryPtr2._dataPtr();
                        VoidPointer proxyObjPtr = readSparseDataTableEntryPtr2._proxyObjPtr();
                        UDATA size = readSparseDataTableEntryPtr2._size();
                        out.format(" 0x%016x 0x%016x 0x%016x%n", proxyObjPtr.getAddress(), dataPrt.getAddress(), size.longValue());
                    }
                    out.format("+------------------+------------------+------------------%n", new Object[0]);
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
        catch (NoSuchFieldException e) {
            offHeapPresent = false;
        }
        if (!offHeapPresent) {
            out.format("This command requires a core file in which off-heap is enabled.%n", new Object[0]);
        }
    }

    private static void help(PrintStream out) {
        out.println("!dumpalloffheapentries       -- dump all off-heap entries");
    }
}

