/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.TerseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;

public class ContinuationStackWalkCommand
extends Command {
    public ContinuationStackWalkCommand() {
        this.addCommand("continuationstack", "<continuation>", "Walks the Java stack for <continuation>");
        this.addCommand("continuationstackslots", "<continuation>", "Walks the Java stack (including objects) for <continuation>");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (!JavaVersionHelper.ensureMinimumJavaVersion(19, vm, out)) {
                return;
            }
            if (args.length != 1) {
                CommandUtils.dbgPrint(out, "Exactly one argument (address) must be provided.\n");
                return;
            }
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.J9VM_ENV_DATA64);
            if (0L == address) {
                CommandUtils.dbgPrint(out, "Address must be non-zero.\n");
                return;
            }
            StackWalkerUtils.enableVerboseLogging(3, out);
            WalkState walkState = new WalkState();
            walkState.flags = J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
            if (command.equalsIgnoreCase("!continuationstackslots")) {
                walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_O_SLOTS;
                StackWalkerUtils.enableVerboseLogging(100, out);
                walkState.callBacks = new BaseStackWalkerCallbacks();
            } else {
                StackWalkerUtils.enableVerboseLogging(0, out);
                walkState.callBacks = new TerseStackWalkerCallbacks();
                walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_FRAMES;
            }
            StackWalkResult result = StackWalker.walkStackFrames(walkState, address);
            if (result != StackWalkResult.NONE) {
                out.println("Stack walk result: " + (Object)((Object)result));
            }
            StackWalkerUtils.disableVerboseLogging();
            out.flush();
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

