/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PortVmemIdentifierPointer;
import com.ibm.j9ddr.vm29.structure.J9HeapWrapper;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=J9HeapWrapper.class)
public class J9HeapWrapperPointer
extends StructurePointer {
    public static final J9HeapWrapperPointer NULL = new J9HeapWrapperPointer(0L);

    protected J9HeapWrapperPointer(long address) {
        super(address);
    }

    public static J9HeapWrapperPointer cast(AbstractPointer structure) {
        return J9HeapWrapperPointer.cast(structure.getAddress());
    }

    public static J9HeapWrapperPointer cast(UDATA udata) {
        return J9HeapWrapperPointer.cast(udata.longValue());
    }

    public static J9HeapWrapperPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9HeapWrapperPointer(address);
    }

    @Override
    public J9HeapWrapperPointer add(long count) {
        return J9HeapWrapperPointer.cast(this.address + J9HeapWrapper.SIZEOF * count);
    }

    @Override
    public J9HeapWrapperPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9HeapWrapperPointer addOffset(long offset) {
        return J9HeapWrapperPointer.cast(this.address + offset);
    }

    @Override
    public J9HeapWrapperPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9HeapWrapperPointer sub(long count) {
        return J9HeapWrapperPointer.cast(this.address - J9HeapWrapper.SIZEOF * count);
    }

    @Override
    public J9HeapWrapperPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9HeapWrapperPointer subOffset(long offset) {
        return J9HeapWrapperPointer.cast(this.address - offset);
    }

    @Override
    public J9HeapWrapperPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9HeapWrapperPointer untag(long mask) {
        return J9HeapWrapperPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9HeapWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9HeapWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_heapSizeOffset_", declaredType="uintptr_t")
    public UDATA heapSize() throws CorruptDataException {
        return this.getUDATAAtOffset(J9HeapWrapper._heapSizeOffset_);
    }

    public UDATAPointer heapSizeEA() throws CorruptDataException {
        return UDATAPointer.cast(this.nonNullFieldEA(J9HeapWrapper._heapSizeOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_nextHeapWrapperOffset_", declaredType="struct J9HeapWrapper*")
    public J9HeapWrapperPointer nextHeapWrapper() throws CorruptDataException {
        return J9HeapWrapperPointer.cast(this.getPointerAtOffset(J9HeapWrapper._nextHeapWrapperOffset_));
    }

    public PointerPointer nextHeapWrapperEA() throws CorruptDataException {
        return PointerPointer.cast(this.nonNullFieldEA(J9HeapWrapper._nextHeapWrapperOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_vmemIDOffset_", declaredType="J9PortVmemIdentifier*")
    public J9PortVmemIdentifierPointer vmemID() throws CorruptDataException {
        return J9PortVmemIdentifierPointer.cast(this.getPointerAtOffset(J9HeapWrapper._vmemIDOffset_));
    }

    public PointerPointer vmemIDEA() throws CorruptDataException {
        return PointerPointer.cast(this.nonNullFieldEA(J9HeapWrapper._vmemIDOffset_));
    }
}

